import { ExcalidrawElement } from "../element/types";
import { AppState, BinaryFiles, LibraryItems, LibraryItems_anyVersion } from "../types";
import type { cleanAppStateForExport } from "../appState";
import { VERSIONS } from "../constants";
export interface ExportedDataState {
    type: string;
    version: number;
    source: string;
    elements: readonly ExcalidrawElement[];
    appState: ReturnType<typeof cleanAppStateForExport>;
    files: BinaryFiles | undefined;
}
/**
 * Map of legacy AppState keys, with values of:
 *  [<legacy type>, <new AppState proeprty>]
 *
 * This is a helper type used in downstream abstractions.
 * Don't consume on its own.
 */
export declare type LegacyAppState = {
    /** @deprecated #5663 TODO remove 22-12-15 */
    isLibraryOpen: [boolean, "openSidebar"];
    /** @deprecated #5663 TODO remove 22-12-15 */
    isLibraryMenuDocked: [boolean, "isSidebarDocked"];
};
export interface ImportedDataState {
    type?: string;
    version?: number;
    source?: string;
    elements?: readonly ExcalidrawElement[] | null;
    appState?: Readonly<Partial<AppState & {
        [T in keyof LegacyAppState]: LegacyAppState[T][0];
    }>> | null;
    scrollToContent?: boolean;
    libraryItems?: LibraryItems_anyVersion;
    files?: BinaryFiles;
}
export interface ExportedLibraryData {
    type: string;
    version: typeof VERSIONS.excalidrawLibrary;
    source: string;
    libraryItems: LibraryItems;
}
export interface ImportedLibraryData extends Partial<ExportedLibraryData> {
    /** @deprecated v1 */
    library?: LibraryItems;
}
