"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHeader = (name, req) => req.headers[name];
exports.getRangeHeader = exports.getHeader.bind(null, "range");
exports.setHeader = (name, value, res) => res.setHeader(name, value);
exports.setContentTypeHeader = exports.setHeader.bind(null, "Content-Type");
exports.setContentLengthHeader = exports.setHeader.bind(null, "Content-Length");
exports.setAcceptRangesHeader = exports.setHeader.bind(null, "Accept-Ranges", "bytes");
exports.setContentRangeHeader = (range, size, res) => exports.setHeader("Content-Range", `bytes ${range ? `${range.start}-${range.end}` : "*"}/${size}`, res);
exports.setContentDispositionHeader = (fileName, res) => exports.setHeader("Content-Disposition", `attachment; filename="${fileName}"`, res);
exports.setCacheControlHeaderNoCache = exports.setHeader.bind(null, "Cache-Control", "no-cache");
//# sourceMappingURL=utils.js.map