/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Platform;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.SmallCharMatcher;
import java.util.Arrays;
import java.util.BitSet;
import javax.annotation.CheckReturnValue;

@Beta
@GwtCompatible(emulated=true)
public abstract class CharMatcher
implements Predicate<Character> {
    public static final CharMatcher BREAKING_WHITESPACE = new CharMatcher(){

        @Override
        public boolean matches(char c10) {
            switch (c10) {
                case '\t': 
                case '\n': 
                case '\u000b': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '\u0085': 
                case '\u1680': 
                case '\u2028': 
                case '\u2029': 
                case '\u205f': 
                case '\u3000': {
                    return true;
                }
                case '\u2007': {
                    return false;
                }
            }
            return c10 >= '\u2000' && c10 <= '\u200a';
        }

        @Override
        public String toString() {
            return "CharMatcher.BREAKING_WHITESPACE";
        }
    };
    public static final CharMatcher ASCII = CharMatcher.inRange('\u0000', '\u007f', "CharMatcher.ASCII");
    private static final String ZEROES = "0\u0660\u06f0\u07c0\u0966\u09e6\u0a66\u0ae6\u0b66\u0be6\u0c66\u0ce6\u0d66\u0e50\u0ed0\u0f20\u1040\u1090\u17e0\u1810\u1946\u19d0\u1b50\u1bb0\u1c40\u1c50\ua620\ua8d0\ua900\uaa50\uff10";
    private static final String NINES;
    public static final CharMatcher DIGIT;
    public static final CharMatcher JAVA_DIGIT;
    public static final CharMatcher JAVA_LETTER;
    public static final CharMatcher JAVA_LETTER_OR_DIGIT;
    public static final CharMatcher JAVA_UPPER_CASE;
    public static final CharMatcher JAVA_LOWER_CASE;
    public static final CharMatcher JAVA_ISO_CONTROL;
    public static final CharMatcher INVISIBLE;
    public static final CharMatcher SINGLE_WIDTH;
    public static final CharMatcher ANY;
    public static final CharMatcher NONE;
    final String description;
    private static final int DISTINCT_CHARS = 65536;
    private static final String WHITESPACE_TABLE = "\u0001\u0000\u00a0\u0000\u0000\u0000\u0000\u0000\u0000\t\n\u000b\f\r\u0000\u0000\u2028\u2029\u0000\u0000\u0000\u0000\u0000\u202f\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000 \u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u3000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0000\u0085\u2000\u2001\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u0000\u0000\u0000\u0000\u0000\u205f\u1680\u0000\u0000\u180e\u0000\u0000\u0000";
    public static final CharMatcher WHITESPACE;

    private static String showCharacter(char c10) {
        String hex = "0123456789ABCDEF";
        char[] tmp = new char[]{'\\', 'u', '\u0000', '\u0000', '\u0000', '\u0000'};
        for (int i10 = 0; i10 < 4; ++i10) {
            tmp[5 - i10] = hex.charAt(c10 & 0xF);
            c10 = (char)(c10 >> 4);
        }
        return String.copyValueOf(tmp);
    }

    public static CharMatcher is(final char match) {
        String description = "CharMatcher.is('" + CharMatcher.showCharacter(match) + "')";
        return new FastMatcher(description){

            @Override
            public boolean matches(char c10) {
                return c10 == match;
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                return sequence.toString().replace(match, replacement);
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return other.matches(match) ? this : NONE;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return other.matches(match) ? other : super.or(other);
            }

            @Override
            public CharMatcher negate() {
                return 9.isNot(match);
            }

            @Override
            @GwtIncompatible(value="java.util.BitSet")
            void setBits(BitSet table) {
                table.set(match);
            }
        };
    }

    public static CharMatcher isNot(final char match) {
        String description = "CharMatcher.isNot(" + Integer.toHexString(match) + ")";
        return new FastMatcher(description){

            @Override
            public boolean matches(char c10) {
                return c10 != match;
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return other.matches(match) ? super.and(other) : other;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return other.matches(match) ? ANY : this;
            }

            @Override
            @GwtIncompatible(value="java.util.BitSet")
            void setBits(BitSet table) {
                table.set(0, match);
                table.set(match + '\u0001', 65536);
            }

            @Override
            public CharMatcher negate() {
                return 10.is(match);
            }
        };
    }

    public static CharMatcher anyOf(CharSequence sequence) {
        switch (sequence.length()) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is(sequence.charAt(0));
            }
            case 2: {
                return CharMatcher.isEither(sequence.charAt(0), sequence.charAt(1));
            }
        }
        final char[] chars = sequence.toString().toCharArray();
        Arrays.sort(chars);
        StringBuilder description = new StringBuilder("CharMatcher.anyOf(\"");
        for (char c10 : chars) {
            description.append(CharMatcher.showCharacter(c10));
        }
        description.append("\")");
        return new CharMatcher(description.toString()){

            @Override
            public boolean matches(char c10) {
                return Arrays.binarySearch(chars, c10) >= 0;
            }

            @Override
            @GwtIncompatible(value="java.util.BitSet")
            void setBits(BitSet table) {
                for (char c10 : chars) {
                    table.set(c10);
                }
            }
        };
    }

    private static CharMatcher isEither(final char match1, final char match2) {
        String description = "CharMatcher.anyOf(\"" + CharMatcher.showCharacter(match1) + CharMatcher.showCharacter(match2) + "\")";
        return new FastMatcher(description){

            @Override
            public boolean matches(char c10) {
                return c10 == match1 || c10 == match2;
            }

            @Override
            @GwtIncompatible(value="java.util.BitSet")
            void setBits(BitSet table) {
                table.set(match1);
                table.set(match2);
            }
        };
    }

    public static CharMatcher noneOf(CharSequence sequence) {
        return CharMatcher.anyOf(sequence).negate();
    }

    public static CharMatcher inRange(char startInclusive, char endInclusive) {
        Preconditions.checkArgument(endInclusive >= startInclusive);
        String description = "CharMatcher.inRange('" + CharMatcher.showCharacter(startInclusive) + "', '" + CharMatcher.showCharacter(endInclusive) + "')";
        return CharMatcher.inRange(startInclusive, endInclusive, description);
    }

    static CharMatcher inRange(final char startInclusive, final char endInclusive, String description) {
        return new FastMatcher(description){

            @Override
            public boolean matches(char c10) {
                return startInclusive <= c10 && c10 <= endInclusive;
            }

            @Override
            @GwtIncompatible(value="java.util.BitSet")
            void setBits(BitSet table) {
                table.set((int)startInclusive, endInclusive + '\u0001');
            }
        };
    }

    public static CharMatcher forPredicate(final Predicate<? super Character> predicate) {
        Preconditions.checkNotNull(predicate);
        if (predicate instanceof CharMatcher) {
            return (CharMatcher)predicate;
        }
        String description = "CharMatcher.forPredicate(" + predicate + ")";
        return new CharMatcher(description){

            @Override
            public boolean matches(char c10) {
                return predicate.apply(Character.valueOf(c10));
            }

            @Override
            public boolean apply(Character character) {
                return predicate.apply(Preconditions.checkNotNull(character));
            }
        };
    }

    CharMatcher(String description) {
        this.description = description;
    }

    protected CharMatcher() {
        this.description = super.toString();
    }

    public abstract boolean matches(char var1);

    public CharMatcher negate() {
        return new NegatedMatcher(this);
    }

    public CharMatcher and(CharMatcher other) {
        return new And(this, Preconditions.checkNotNull(other));
    }

    public CharMatcher or(CharMatcher other) {
        return new Or(this, Preconditions.checkNotNull(other));
    }

    public CharMatcher precomputed() {
        return Platform.precomputeCharMatcher(this);
    }

    CharMatcher withToString(String description) {
        throw new UnsupportedOperationException();
    }

    @GwtIncompatible(value="java.util.BitSet")
    CharMatcher precomputedInternal() {
        BitSet table = new BitSet();
        this.setBits(table);
        int totalCharacters = table.cardinality();
        if (totalCharacters * 2 <= 65536) {
            return CharMatcher.precomputedPositive(totalCharacters, table, this.description);
        }
        table.flip(0, 65536);
        int negatedCharacters = 65536 - totalCharacters;
        return new NegatedFastMatcher(this.toString(), CharMatcher.precomputedPositive(negatedCharacters, table, this.description + ".negate()"));
    }

    @GwtIncompatible(value="java.util.BitSet")
    private static CharMatcher precomputedPositive(int totalCharacters, BitSet table, String description) {
        switch (totalCharacters) {
            case 0: {
                return NONE;
            }
            case 1: {
                return CharMatcher.is((char)table.nextSetBit(0));
            }
            case 2: {
                char c12 = (char)table.nextSetBit(0);
                char c22 = (char)table.nextSetBit(c12 + '\u0001');
                return CharMatcher.isEither(c12, c22);
            }
        }
        return CharMatcher.isSmall(totalCharacters, table.length()) ? SmallCharMatcher.from(table, description) : new BitSetMatcher(table, description);
    }

    private static boolean isSmall(int totalCharacters, int tableLength) {
        return totalCharacters <= 1023 && tableLength > totalCharacters * 16;
    }

    @GwtIncompatible(value="java.util.BitSet")
    void setBits(BitSet table) {
        for (int c10 = 65535; c10 >= 0; --c10) {
            if (!this.matches((char)c10)) continue;
            table.set(c10);
        }
    }

    public boolean matchesAnyOf(CharSequence sequence) {
        return !this.matchesNoneOf(sequence);
    }

    public boolean matchesAllOf(CharSequence sequence) {
        for (int i10 = sequence.length() - 1; i10 >= 0; --i10) {
            if (this.matches(sequence.charAt(i10))) continue;
            return false;
        }
        return true;
    }

    public boolean matchesNoneOf(CharSequence sequence) {
        return this.indexIn(sequence) == -1;
    }

    public int indexIn(CharSequence sequence) {
        int length = sequence.length();
        for (int i10 = 0; i10 < length; ++i10) {
            if (!this.matches(sequence.charAt(i10))) continue;
            return i10;
        }
        return -1;
    }

    public int indexIn(CharSequence sequence, int start) {
        int length = sequence.length();
        Preconditions.checkPositionIndex(start, length);
        for (int i10 = start; i10 < length; ++i10) {
            if (!this.matches(sequence.charAt(i10))) continue;
            return i10;
        }
        return -1;
    }

    public int lastIndexIn(CharSequence sequence) {
        for (int i10 = sequence.length() - 1; i10 >= 0; --i10) {
            if (!this.matches(sequence.charAt(i10))) continue;
            return i10;
        }
        return -1;
    }

    public int countIn(CharSequence sequence) {
        int count = 0;
        for (int i10 = 0; i10 < sequence.length(); ++i10) {
            if (!this.matches(sequence.charAt(i10))) continue;
            ++count;
        }
        return count;
    }

    @CheckReturnValue
    public String removeFrom(CharSequence sequence) {
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        int spread = 1;
        block0: while (true) {
            ++pos;
            while (pos != chars.length) {
                if (!this.matches(chars[pos])) {
                    chars[pos - spread] = chars[pos];
                    ++pos;
                    continue;
                }
                ++spread;
                continue block0;
            }
            break;
        }
        return new String(chars, 0, pos - spread);
    }

    @CheckReturnValue
    public String retainFrom(CharSequence sequence) {
        return this.negate().removeFrom(sequence);
    }

    @CheckReturnValue
    public String replaceFrom(CharSequence sequence, char replacement) {
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[pos] = replacement;
        for (int i10 = pos + 1; i10 < chars.length; ++i10) {
            if (!this.matches(chars[i10])) continue;
            chars[i10] = replacement;
        }
        return new String(chars);
    }

    @CheckReturnValue
    public String replaceFrom(CharSequence sequence, CharSequence replacement) {
        int replacementLen = replacement.length();
        if (replacementLen == 0) {
            return this.removeFrom(sequence);
        }
        if (replacementLen == 1) {
            return this.replaceFrom(sequence, replacement.charAt(0));
        }
        String string = sequence.toString();
        int pos = this.indexIn(string);
        if (pos == -1) {
            return string;
        }
        int len = string.length();
        StringBuilder buf = new StringBuilder(len * 3 / 2 + 16);
        int oldpos = 0;
        do {
            buf.append(string, oldpos, pos);
            buf.append(replacement);
        } while ((pos = this.indexIn(string, oldpos = pos + 1)) != -1);
        buf.append(string, oldpos, len);
        return buf.toString();
    }

    @CheckReturnValue
    public String trimFrom(CharSequence sequence) {
        int last;
        int first;
        int len = sequence.length();
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        for (last = len - 1; last > first && this.matches(sequence.charAt(last)); --last) {
        }
        return sequence.subSequence(first, last + 1).toString();
    }

    @CheckReturnValue
    public String trimLeadingFrom(CharSequence sequence) {
        int len = sequence.length();
        for (int first = 0; first < len; ++first) {
            if (this.matches(sequence.charAt(first))) continue;
            return sequence.subSequence(first, len).toString();
        }
        return "";
    }

    @CheckReturnValue
    public String trimTrailingFrom(CharSequence sequence) {
        int len = sequence.length();
        for (int last = len - 1; last >= 0; --last) {
            if (this.matches(sequence.charAt(last))) continue;
            return sequence.subSequence(0, last + 1).toString();
        }
        return "";
    }

    @CheckReturnValue
    public String collapseFrom(CharSequence sequence, char replacement) {
        int len = sequence.length();
        for (int i10 = 0; i10 < len; ++i10) {
            char c10 = sequence.charAt(i10);
            if (!this.matches(c10)) continue;
            if (!(c10 != replacement || i10 != len - 1 && this.matches(sequence.charAt(i10 + 1)))) {
                ++i10;
                continue;
            }
            StringBuilder builder = new StringBuilder(len).append(sequence.subSequence(0, i10)).append(replacement);
            return this.finishCollapseFrom(sequence, i10 + 1, len, replacement, builder, true);
        }
        return sequence.toString();
    }

    @CheckReturnValue
    public String trimAndCollapseFrom(CharSequence sequence, char replacement) {
        int last;
        int first;
        int len = sequence.length();
        for (first = 0; first < len && this.matches(sequence.charAt(first)); ++first) {
        }
        for (last = len - 1; last > first && this.matches(sequence.charAt(last)); --last) {
        }
        return first == 0 && last == len - 1 ? this.collapseFrom(sequence, replacement) : this.finishCollapseFrom(sequence, first, last + 1, replacement, new StringBuilder(last + 1 - first), false);
    }

    private String finishCollapseFrom(CharSequence sequence, int start, int end, char replacement, StringBuilder builder, boolean inMatchingGroup) {
        for (int i10 = start; i10 < end; ++i10) {
            char c10 = sequence.charAt(i10);
            if (this.matches(c10)) {
                if (inMatchingGroup) continue;
                builder.append(replacement);
                inMatchingGroup = true;
                continue;
            }
            builder.append(c10);
            inMatchingGroup = false;
        }
        return builder.toString();
    }

    @Override
    public boolean apply(Character character) {
        return this.matches(character.charValue());
    }

    public String toString() {
        return this.description;
    }

    static {
        StringBuilder builder = new StringBuilder(ZEROES.length());
        for (int i10 = 0; i10 < ZEROES.length(); ++i10) {
            builder.append((char)(ZEROES.charAt(i10) + 9));
        }
        NINES = builder.toString();
        DIGIT = new RangesMatcher("CharMatcher.DIGIT", ZEROES.toCharArray(), NINES.toCharArray());
        JAVA_DIGIT = new CharMatcher("CharMatcher.JAVA_DIGIT"){

            @Override
            public boolean matches(char c10) {
                return Character.isDigit(c10);
            }
        };
        JAVA_LETTER = new CharMatcher("CharMatcher.JAVA_LETTER"){

            @Override
            public boolean matches(char c10) {
                return Character.isLetter(c10);
            }
        };
        JAVA_LETTER_OR_DIGIT = new CharMatcher("CharMatcher.JAVA_LETTER_OR_DIGIT"){

            @Override
            public boolean matches(char c10) {
                return Character.isLetterOrDigit(c10);
            }
        };
        JAVA_UPPER_CASE = new CharMatcher("CharMatcher.JAVA_UPPER_CASE"){

            @Override
            public boolean matches(char c10) {
                return Character.isUpperCase(c10);
            }
        };
        JAVA_LOWER_CASE = new CharMatcher("CharMatcher.JAVA_LOWER_CASE"){

            @Override
            public boolean matches(char c10) {
                return Character.isLowerCase(c10);
            }
        };
        JAVA_ISO_CONTROL = CharMatcher.inRange('\u0000', '\u001f').or(CharMatcher.inRange('\u007f', '\u009f')).withToString("CharMatcher.JAVA_ISO_CONTROL");
        INVISIBLE = new RangesMatcher("CharMatcher.INVISIBLE", "\u0000\u007f\u00ad\u0600\u06dd\u070f\u1680\u180e\u2000\u2028\u205f\u206a\u3000\ud800\ufeff\ufff9\ufffa".toCharArray(), " \u00a0\u00ad\u0604\u06dd\u070f\u1680\u180e\u200f\u202f\u2064\u206f\u3000\uf8ff\ufeff\ufff9\ufffb".toCharArray());
        SINGLE_WIDTH = new RangesMatcher("CharMatcher.SINGLE_WIDTH", "\u0000\u05be\u05d0\u05f3\u0600\u0750\u0e00\u1e00\u2100\ufb50\ufe70\uff61".toCharArray(), "\u04f9\u05be\u05ea\u05f4\u06ff\u077f\u0e7f\u20af\u213a\ufdff\ufeff\uffdc".toCharArray());
        ANY = new FastMatcher("CharMatcher.ANY"){

            @Override
            public boolean matches(char c10) {
                return true;
            }

            @Override
            public int indexIn(CharSequence sequence) {
                return sequence.length() == 0 ? -1 : 0;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                return start == length ? -1 : start;
            }

            @Override
            public int lastIndexIn(CharSequence sequence) {
                return sequence.length() - 1;
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            @Override
            public String removeFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                char[] array = new char[sequence.length()];
                Arrays.fill(array, replacement);
                return new String(array);
            }

            @Override
            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                StringBuilder retval = new StringBuilder(sequence.length() * replacement.length());
                for (int i10 = 0; i10 < sequence.length(); ++i10) {
                    retval.append(replacement);
                }
                return retval.toString();
            }

            @Override
            public String collapseFrom(CharSequence sequence, char replacement) {
                return sequence.length() == 0 ? "" : String.valueOf(replacement);
            }

            @Override
            public String trimFrom(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return "";
            }

            @Override
            public int countIn(CharSequence sequence) {
                return sequence.length();
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            @Override
            public CharMatcher negate() {
                return NONE;
            }
        };
        NONE = new FastMatcher("CharMatcher.NONE"){

            @Override
            public boolean matches(char c10) {
                return false;
            }

            @Override
            public int indexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            @Override
            public int indexIn(CharSequence sequence, int start) {
                int length = sequence.length();
                Preconditions.checkPositionIndex(start, length);
                return -1;
            }

            @Override
            public int lastIndexIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return -1;
            }

            @Override
            public boolean matchesAllOf(CharSequence sequence) {
                return sequence.length() == 0;
            }

            @Override
            public boolean matchesNoneOf(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return true;
            }

            @Override
            public String removeFrom(CharSequence sequence) {
                return sequence.toString();
            }

            @Override
            public String replaceFrom(CharSequence sequence, char replacement) {
                return sequence.toString();
            }

            @Override
            public String replaceFrom(CharSequence sequence, CharSequence replacement) {
                Preconditions.checkNotNull(replacement);
                return sequence.toString();
            }

            @Override
            public String collapseFrom(CharSequence sequence, char replacement) {
                return sequence.toString();
            }

            @Override
            public String trimFrom(CharSequence sequence) {
                return sequence.toString();
            }

            @Override
            public String trimLeadingFrom(CharSequence sequence) {
                return sequence.toString();
            }

            @Override
            public String trimTrailingFrom(CharSequence sequence) {
                return sequence.toString();
            }

            @Override
            public int countIn(CharSequence sequence) {
                Preconditions.checkNotNull(sequence);
                return 0;
            }

            @Override
            public CharMatcher and(CharMatcher other) {
                Preconditions.checkNotNull(other);
                return this;
            }

            @Override
            public CharMatcher or(CharMatcher other) {
                return Preconditions.checkNotNull(other);
            }

            @Override
            public CharMatcher negate() {
                return ANY;
            }
        };
        WHITESPACE = new FastMatcher("CharMatcher.WHITESPACE"){

            @Override
            public boolean matches(char c10) {
                return CharMatcher.WHITESPACE_TABLE.charAt(c10 % 79) == c10;
            }
        };
    }

    private static class And
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        And(CharMatcher a10, CharMatcher b10) {
            this(a10, b10, "CharMatcher.and(" + a10 + ", " + b10 + ")");
        }

        And(CharMatcher a10, CharMatcher b10, String description) {
            super(description);
            this.first = Preconditions.checkNotNull(a10);
            this.second = Preconditions.checkNotNull(b10);
        }

        @Override
        public boolean matches(char c10) {
            return this.first.matches(c10) && this.second.matches(c10);
        }

        @Override
        @GwtIncompatible(value="java.util.BitSet")
        void setBits(BitSet table) {
            BitSet tmp1 = new BitSet();
            this.first.setBits(tmp1);
            BitSet tmp2 = new BitSet();
            this.second.setBits(tmp2);
            tmp1.and(tmp2);
            table.or(tmp1);
        }

        @Override
        CharMatcher withToString(String description) {
            return new And(this.first, this.second, description);
        }
    }

    @GwtIncompatible(value="java.util.BitSet")
    private static class BitSetMatcher
    extends FastMatcher {
        private final BitSet table;

        private BitSetMatcher(BitSet table, String description) {
            super(description);
            if (table.length() + 64 < table.size()) {
                table = (BitSet)table.clone();
            }
            this.table = table;
        }

        @Override
        public boolean matches(char c10) {
            return this.table.get(c10);
        }

        @Override
        void setBits(BitSet bitSet) {
            bitSet.or(this.table);
        }
    }

    static abstract class FastMatcher
    extends CharMatcher {
        FastMatcher() {
        }

        FastMatcher(String description) {
            super(description);
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }

        @Override
        public CharMatcher negate() {
            return new NegatedFastMatcher(this);
        }
    }

    static final class NegatedFastMatcher
    extends NegatedMatcher {
        NegatedFastMatcher(CharMatcher original) {
            super(original);
        }

        NegatedFastMatcher(String toString, CharMatcher original) {
            super(toString, original);
        }

        @Override
        public final CharMatcher precomputed() {
            return this;
        }

        @Override
        CharMatcher withToString(String description) {
            return new NegatedFastMatcher(description, this.original);
        }
    }

    private static class NegatedMatcher
    extends CharMatcher {
        final CharMatcher original;

        NegatedMatcher(String toString, CharMatcher original) {
            super(toString);
            this.original = original;
        }

        NegatedMatcher(CharMatcher original) {
            this(original + ".negate()", original);
        }

        @Override
        public boolean matches(char c10) {
            return !this.original.matches(c10);
        }

        @Override
        public boolean matchesAllOf(CharSequence sequence) {
            return this.original.matchesNoneOf(sequence);
        }

        @Override
        public boolean matchesNoneOf(CharSequence sequence) {
            return this.original.matchesAllOf(sequence);
        }

        @Override
        public int countIn(CharSequence sequence) {
            return sequence.length() - this.original.countIn(sequence);
        }

        @Override
        @GwtIncompatible(value="java.util.BitSet")
        void setBits(BitSet table) {
            BitSet tmp = new BitSet();
            this.original.setBits(tmp);
            tmp.flip(0, 65536);
            table.or(tmp);
        }

        @Override
        public CharMatcher negate() {
            return this.original;
        }

        @Override
        CharMatcher withToString(String description) {
            return new NegatedMatcher(description, this.original);
        }
    }

    private static class Or
    extends CharMatcher {
        final CharMatcher first;
        final CharMatcher second;

        Or(CharMatcher a10, CharMatcher b10, String description) {
            super(description);
            this.first = Preconditions.checkNotNull(a10);
            this.second = Preconditions.checkNotNull(b10);
        }

        Or(CharMatcher a10, CharMatcher b10) {
            this(a10, b10, "CharMatcher.or(" + a10 + ", " + b10 + ")");
        }

        @Override
        @GwtIncompatible(value="java.util.BitSet")
        void setBits(BitSet table) {
            this.first.setBits(table);
            this.second.setBits(table);
        }

        @Override
        public boolean matches(char c10) {
            return this.first.matches(c10) || this.second.matches(c10);
        }

        @Override
        CharMatcher withToString(String description) {
            return new Or(this.first, this.second, description);
        }
    }

    private static class RangesMatcher
    extends CharMatcher {
        private final char[] rangeStarts;
        private final char[] rangeEnds;

        RangesMatcher(String description, char[] rangeStarts, char[] rangeEnds) {
            super(description);
            this.rangeStarts = rangeStarts;
            this.rangeEnds = rangeEnds;
            Preconditions.checkArgument(rangeStarts.length == rangeEnds.length);
            for (int i10 = 0; i10 < rangeStarts.length; ++i10) {
                Preconditions.checkArgument(rangeStarts[i10] <= rangeEnds[i10]);
                if (i10 + 1 >= rangeStarts.length) continue;
                Preconditions.checkArgument(rangeEnds[i10] < rangeStarts[i10 + 1]);
            }
        }

        @Override
        public boolean matches(char c10) {
            int index = Arrays.binarySearch(this.rangeStarts, c10);
            if (index >= 0) {
                return true;
            }
            return (index = ~index - 1) >= 0 && c10 <= this.rangeEnds[index];
        }
    }
}

