/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.base;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;

@GwtCompatible
public final class Strings {
    private Strings() {
    }

    public static String nullToEmpty(@Nullable String string) {
        return string == null ? "" : string;
    }

    @Nullable
    public static String emptyToNull(@Nullable String string) {
        return Strings.isNullOrEmpty(string) ? null : string;
    }

    public static boolean isNullOrEmpty(@Nullable String string) {
        return string == null || string.length() == 0;
    }

    public static String padStart(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb2 = new StringBuilder(minLength);
        for (int i10 = string.length(); i10 < minLength; ++i10) {
            sb2.append(padChar);
        }
        sb2.append(string);
        return sb2.toString();
    }

    public static String padEnd(String string, int minLength, char padChar) {
        Preconditions.checkNotNull(string);
        if (string.length() >= minLength) {
            return string;
        }
        StringBuilder sb2 = new StringBuilder(minLength);
        sb2.append(string);
        for (int i10 = string.length(); i10 < minLength; ++i10) {
            sb2.append(padChar);
        }
        return sb2.toString();
    }

    public static String repeat(String string, int count) {
        int n10;
        Preconditions.checkNotNull(string);
        if (count <= 1) {
            Preconditions.checkArgument(count >= 0, "invalid count: %s", count);
            return count == 0 ? "" : string;
        }
        int len = string.length();
        long longSize = (long)len * (long)count;
        int size = (int)longSize;
        if ((long)size != longSize) {
            throw new ArrayIndexOutOfBoundsException("Required array size too large: " + String.valueOf(longSize));
        }
        char[] array = new char[size];
        string.getChars(0, len, array, 0);
        for (n10 = len; n10 < size - n10; n10 <<= 1) {
            System.arraycopy(array, 0, array, n10, n10);
        }
        System.arraycopy(array, 0, array, n10, size - n10);
        return new String(array);
    }

    public static String commonPrefix(CharSequence a10, CharSequence b10) {
        int p10;
        Preconditions.checkNotNull(a10);
        Preconditions.checkNotNull(b10);
        int maxPrefixLength = Math.min(a10.length(), b10.length());
        for (p10 = 0; p10 < maxPrefixLength && a10.charAt(p10) == b10.charAt(p10); ++p10) {
        }
        if (Strings.validSurrogatePairAt(a10, p10 - 1) || Strings.validSurrogatePairAt(b10, p10 - 1)) {
            --p10;
        }
        return a10.subSequence(0, p10).toString();
    }

    public static String commonSuffix(CharSequence a10, CharSequence b10) {
        int s10;
        Preconditions.checkNotNull(a10);
        Preconditions.checkNotNull(b10);
        int maxSuffixLength = Math.min(a10.length(), b10.length());
        for (s10 = 0; s10 < maxSuffixLength && a10.charAt(a10.length() - s10 - 1) == b10.charAt(b10.length() - s10 - 1); ++s10) {
        }
        if (Strings.validSurrogatePairAt(a10, a10.length() - s10 - 1) || Strings.validSurrogatePairAt(b10, b10.length() - s10 - 1)) {
            --s10;
        }
        return a10.subSequence(a10.length() - s10, a10.length()).toString();
    }

    @VisibleForTesting
    static boolean validSurrogatePairAt(CharSequence string, int index) {
        return index >= 0 && index <= string.length() - 2 && Character.isHighSurrogate(string.charAt(index)) && Character.isLowSurrogate(string.charAt(index + 1));
    }
}

