/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import com.google.common.annotations.GwtCompatible;
import com.google.common.cache.LongAddable;
import com.google.common.cache.Striped64;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

@GwtCompatible(emulated=true)
final class LongAdder
extends Striped64
implements Serializable,
LongAddable {
    private static final long serialVersionUID = 7249069246863182397L;

    @Override
    final long fn(long v10, long x10) {
        return v10 + x10;
    }

    @Override
    public void add(long x10) {
        long b10;
        Striped64.Cell[] as2 = this.cells;
        if (this.cells != null || !this.casBase(b10 = this.base, b10 + x10)) {
            long v10;
            Striped64.Cell a10;
            int n10;
            boolean uncontended = true;
            Striped64.HashCode hc2 = (Striped64.HashCode)threadHashCode.get();
            int h10 = hc2.code;
            if (as2 == null || (n10 = as2.length) < 1 || (a10 = as2[n10 - 1 & h10]) == null || !(uncontended = a10.cas(v10 = a10.value, v10 + x10))) {
                this.retryUpdate(x10, hc2, uncontended);
            }
        }
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    public void decrement() {
        this.add(-1L);
    }

    @Override
    public long sum() {
        long sum = this.base;
        Striped64.Cell[] as2 = this.cells;
        if (as2 != null) {
            for (Striped64.Cell a10 : as2) {
                if (a10 == null) continue;
                sum += a10.value;
            }
        }
        return sum;
    }

    public void reset() {
        this.internalReset(0L);
    }

    public long sumThenReset() {
        long sum = this.base;
        Striped64.Cell[] as2 = this.cells;
        this.base = 0L;
        if (as2 != null) {
            for (Striped64.Cell a10 : as2) {
                if (a10 == null) continue;
                sum += a10.value;
                a10.value = 0L;
            }
        }
        return sum;
    }

    public String toString() {
        return Long.toString(this.sum());
    }

    @Override
    public long longValue() {
        return this.sum();
    }

    @Override
    public int intValue() {
        return (int)this.sum();
    }

    @Override
    public float floatValue() {
        return this.sum();
    }

    @Override
    public double doubleValue() {
        return this.sum();
    }

    private void writeObject(ObjectOutputStream s10) throws IOException {
        s10.defaultWriteObject();
        s10.writeLong(this.sum());
    }

    private void readObject(ObjectInputStream s10) throws IOException, ClassNotFoundException {
        s10.defaultReadObject();
        this.busy = 0;
        this.cells = null;
        this.base = s10.readLong();
    }
}

