/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.cache;

import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Random;
import sun.misc.Unsafe;

abstract class Striped64
extends Number {
    static final ThreadHashCode threadHashCode = new ThreadHashCode();
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    volatile transient Cell[] cells;
    volatile transient long base;
    volatile transient int busy;
    private static final Unsafe UNSAFE;
    private static final long baseOffset;
    private static final long busyOffset;

    Striped64() {
    }

    final boolean casBase(long cmp, long val) {
        return UNSAFE.compareAndSwapLong(this, baseOffset, cmp, val);
    }

    final boolean casBusy() {
        return UNSAFE.compareAndSwapInt(this, busyOffset, 0, 1);
    }

    abstract long fn(long var1, long var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void retryUpdate(long x10, HashCode hc2, boolean wasUncontended) {
        int h10 = hc2.code;
        boolean collide = false;
        while (true) {
            long v10;
            int n10;
            Cell[] as2 = this.cells;
            if (this.cells != null && (n10 = as2.length) > 0) {
                Cell a10 = as2[n10 - 1 & h10];
                if (a10 == null) {
                    if (this.busy == 0) {
                        Cell r10 = new Cell(x10);
                        if (this.busy == 0 && this.casBusy()) {
                            boolean created = false;
                            try {
                                int j10;
                                int m10;
                                Cell[] rs2 = this.cells;
                                if (this.cells != null && (m10 = rs2.length) > 0 && rs2[j10 = m10 - 1 & h10] == null) {
                                    rs2[j10] = r10;
                                    created = true;
                                }
                            }
                            finally {
                                this.busy = 0;
                            }
                            if (!created) continue;
                            break;
                        }
                    }
                    collide = false;
                } else if (!wasUncontended) {
                    wasUncontended = true;
                } else {
                    v10 = a10.value;
                    if (a10.cas(v10, this.fn(v10, x10))) break;
                    if (n10 >= NCPU || this.cells != as2) {
                        collide = false;
                    } else if (!collide) {
                        collide = true;
                    } else if (this.busy == 0 && this.casBusy()) {
                        try {
                            if (this.cells == as2) {
                                Cell[] rs3 = new Cell[n10 << 1];
                                for (int i10 = 0; i10 < n10; ++i10) {
                                    rs3[i10] = as2[i10];
                                }
                                this.cells = rs3;
                            }
                        }
                        finally {
                            this.busy = 0;
                        }
                        collide = false;
                        continue;
                    }
                }
                h10 ^= h10 << 13;
                h10 ^= h10 >>> 17;
                h10 ^= h10 << 5;
                continue;
            }
            if (this.busy == 0 && this.cells == as2 && this.casBusy()) {
                boolean init = false;
                try {
                    if (this.cells == as2) {
                        Cell[] rs4 = new Cell[2];
                        rs4[h10 & 1] = new Cell(x10);
                        this.cells = rs4;
                        init = true;
                    }
                }
                finally {
                    this.busy = 0;
                }
                if (!init) continue;
                break;
            }
            v10 = this.base;
            if (this.casBase(v10, this.fn(v10, x10))) break;
        }
        hc2.code = h10;
    }

    final void internalReset(long initialValue) {
        Cell[] as2 = this.cells;
        this.base = initialValue;
        if (as2 != null) {
            for (Cell a10 : as2) {
                if (a10 == null) continue;
                a10.value = initialValue;
            }
        }
    }

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (SecurityException tryReflectionInstead) {
            try {
                return AccessController.doPrivileged(new PrivilegedExceptionAction<Unsafe>(){

                    @Override
                    public Unsafe run() throws Exception {
                        Class<Unsafe> k10 = Unsafe.class;
                        for (Field f10 : k10.getDeclaredFields()) {
                            f10.setAccessible(true);
                            Object x10 = f10.get(null);
                            if (!k10.isInstance(x10)) continue;
                            return (Unsafe)k10.cast(x10);
                        }
                        throw new NoSuchFieldError("the Unsafe");
                    }
                });
            }
            catch (PrivilegedActionException e10) {
                throw new RuntimeException("Could not initialize intrinsics", e10.getCause());
            }
        }
    }

    static {
        try {
            UNSAFE = Striped64.getUnsafe();
            Class<Striped64> sk2 = Striped64.class;
            baseOffset = UNSAFE.objectFieldOffset(sk2.getDeclaredField("base"));
            busyOffset = UNSAFE.objectFieldOffset(sk2.getDeclaredField("busy"));
        }
        catch (Exception e10) {
            throw new Error(e10);
        }
    }

    static final class Cell {
        volatile long p0;
        volatile long p1;
        volatile long p2;
        volatile long p3;
        volatile long p4;
        volatile long p5;
        volatile long p6;
        volatile long value;
        volatile long q0;
        volatile long q1;
        volatile long q2;
        volatile long q3;
        volatile long q4;
        volatile long q5;
        volatile long q6;
        private static final Unsafe UNSAFE;
        private static final long valueOffset;

        Cell(long x10) {
            this.value = x10;
        }

        final boolean cas(long cmp, long val) {
            return UNSAFE.compareAndSwapLong(this, valueOffset, cmp, val);
        }

        static {
            try {
                UNSAFE = Striped64.getUnsafe();
                Class<Cell> ak10 = Cell.class;
                valueOffset = UNSAFE.objectFieldOffset(ak10.getDeclaredField("value"));
            }
            catch (Exception e10) {
                throw new Error(e10);
            }
        }
    }

    static final class HashCode {
        static final Random rng = new Random();
        int code;

        HashCode() {
            int h10 = rng.nextInt();
            this.code = h10 == 0 ? 1 : h10;
        }
    }

    static final class ThreadHashCode
    extends ThreadLocal<HashCode> {
        ThreadHashCode() {
        }

        @Override
        public HashCode initialValue() {
            return new HashCode();
        }
    }
}

