/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.EmptyImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.RegularImmutableBiMap;
import com.google.common.collect.SingletonImmutableBiMap;
import java.util.Collection;
import java.util.Map;

@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableBiMap<K, V>
extends ImmutableMap<K, V>
implements BiMap<K, V> {
    public static <K, V> ImmutableBiMap<K, V> of() {
        return EmptyImmutableBiMap.INSTANCE;
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12) {
        Preconditions.checkNotNull(k12, "null key in entry: null=%s", v12);
        Preconditions.checkNotNull(v12, "null value in entry: %s=null", k12);
        return new SingletonImmutableBiMap<K, V>(k12, v12);
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22) {
        return ((Builder)((Builder)new Builder().put((Object)k12, (Object)v12)).put((Object)k22, (Object)v22)).build();
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32) {
        return ((Builder)((Builder)((Builder)new Builder().put((Object)k12, (Object)v12)).put((Object)k22, (Object)v22)).put((Object)k32, (Object)v32)).build();
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32, K k42, V v42) {
        return ((Builder)((Builder)((Builder)((Builder)new Builder().put((Object)k12, (Object)v12)).put((Object)k22, (Object)v22)).put((Object)k32, (Object)v32)).put((Object)k42, (Object)v42)).build();
    }

    public static <K, V> ImmutableBiMap<K, V> of(K k12, V v12, K k22, V v22, K k32, V v32, K k42, V v42, K k52, V v52) {
        return ((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().put((Object)k12, (Object)v12)).put((Object)k22, (Object)v22)).put((Object)k32, (Object)v32)).put((Object)k42, (Object)v42)).put((Object)k52, (Object)v52)).build();
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> ImmutableBiMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        ImmutableBiMap bimap;
        if (map instanceof ImmutableBiMap && !(bimap = (ImmutableBiMap)map).isPartialView()) {
            return bimap;
        }
        return ImmutableBiMap.fromEntries(ImmutableList.copyOf(map.entrySet()));
    }

    static <K, V> ImmutableBiMap<K, V> fromEntries(Collection<? extends Map.Entry<? extends K, ? extends V>> entries) {
        switch (entries.size()) {
            case 0: {
                return ImmutableBiMap.of();
            }
            case 1: {
                Map.Entry<K, V> entry = Iterables.getOnlyElement(entries);
                return new SingletonImmutableBiMap<K, V>(entry.getKey(), entry.getValue());
            }
        }
        return new RegularImmutableBiMap(entries);
    }

    ImmutableBiMap() {
    }

    @Override
    public abstract ImmutableBiMap<V, K> inverse();

    @Override
    public ImmutableSet<V> values() {
        return ((ImmutableMap)((Object)this.inverse())).keySet();
    }

    @Override
    @Deprecated
    public V forcePut(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    public static final class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        @Override
        public Builder<K, V> put(K key, V value) {
            super.put(key, value);
            return this;
        }

        @Override
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            super.putAll(map);
            return this;
        }

        @Override
        public ImmutableBiMap<K, V> build() {
            return ImmutableBiMap.fromEntries(this.entries);
        }
    }

    private static class SerializedForm
    extends ImmutableMap.SerializedForm {
        private static final long serialVersionUID = 0L;

        SerializedForm(ImmutableBiMap<?, ?> bimap) {
            super(bimap);
        }

        @Override
        Object readResolve() {
            Builder<Object, Object> builder = new Builder<Object, Object>();
            return this.createMap(builder);
        }
    }
}

