/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.base.Preconditions;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

class EventHandler {
    private final Object target;
    private final Method method;

    EventHandler(Object target, Method method) {
        Preconditions.checkNotNull(target, "EventHandler target cannot be null.");
        Preconditions.checkNotNull(method, "EventHandler method cannot be null.");
        this.target = target;
        this.method = method;
        method.setAccessible(true);
    }

    public void handleEvent(Object event) throws InvocationTargetException {
        Preconditions.checkNotNull(event);
        try {
            this.method.invoke(this.target, event);
        }
        catch (IllegalArgumentException e10) {
            throw new Error("Method rejected target/argument: " + event, e10);
        }
        catch (IllegalAccessException e11) {
            throw new Error("Method became inaccessible: " + event, e11);
        }
        catch (InvocationTargetException e12) {
            if (e12.getCause() instanceof Error) {
                throw (Error)e12.getCause();
            }
            throw e12;
        }
    }

    public String toString() {
        return "[wrapper " + this.method + "]";
    }

    public int hashCode() {
        int PRIME = 31;
        return (31 + this.method.hashCode()) * 31 + System.identityHashCode(this.target);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof EventHandler) {
            EventHandler that = (EventHandler)obj;
            return this.target == that.target && this.method.equals(that.method);
        }
        return false;
    }
}

