/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractHasher;
import com.google.common.hash.Funnel;
import com.google.common.hash.Hasher;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

abstract class AbstractByteHasher
extends AbstractHasher {
    private final ByteBuffer scratch = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);

    AbstractByteHasher() {
    }

    protected abstract void update(byte var1);

    protected void update(byte[] b10) {
        this.update(b10, 0, b10.length);
    }

    protected void update(byte[] b10, int off, int len) {
        for (int i10 = off; i10 < off + len; ++i10) {
            this.update(b10[i10]);
        }
    }

    @Override
    public Hasher putByte(byte b10) {
        this.update(b10);
        return this;
    }

    @Override
    public Hasher putBytes(byte[] bytes) {
        Preconditions.checkNotNull(bytes);
        this.update(bytes);
        return this;
    }

    @Override
    public Hasher putBytes(byte[] bytes, int off, int len) {
        Preconditions.checkPositionIndexes(off, off + len, bytes.length);
        this.update(bytes, off, len);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Hasher update(int bytes) {
        try {
            this.update(this.scratch.array(), 0, bytes);
        }
        finally {
            this.scratch.clear();
        }
        return this;
    }

    @Override
    public Hasher putShort(short s10) {
        this.scratch.putShort(s10);
        return this.update(2);
    }

    @Override
    public Hasher putInt(int i10) {
        this.scratch.putInt(i10);
        return this.update(4);
    }

    @Override
    public Hasher putLong(long l10) {
        this.scratch.putLong(l10);
        return this.update(8);
    }

    @Override
    public Hasher putChar(char c10) {
        this.scratch.putChar(c10);
        return this.update(2);
    }

    @Override
    public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
        funnel.funnel(instance, this);
        return this;
    }
}

