/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.base.Preconditions;
import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hasher;
import java.nio.charset.Charset;

abstract class AbstractCompositeHashFunction
extends AbstractStreamingHashFunction {
    final HashFunction[] functions;
    private static final long serialVersionUID = 0L;

    AbstractCompositeHashFunction(HashFunction ... functions) {
        for (HashFunction function : functions) {
            Preconditions.checkNotNull(function);
        }
        this.functions = functions;
    }

    abstract HashCode makeHash(Hasher[] var1);

    @Override
    public Hasher newHasher() {
        final Hasher[] hashers = new Hasher[this.functions.length];
        for (int i10 = 0; i10 < hashers.length; ++i10) {
            hashers[i10] = this.functions[i10].newHasher();
        }
        return new Hasher(){

            @Override
            public Hasher putByte(byte b10) {
                for (Hasher hasher : hashers) {
                    hasher.putByte(b10);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes) {
                for (Hasher hasher : hashers) {
                    hasher.putBytes(bytes);
                }
                return this;
            }

            @Override
            public Hasher putBytes(byte[] bytes, int off, int len) {
                for (Hasher hasher : hashers) {
                    hasher.putBytes(bytes, off, len);
                }
                return this;
            }

            @Override
            public Hasher putShort(short s10) {
                for (Hasher hasher : hashers) {
                    hasher.putShort(s10);
                }
                return this;
            }

            @Override
            public Hasher putInt(int i10) {
                for (Hasher hasher : hashers) {
                    hasher.putInt(i10);
                }
                return this;
            }

            @Override
            public Hasher putLong(long l10) {
                for (Hasher hasher : hashers) {
                    hasher.putLong(l10);
                }
                return this;
            }

            @Override
            public Hasher putFloat(float f10) {
                for (Hasher hasher : hashers) {
                    hasher.putFloat(f10);
                }
                return this;
            }

            @Override
            public Hasher putDouble(double d10) {
                for (Hasher hasher : hashers) {
                    hasher.putDouble(d10);
                }
                return this;
            }

            @Override
            public Hasher putBoolean(boolean b10) {
                for (Hasher hasher : hashers) {
                    hasher.putBoolean(b10);
                }
                return this;
            }

            @Override
            public Hasher putChar(char c10) {
                for (Hasher hasher : hashers) {
                    hasher.putChar(c10);
                }
                return this;
            }

            @Override
            public Hasher putString(CharSequence chars) {
                for (Hasher hasher : hashers) {
                    hasher.putString(chars);
                }
                return this;
            }

            @Override
            public Hasher putString(CharSequence chars, Charset charset) {
                for (Hasher hasher : hashers) {
                    hasher.putString(chars, charset);
                }
                return this;
            }

            @Override
            public <T> Hasher putObject(T instance, Funnel<? super T> funnel) {
                for (Hasher hasher : hashers) {
                    hasher.putObject(instance, funnel);
                }
                return this;
            }

            @Override
            public HashCode hash() {
                return AbstractCompositeHashFunction.this.makeHash(hashers);
            }
        };
    }
}

