/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.Hasher;
import java.nio.charset.Charset;

abstract class AbstractHasher
implements Hasher {
    AbstractHasher() {
    }

    @Override
    public final Hasher putBoolean(boolean b10) {
        return this.putByte(b10 ? (byte)1 : 0);
    }

    @Override
    public final Hasher putDouble(double d10) {
        return this.putLong(Double.doubleToRawLongBits(d10));
    }

    @Override
    public final Hasher putFloat(float f10) {
        return this.putInt(Float.floatToRawIntBits(f10));
    }

    @Override
    public Hasher putString(CharSequence charSequence) {
        int len = charSequence.length();
        for (int i10 = 0; i10 < len; ++i10) {
            this.putChar(charSequence.charAt(i10));
        }
        return this;
    }

    @Override
    public Hasher putString(CharSequence charSequence, Charset charset) {
        return this.putBytes(charSequence.toString().getBytes(charset));
    }
}

