/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashCodes;
import com.google.common.hash.Hasher;
import com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class Murmur3_128HashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_128HashFunction(int seed) {
        this.seed = seed;
    }

    @Override
    public int bits() {
        return 128;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_128Hasher(this.seed);
    }

    public String toString() {
        return "Hashing.murmur3_128(" + this.seed + ")";
    }

    private static final class Murmur3_128Hasher
    extends AbstractStreamingHashFunction.AbstractStreamingHasher {
        private static final int CHUNK_SIZE = 16;
        private static final long C1 = -8663945395140668459L;
        private static final long C2 = 5545529020109919103L;
        private long h1;
        private long h2;
        private int length;

        Murmur3_128Hasher(int seed) {
            super(16);
            this.h1 = seed;
            this.h2 = seed;
            this.length = 0;
        }

        @Override
        protected void process(ByteBuffer bb2) {
            long k12 = bb2.getLong();
            long k22 = bb2.getLong();
            this.bmix64(k12, k22);
            this.length += 16;
        }

        private void bmix64(long k12, long k22) {
            this.h1 ^= Murmur3_128Hasher.mixK1(k12);
            this.h1 = Long.rotateLeft(this.h1, 27);
            this.h1 += this.h2;
            this.h1 = this.h1 * 5L + 1390208809L;
            this.h2 ^= Murmur3_128Hasher.mixK2(k22);
            this.h2 = Long.rotateLeft(this.h2, 31);
            this.h2 += this.h1;
            this.h2 = this.h2 * 5L + 944331445L;
        }

        @Override
        protected void processRemaining(ByteBuffer bb2) {
            long k12 = 0L;
            long k22 = 0L;
            this.length += bb2.remaining();
            switch (bb2.remaining()) {
                case 15: {
                    k22 ^= (long)UnsignedBytes.toInt(bb2.get(14)) << 48;
                }
                case 14: {
                    k22 ^= (long)UnsignedBytes.toInt(bb2.get(13)) << 40;
                }
                case 13: {
                    k22 ^= (long)UnsignedBytes.toInt(bb2.get(12)) << 32;
                }
                case 12: {
                    k22 ^= (long)UnsignedBytes.toInt(bb2.get(11)) << 24;
                }
                case 11: {
                    k22 ^= (long)UnsignedBytes.toInt(bb2.get(10)) << 16;
                }
                case 10: {
                    k22 ^= (long)UnsignedBytes.toInt(bb2.get(9)) << 8;
                }
                case 9: {
                    k22 ^= (long)UnsignedBytes.toInt(bb2.get(8));
                }
                case 8: {
                    k12 ^= bb2.getLong();
                    break;
                }
                case 7: {
                    k12 ^= (long)UnsignedBytes.toInt(bb2.get(6)) << 48;
                }
                case 6: {
                    k12 ^= (long)UnsignedBytes.toInt(bb2.get(5)) << 40;
                }
                case 5: {
                    k12 ^= (long)UnsignedBytes.toInt(bb2.get(4)) << 32;
                }
                case 4: {
                    k12 ^= (long)UnsignedBytes.toInt(bb2.get(3)) << 24;
                }
                case 3: {
                    k12 ^= (long)UnsignedBytes.toInt(bb2.get(2)) << 16;
                }
                case 2: {
                    k12 ^= (long)UnsignedBytes.toInt(bb2.get(1)) << 8;
                }
                case 1: {
                    k12 ^= (long)UnsignedBytes.toInt(bb2.get(0));
                    break;
                }
                default: {
                    throw new AssertionError((Object)"Should never get here.");
                }
            }
            this.h1 ^= Murmur3_128Hasher.mixK1(k12);
            this.h2 ^= Murmur3_128Hasher.mixK2(k22);
        }

        @Override
        public HashCode makeHash() {
            this.h1 ^= (long)this.length;
            this.h2 ^= (long)this.length;
            this.h1 += this.h2;
            this.h2 += this.h1;
            this.h1 = Murmur3_128Hasher.fmix64(this.h1);
            this.h2 = Murmur3_128Hasher.fmix64(this.h2);
            this.h1 += this.h2;
            this.h2 += this.h1;
            return HashCodes.fromBytesNoCopy(ByteBuffer.wrap(new byte[16]).order(ByteOrder.LITTLE_ENDIAN).putLong(this.h1).putLong(this.h2).array());
        }

        private static long fmix64(long k10) {
            k10 ^= k10 >>> 33;
            k10 *= -49064778989728563L;
            k10 ^= k10 >>> 33;
            k10 *= -4265267296055464877L;
            k10 ^= k10 >>> 33;
            return k10;
        }

        private static long mixK1(long k12) {
            k12 *= -8663945395140668459L;
            k12 = Long.rotateLeft(k12, 31);
            return k12 *= 5545529020109919103L;
        }

        private static long mixK2(long k22) {
            k22 *= 5545529020109919103L;
            k22 = Long.rotateLeft(k22, 33);
            return k22 *= -8663945395140668459L;
        }
    }
}

