/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.hash;

import com.google.common.hash.AbstractStreamingHashFunction;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashCodes;
import com.google.common.hash.Hasher;
import com.google.common.primitives.UnsignedBytes;
import java.io.Serializable;
import java.nio.ByteBuffer;

final class Murmur3_32HashFunction
extends AbstractStreamingHashFunction
implements Serializable {
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private final int seed;
    private static final long serialVersionUID = 0L;

    Murmur3_32HashFunction(int seed) {
        this.seed = seed;
    }

    @Override
    public int bits() {
        return 32;
    }

    @Override
    public Hasher newHasher() {
        return new Murmur3_32Hasher(this.seed);
    }

    public String toString() {
        return "Hashing.murmur3_32(" + this.seed + ")";
    }

    @Override
    public HashCode hashInt(int input) {
        int k12 = Murmur3_32HashFunction.mixK1(input);
        int h12 = Murmur3_32HashFunction.mixH1(this.seed, k12);
        return Murmur3_32HashFunction.fmix(h12, 4);
    }

    @Override
    public HashCode hashLong(long input) {
        int low = (int)input;
        int high = (int)(input >>> 32);
        int k12 = Murmur3_32HashFunction.mixK1(low);
        int h12 = Murmur3_32HashFunction.mixH1(this.seed, k12);
        k12 = Murmur3_32HashFunction.mixK1(high);
        h12 = Murmur3_32HashFunction.mixH1(h12, k12);
        return Murmur3_32HashFunction.fmix(h12, 8);
    }

    @Override
    public HashCode hashString(CharSequence input) {
        int h12 = this.seed;
        for (int i10 = 1; i10 < input.length(); i10 += 2) {
            int k12 = input.charAt(i10 - 1) | input.charAt(i10) << 16;
            k12 = Murmur3_32HashFunction.mixK1(k12);
            h12 = Murmur3_32HashFunction.mixH1(h12, k12);
        }
        if ((input.length() & 1) == 1) {
            int k13 = input.charAt(input.length() - 1);
            k13 = Murmur3_32HashFunction.mixK1(k13);
            h12 ^= k13;
        }
        return Murmur3_32HashFunction.fmix(h12, 2 * input.length());
    }

    private static int mixK1(int k12) {
        k12 *= -862048943;
        k12 = Integer.rotateLeft(k12, 15);
        return k12 *= 461845907;
    }

    private static int mixH1(int h12, int k12) {
        h12 ^= k12;
        h12 = Integer.rotateLeft(h12, 13);
        h12 = h12 * 5 + -430675100;
        return h12;
    }

    private static HashCode fmix(int h12, int length) {
        h12 ^= length;
        h12 ^= h12 >>> 16;
        h12 *= -2048144789;
        h12 ^= h12 >>> 13;
        h12 *= -1028477387;
        h12 ^= h12 >>> 16;
        return HashCodes.fromInt(h12);
    }

    private static final class Murmur3_32Hasher
    extends AbstractStreamingHashFunction.AbstractStreamingHasher {
        private static final int CHUNK_SIZE = 4;
        private int h1;
        private int length;

        Murmur3_32Hasher(int seed) {
            super(4);
            this.h1 = seed;
            this.length = 0;
        }

        @Override
        protected void process(ByteBuffer bb2) {
            int k12 = Murmur3_32HashFunction.mixK1(bb2.getInt());
            this.h1 = Murmur3_32HashFunction.mixH1(this.h1, k12);
            this.length += 4;
        }

        @Override
        protected void processRemaining(ByteBuffer bb2) {
            this.length += bb2.remaining();
            int k12 = 0;
            int i10 = 0;
            while (bb2.hasRemaining()) {
                k12 ^= UnsignedBytes.toInt(bb2.get()) << i10;
                i10 += 8;
            }
            this.h1 ^= Murmur3_32HashFunction.mixK1(k12);
        }

        @Override
        public HashCode makeHash() {
            return Murmur3_32HashFunction.fmix(this.h1, this.length);
        }
    }
}

