/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.io;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@Beta
public class LittleEndianDataOutputStream
extends FilterOutputStream
implements DataOutput {
    public LittleEndianDataOutputStream(OutputStream out) {
        super(new DataOutputStream(Preconditions.checkNotNull(out)));
    }

    @Override
    public void write(byte[] b10, int off, int len) throws IOException {
        this.out.write(b10, off, len);
    }

    @Override
    public void writeBoolean(boolean v10) throws IOException {
        ((DataOutputStream)this.out).writeBoolean(v10);
    }

    @Override
    public void writeByte(int v10) throws IOException {
        ((DataOutputStream)this.out).writeByte(v10);
    }

    @Override
    @Deprecated
    public void writeBytes(String s10) throws IOException {
        ((DataOutputStream)this.out).writeBytes(s10);
    }

    @Override
    public void writeChar(int v10) throws IOException {
        this.writeShort(v10);
    }

    @Override
    public void writeChars(String s10) throws IOException {
        for (int i10 = 0; i10 < s10.length(); ++i10) {
            this.writeChar(s10.charAt(i10));
        }
    }

    @Override
    public void writeDouble(double v10) throws IOException {
        this.writeLong(Double.doubleToLongBits(v10));
    }

    @Override
    public void writeFloat(float v10) throws IOException {
        this.writeInt(Float.floatToIntBits(v10));
    }

    @Override
    public void writeInt(int v10) throws IOException {
        this.out.write(0xFF & v10);
        this.out.write(0xFF & v10 >> 8);
        this.out.write(0xFF & v10 >> 16);
        this.out.write(0xFF & v10 >> 24);
    }

    @Override
    public void writeLong(long v10) throws IOException {
        byte[] bytes = Longs.toByteArray(Long.reverseBytes(v10));
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void writeShort(int v10) throws IOException {
        this.out.write(0xFF & v10);
        this.out.write(0xFF & v10 >> 8);
    }

    @Override
    public void writeUTF(String str) throws IOException {
        ((DataOutputStream)this.out).writeUTF(str);
    }
}

