/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.MathPreconditions;
import java.math.RoundingMode;

@GwtCompatible(emulated=true)
public final class IntMath {
    @VisibleForTesting
    static final int MAX_POWER_OF_SQRT2_UNSIGNED = -1257966797;
    @VisibleForTesting
    static final byte[] maxLog10ForLeadingZeros = new byte[]{9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0, 0};
    @VisibleForTesting
    static final int[] powersOf10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000, 10000000, 100000000, 1000000000};
    @VisibleForTesting
    static final int[] halfPowersOf10 = new int[]{3, 31, 316, 3162, 31622, 316227, 3162277, 31622776, 316227766, Integer.MAX_VALUE};
    @VisibleForTesting
    static final int FLOOR_SQRT_MAX_INT = 46340;
    private static final int[] factorials = new int[]{1, 1, 2, 6, 24, 120, 720, 5040, 40320, 362880, 3628800, 39916800, 479001600};
    @VisibleForTesting
    static int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, 65536, 2345, 477, 193, 110, 75, 58, 49, 43, 39, 37, 35, 34, 34, 33};

    public static boolean isPowerOfTwo(int x10) {
        return x10 > 0 & (x10 & x10 - 1) == 0;
    }

    public static int log2(int x10, RoundingMode mode) {
        MathPreconditions.checkPositive("x", x10);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(IntMath.isPowerOfTwo(x10));
            }
            case DOWN: 
            case FLOOR: {
                return 31 - Integer.numberOfLeadingZeros(x10);
            }
            case UP: 
            case CEILING: {
                return 32 - Integer.numberOfLeadingZeros(x10 - 1);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Integer.numberOfLeadingZeros(x10);
                int cmp = -1257966797 >>> leadingZeros;
                int logFloor = 31 - leadingZeros;
                return x10 <= cmp ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible(value="need BigIntegerMath to adequately test")
    public static int log10(int x10, RoundingMode mode) {
        MathPreconditions.checkPositive("x", x10);
        int logFloor = IntMath.log10Floor(x10);
        int floorPow = powersOf10[logFloor];
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(x10 == floorPow);
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return x10 == floorPow ? logFloor : logFloor + 1;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                return x10 <= halfPowersOf10[logFloor] ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError();
    }

    private static int log10Floor(int x10) {
        byte y10 = maxLog10ForLeadingZeros[Integer.numberOfLeadingZeros(x10)];
        int sgn = x10 - powersOf10[y10] >>> 31;
        return y10 - sgn;
    }

    @GwtIncompatible(value="failing tests")
    public static int pow(int b10, int k10) {
        MathPreconditions.checkNonNegative("exponent", k10);
        switch (b10) {
            case 0: {
                return k10 == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k10 & 1) == 0 ? 1 : -1;
            }
            case 2: {
                return k10 < 32 ? 1 << k10 : 0;
            }
            case -2: {
                if (k10 < 32) {
                    return (k10 & 1) == 0 ? 1 << k10 : -(1 << k10);
                }
                return 0;
            }
        }
        int accum = 1;
        while (true) {
            switch (k10) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return b10 * accum;
                }
            }
            accum *= (k10 & 1) == 0 ? 1 : b10;
            b10 *= b10;
            k10 >>= 1;
        }
    }

    @GwtIncompatible(value="need BigIntegerMath to adequately test")
    public static int sqrt(int x10, RoundingMode mode) {
        MathPreconditions.checkNonNegative("x", x10);
        int sqrtFloor = IntMath.sqrtFloor(x10);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(sqrtFloor * sqrtFloor == x10);
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                return sqrtFloor * sqrtFloor == x10 ? sqrtFloor : sqrtFloor + 1;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return x10 <= halfSquare | halfSquare < 0 ? sqrtFloor : sqrtFloor + 1;
            }
        }
        throw new AssertionError();
    }

    private static int sqrtFloor(int x10) {
        return (int)Math.sqrt(x10);
    }

    public static int divide(int p10, int q10, RoundingMode mode) {
        boolean increment;
        Preconditions.checkNotNull(mode);
        if (q10 == 0) {
            throw new ArithmeticException("/ by zero");
        }
        int div = p10 / q10;
        int rem = p10 - q10 * div;
        if (rem == 0) {
            return div;
        }
        int signum = 1 | (p10 ^ q10) >> 31;
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(rem == 0);
            }
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int absRem = Math.abs(rem);
                int cmpRemToHalfDivisor = absRem - (Math.abs(q10) - absRem);
                if (cmpRemToHalfDivisor == 0) {
                    increment = mode == RoundingMode.HALF_UP || mode == RoundingMode.HALF_EVEN & (div & 1) != 0;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + signum : div;
    }

    public static int mod(int x10, int m10) {
        if (m10 <= 0) {
            throw new ArithmeticException("Modulus " + m10 + " must be > 0");
        }
        int result = x10 % m10;
        return result >= 0 ? result : result + m10;
    }

    public static int gcd(int a10, int b10) {
        MathPreconditions.checkNonNegative("a", a10);
        MathPreconditions.checkNonNegative("b", b10);
        if (a10 == 0) {
            return b10;
        }
        if (b10 == 0) {
            return a10;
        }
        int aTwos = Integer.numberOfTrailingZeros(a10);
        a10 >>= aTwos;
        int bTwos = Integer.numberOfTrailingZeros(b10);
        b10 >>= bTwos;
        while (a10 != b10) {
            int delta = a10 - b10;
            int minDeltaOrZero = delta & delta >> 31;
            a10 = delta - minDeltaOrZero - minDeltaOrZero;
            b10 += minDeltaOrZero;
            a10 >>= Integer.numberOfTrailingZeros(a10);
        }
        return a10 << Math.min(aTwos, bTwos);
    }

    public static int checkedAdd(int a10, int b10) {
        long result = (long)a10 + (long)b10;
        MathPreconditions.checkNoOverflow(result == (long)((int)result));
        return (int)result;
    }

    public static int checkedSubtract(int a10, int b10) {
        long result = (long)a10 - (long)b10;
        MathPreconditions.checkNoOverflow(result == (long)((int)result));
        return (int)result;
    }

    public static int checkedMultiply(int a10, int b10) {
        long result = (long)a10 * (long)b10;
        MathPreconditions.checkNoOverflow(result == (long)((int)result));
        return (int)result;
    }

    public static int checkedPow(int b10, int k10) {
        MathPreconditions.checkNonNegative("exponent", k10);
        switch (b10) {
            case 0: {
                return k10 == 0 ? 1 : 0;
            }
            case 1: {
                return 1;
            }
            case -1: {
                return (k10 & 1) == 0 ? 1 : -1;
            }
            case 2: {
                MathPreconditions.checkNoOverflow(k10 < 31);
                return 1 << k10;
            }
            case -2: {
                MathPreconditions.checkNoOverflow(k10 < 32);
                return (k10 & 1) == 0 ? 1 << k10 : -1 << k10;
            }
        }
        int accum = 1;
        while (true) {
            switch (k10) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return IntMath.checkedMultiply(accum, b10);
                }
            }
            if ((k10 & 1) != 0) {
                accum = IntMath.checkedMultiply(accum, b10);
            }
            if ((k10 >>= 1) <= 0) continue;
            MathPreconditions.checkNoOverflow(-46340 <= b10 & b10 <= 46340);
            b10 *= b10;
        }
    }

    public static int factorial(int n10) {
        MathPreconditions.checkNonNegative("n", n10);
        return n10 < factorials.length ? factorials[n10] : Integer.MAX_VALUE;
    }

    @GwtIncompatible(value="need BigIntegerMath to adequately test")
    public static int binomial(int n10, int k10) {
        MathPreconditions.checkNonNegative("n", n10);
        MathPreconditions.checkNonNegative("k", k10);
        Preconditions.checkArgument(k10 <= n10, "k (%s) > n (%s)", k10, n10);
        if (k10 > n10 >> 1) {
            k10 = n10 - k10;
        }
        if (k10 >= biggestBinomials.length || n10 > biggestBinomials[k10]) {
            return Integer.MAX_VALUE;
        }
        switch (k10) {
            case 0: {
                return 1;
            }
            case 1: {
                return n10;
            }
        }
        long result = 1L;
        for (int i10 = 0; i10 < k10; ++i10) {
            result *= (long)(n10 - i10);
            result /= (long)(i10 + 1);
        }
        return (int)result;
    }

    public static int mean(int x10, int y10) {
        return (x10 & y10) + ((x10 ^ y10) >> 1);
    }

    private IntMath() {
    }
}

