/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.math.IntMath;
import com.google.common.math.MathPreconditions;
import java.math.RoundingMode;

@GwtCompatible(emulated=true)
public final class LongMath {
    @VisibleForTesting
    static final long MAX_POWER_OF_SQRT2_UNSIGNED = -5402926248376769404L;
    @VisibleForTesting
    static final byte[] maxLog10ForLeadingZeros = new byte[]{19, 18, 18, 18, 18, 17, 17, 17, 16, 16, 16, 15, 15, 15, 15, 14, 14, 14, 13, 13, 13, 12, 12, 12, 12, 11, 11, 11, 10, 10, 10, 9, 9, 9, 9, 8, 8, 8, 7, 7, 7, 6, 6, 6, 6, 5, 5, 5, 4, 4, 4, 3, 3, 3, 3, 2, 2, 2, 1, 1, 1, 0, 0, 0};
    @GwtIncompatible(value="TODO")
    @VisibleForTesting
    static final long[] powersOf10 = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    @GwtIncompatible(value="TODO")
    @VisibleForTesting
    static final long[] halfPowersOf10 = new long[]{3L, 31L, 316L, 3162L, 31622L, 316227L, 3162277L, 31622776L, 316227766L, 3162277660L, 31622776601L, 316227766016L, 3162277660168L, 31622776601683L, 316227766016837L, 3162277660168379L, 31622776601683793L, 316227766016837933L, 3162277660168379331L};
    @GwtIncompatible(value="TODO")
    @VisibleForTesting
    static final long FLOOR_SQRT_MAX_LONG = 3037000499L;
    static final long[] factorials = new long[]{1L, 1L, 2L, 6L, 24L, 120L, 720L, 5040L, 40320L, 362880L, 3628800L, 39916800L, 479001600L, 6227020800L, 87178291200L, 1307674368000L, 20922789888000L, 355687428096000L, 6402373705728000L, 121645100408832000L, 2432902008176640000L};
    static final int[] biggestBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 3810779, 121977, 16175, 4337, 1733, 887, 534, 361, 265, 206, 169, 143, 125, 111, 101, 94, 88, 83, 79, 76, 74, 72, 70, 69, 68, 67, 67, 66, 66, 66, 66};
    @VisibleForTesting
    static final int[] biggestSimpleBinomials = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, 2642246, 86251, 11724, 3218, 1313, 684, 419, 287, 214, 169, 139, 119, 105, 95, 87, 81, 76, 73, 70, 68, 66, 64, 63, 62, 62, 61, 61, 61};

    public static boolean isPowerOfTwo(long x10) {
        return x10 > 0L & (x10 & x10 - 1L) == 0L;
    }

    public static int log2(long x10, RoundingMode mode) {
        MathPreconditions.checkPositive("x", x10);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(LongMath.isPowerOfTwo(x10));
            }
            case DOWN: 
            case FLOOR: {
                return 63 - Long.numberOfLeadingZeros(x10);
            }
            case UP: 
            case CEILING: {
                return 64 - Long.numberOfLeadingZeros(x10 - 1L);
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                int leadingZeros = Long.numberOfLeadingZeros(x10);
                long cmp = -5402926248376769404L >>> leadingZeros;
                int logFloor = 63 - leadingZeros;
                return x10 <= cmp ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError((Object)"impossible");
    }

    @GwtIncompatible(value="TODO")
    public static int log10(long x10, RoundingMode mode) {
        MathPreconditions.checkPositive("x", x10);
        if (LongMath.fitsInInt(x10)) {
            return IntMath.log10((int)x10, mode);
        }
        int logFloor = LongMath.log10Floor(x10);
        long floorPow = powersOf10[logFloor];
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(x10 == floorPow);
            }
            case DOWN: 
            case FLOOR: {
                return logFloor;
            }
            case UP: 
            case CEILING: {
                return x10 == floorPow ? logFloor : logFloor + 1;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                return x10 <= halfPowersOf10[logFloor] ? logFloor : logFloor + 1;
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible(value="TODO")
    static int log10Floor(long x10) {
        byte y10 = maxLog10ForLeadingZeros[Long.numberOfLeadingZeros(x10)];
        long sgn = x10 - powersOf10[y10] >>> 63;
        return y10 - (int)sgn;
    }

    @GwtIncompatible(value="TODO")
    public static long pow(long b10, int k10) {
        MathPreconditions.checkNonNegative("exponent", k10);
        if (-2L <= b10 && b10 <= 2L) {
            switch ((int)b10) {
                case 0: {
                    return k10 == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k10 & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    return k10 < 64 ? 1L << k10 : 0L;
                }
                case -2: {
                    if (k10 < 64) {
                        return (k10 & 1) == 0 ? 1L << k10 : -(1L << k10);
                    }
                    return 0L;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k10) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return accum * b10;
                }
            }
            accum *= (k10 & 1) == 0 ? 1L : b10;
            b10 *= b10;
            k10 >>= 1;
        }
    }

    @GwtIncompatible(value="TODO")
    public static long sqrt(long x10, RoundingMode mode) {
        MathPreconditions.checkNonNegative("x", x10);
        if (LongMath.fitsInInt(x10)) {
            return IntMath.sqrt((int)x10, mode);
        }
        long sqrtFloor = LongMath.sqrtFloor(x10);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(sqrtFloor * sqrtFloor == x10);
            }
            case DOWN: 
            case FLOOR: {
                return sqrtFloor;
            }
            case UP: 
            case CEILING: {
                return sqrtFloor * sqrtFloor == x10 ? sqrtFloor : sqrtFloor + 1L;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long halfSquare = sqrtFloor * sqrtFloor + sqrtFloor;
                return halfSquare >= x10 | halfSquare < 0L ? sqrtFloor : sqrtFloor + 1L;
            }
        }
        throw new AssertionError();
    }

    @GwtIncompatible(value="TODO")
    private static long sqrtFloor(long x10) {
        long guess = (long)Math.sqrt(x10);
        long guessSquared = guess * guess;
        if (x10 - guessSquared >= guess + guess + 1L) {
            ++guess;
        } else if (x10 < guessSquared) {
            --guess;
        }
        return guess;
    }

    @GwtIncompatible(value="TODO")
    public static long divide(long p10, long q10, RoundingMode mode) {
        boolean increment;
        Preconditions.checkNotNull(mode);
        long div = p10 / q10;
        long rem = p10 - q10 * div;
        if (rem == 0L) {
            return div;
        }
        int signum = 1 | (int)((p10 ^ q10) >> 63);
        switch (mode) {
            case UNNECESSARY: {
                MathPreconditions.checkRoundingUnnecessary(rem == 0L);
            }
            case DOWN: {
                increment = false;
                break;
            }
            case UP: {
                increment = true;
                break;
            }
            case CEILING: {
                increment = signum > 0;
                break;
            }
            case FLOOR: {
                increment = signum < 0;
                break;
            }
            case HALF_DOWN: 
            case HALF_UP: 
            case HALF_EVEN: {
                long absRem = Math.abs(rem);
                long cmpRemToHalfDivisor = absRem - (Math.abs(q10) - absRem);
                if (cmpRemToHalfDivisor == 0L) {
                    increment = mode == RoundingMode.HALF_UP | mode == RoundingMode.HALF_EVEN & (div & 1L) != 0L;
                    break;
                }
                increment = cmpRemToHalfDivisor > 0L;
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return increment ? div + (long)signum : div;
    }

    @GwtIncompatible(value="TODO")
    public static int mod(long x10, int m10) {
        return (int)LongMath.mod(x10, (long)m10);
    }

    @GwtIncompatible(value="TODO")
    public static long mod(long x10, long m10) {
        if (m10 <= 0L) {
            throw new ArithmeticException("Modulus " + m10 + " must be > 0");
        }
        long result = x10 % m10;
        return result >= 0L ? result : result + m10;
    }

    public static long gcd(long a10, long b10) {
        MathPreconditions.checkNonNegative("a", a10);
        MathPreconditions.checkNonNegative("b", b10);
        if (a10 == 0L) {
            return b10;
        }
        if (b10 == 0L) {
            return a10;
        }
        int aTwos = Long.numberOfTrailingZeros(a10);
        a10 >>= aTwos;
        int bTwos = Long.numberOfTrailingZeros(b10);
        b10 >>= bTwos;
        while (a10 != b10) {
            long delta = a10 - b10;
            long minDeltaOrZero = delta & delta >> 63;
            a10 = delta - minDeltaOrZero - minDeltaOrZero;
            b10 += minDeltaOrZero;
            a10 >>= Long.numberOfTrailingZeros(a10);
        }
        return a10 << Math.min(aTwos, bTwos);
    }

    @GwtIncompatible(value="TODO")
    public static long checkedAdd(long a10, long b10) {
        long result = a10 + b10;
        MathPreconditions.checkNoOverflow((a10 ^ b10) < 0L | (a10 ^ result) >= 0L);
        return result;
    }

    @GwtIncompatible(value="TODO")
    public static long checkedSubtract(long a10, long b10) {
        long result = a10 - b10;
        MathPreconditions.checkNoOverflow((a10 ^ b10) >= 0L | (a10 ^ result) >= 0L);
        return result;
    }

    @GwtIncompatible(value="TODO")
    public static long checkedMultiply(long a10, long b10) {
        int leadingZeros = Long.numberOfLeadingZeros(a10) + Long.numberOfLeadingZeros(a10 ^ 0xFFFFFFFFFFFFFFFFL) + Long.numberOfLeadingZeros(b10) + Long.numberOfLeadingZeros(b10 ^ 0xFFFFFFFFFFFFFFFFL);
        if (leadingZeros > 65) {
            return a10 * b10;
        }
        MathPreconditions.checkNoOverflow(leadingZeros >= 64);
        MathPreconditions.checkNoOverflow(a10 >= 0L | b10 != Long.MIN_VALUE);
        long result = a10 * b10;
        MathPreconditions.checkNoOverflow(a10 == 0L || result / a10 == b10);
        return result;
    }

    @GwtIncompatible(value="TODO")
    public static long checkedPow(long b10, int k10) {
        MathPreconditions.checkNonNegative("exponent", k10);
        if (b10 >= -2L & b10 <= 2L) {
            switch ((int)b10) {
                case 0: {
                    return k10 == 0 ? 1L : 0L;
                }
                case 1: {
                    return 1L;
                }
                case -1: {
                    return (k10 & 1) == 0 ? 1L : -1L;
                }
                case 2: {
                    MathPreconditions.checkNoOverflow(k10 < 63);
                    return 1L << k10;
                }
                case -2: {
                    MathPreconditions.checkNoOverflow(k10 < 64);
                    return (k10 & 1) == 0 ? 1L << k10 : -1L << k10;
                }
            }
            throw new AssertionError();
        }
        long accum = 1L;
        while (true) {
            switch (k10) {
                case 0: {
                    return accum;
                }
                case 1: {
                    return LongMath.checkedMultiply(accum, b10);
                }
            }
            if ((k10 & 1) != 0) {
                accum = LongMath.checkedMultiply(accum, b10);
            }
            if ((k10 >>= 1) <= 0) continue;
            MathPreconditions.checkNoOverflow(b10 <= 3037000499L);
            b10 *= b10;
        }
    }

    @GwtIncompatible(value="TODO")
    public static long factorial(int n10) {
        MathPreconditions.checkNonNegative("n", n10);
        return n10 < factorials.length ? factorials[n10] : Long.MAX_VALUE;
    }

    public static long binomial(int n10, int k10) {
        MathPreconditions.checkNonNegative("n", n10);
        MathPreconditions.checkNonNegative("k", k10);
        Preconditions.checkArgument(k10 <= n10, "k (%s) > n (%s)", k10, n10);
        if (k10 > n10 >> 1) {
            k10 = n10 - k10;
        }
        switch (k10) {
            case 0: {
                return 1L;
            }
            case 1: {
                return n10;
            }
        }
        if (n10 < factorials.length) {
            return factorials[n10] / (factorials[k10] * factorials[n10 - k10]);
        }
        if (k10 >= biggestBinomials.length || n10 > biggestBinomials[k10]) {
            return Long.MAX_VALUE;
        }
        if (k10 < biggestSimpleBinomials.length && n10 <= biggestSimpleBinomials[k10]) {
            long result = n10--;
            for (int i10 = 2; i10 <= k10; ++i10) {
                result *= (long)n10;
                result /= (long)i10;
                --n10;
            }
            return result;
        }
        int nBits = LongMath.log2(n10, RoundingMode.CEILING);
        long result = 1L;
        long numerator = n10--;
        long denominator = 1L;
        int numeratorBits = nBits;
        int i11 = 2;
        while (i11 <= k10) {
            if (numeratorBits + nBits < 63) {
                numerator *= (long)n10;
                denominator *= (long)i11;
                numeratorBits += nBits;
            } else {
                result = LongMath.multiplyFraction(result, numerator, denominator);
                numerator = n10;
                denominator = i11;
                numeratorBits = nBits;
            }
            ++i11;
            --n10;
        }
        return LongMath.multiplyFraction(result, numerator, denominator);
    }

    static long multiplyFraction(long x10, long numerator, long denominator) {
        if (x10 == 1L) {
            return numerator / denominator;
        }
        long commonDivisor = LongMath.gcd(x10, denominator);
        return (x10 /= commonDivisor) * (numerator / (denominator /= commonDivisor));
    }

    @GwtIncompatible(value="TODO")
    static boolean fitsInInt(long x10) {
        return (long)((int)x10) == x10;
    }

    public static long mean(long x10, long y10) {
        return (x10 & y10) + ((x10 ^ y10) >> 1);
    }

    private LongMath() {
    }
}

