/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.math;

import com.google.common.annotations.GwtCompatible;
import java.math.BigInteger;
import javax.annotation.Nullable;

@GwtCompatible
final class MathPreconditions {
    static int checkPositive(@Nullable String role, int x10) {
        if (x10 <= 0) {
            throw new IllegalArgumentException(role + " (" + x10 + ") must be > 0");
        }
        return x10;
    }

    static long checkPositive(@Nullable String role, long x10) {
        if (x10 <= 0L) {
            throw new IllegalArgumentException(role + " (" + x10 + ") must be > 0");
        }
        return x10;
    }

    static BigInteger checkPositive(@Nullable String role, BigInteger x10) {
        if (x10.signum() <= 0) {
            throw new IllegalArgumentException(role + " (" + x10 + ") must be > 0");
        }
        return x10;
    }

    static int checkNonNegative(@Nullable String role, int x10) {
        if (x10 < 0) {
            throw new IllegalArgumentException(role + " (" + x10 + ") must be >= 0");
        }
        return x10;
    }

    static long checkNonNegative(@Nullable String role, long x10) {
        if (x10 < 0L) {
            throw new IllegalArgumentException(role + " (" + x10 + ") must be >= 0");
        }
        return x10;
    }

    static BigInteger checkNonNegative(@Nullable String role, BigInteger x10) {
        if (x10.signum() < 0) {
            throw new IllegalArgumentException(role + " (" + x10 + ") must be >= 0");
        }
        return x10;
    }

    static double checkNonNegative(@Nullable String role, double x10) {
        if (!(x10 >= 0.0)) {
            throw new IllegalArgumentException(role + " (" + x10 + ") must be >= 0");
        }
        return x10;
    }

    static void checkRoundingUnnecessary(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("mode was UNNECESSARY, but rounding was necessary");
        }
    }

    static void checkInRange(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("not in range");
        }
    }

    static void checkNoOverflow(boolean condition) {
        if (!condition) {
            throw new ArithmeticException("overflow");
        }
    }

    private MathPreconditions() {
    }
}

