/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

@GwtCompatible(emulated=true)
public final class Shorts {
    public static final int BYTES = 2;
    public static final short MAX_POWER_OF_TWO = 16384;

    private Shorts() {
    }

    public static int hashCode(short value) {
        return value;
    }

    public static short checkedCast(long value) {
        short result = (short)value;
        Preconditions.checkArgument((long)result == value, "Out of range: %s", value);
        return result;
    }

    public static short saturatedCast(long value) {
        if (value > 32767L) {
            return Short.MAX_VALUE;
        }
        if (value < -32768L) {
            return Short.MIN_VALUE;
        }
        return (short)value;
    }

    public static int compare(short a10, short b10) {
        return a10 - b10;
    }

    public static boolean contains(short[] array, short target) {
        for (short value : array) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(short[] array, short target) {
        return Shorts.indexOf(array, target, 0, array.length);
    }

    private static int indexOf(short[] array, short target, int start, int end) {
        for (int i10 = start; i10 < end; ++i10) {
            if (array[i10] != target) continue;
            return i10;
        }
        return -1;
    }

    public static int indexOf(short[] array, short[] target) {
        Preconditions.checkNotNull(array, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i10 = 0; i10 < array.length - target.length + 1; ++i10) {
            for (int j10 = 0; j10 < target.length; ++j10) {
                if (array[i10 + j10] != target[j10]) continue block0;
            }
            return i10;
        }
        return -1;
    }

    public static int lastIndexOf(short[] array, short target) {
        return Shorts.lastIndexOf(array, target, 0, array.length);
    }

    private static int lastIndexOf(short[] array, short target, int start, int end) {
        for (int i10 = end - 1; i10 >= start; --i10) {
            if (array[i10] != target) continue;
            return i10;
        }
        return -1;
    }

    public static short min(short ... array) {
        Preconditions.checkArgument(array.length > 0);
        short min = array[0];
        for (int i10 = 1; i10 < array.length; ++i10) {
            if (array[i10] >= min) continue;
            min = array[i10];
        }
        return min;
    }

    public static short max(short ... array) {
        Preconditions.checkArgument(array.length > 0);
        short max = array[0];
        for (int i10 = 1; i10 < array.length; ++i10) {
            if (array[i10] <= max) continue;
            max = array[i10];
        }
        return max;
    }

    public static short[] concat(short[] ... arrays) {
        int length = 0;
        for (short[] array : arrays) {
            length += array.length;
        }
        short[] result = new short[length];
        int pos = 0;
        for (short[] array : arrays) {
            System.arraycopy(array, 0, result, pos, array.length);
            pos += array.length;
        }
        return result;
    }

    @GwtIncompatible(value="doesn't work")
    public static byte[] toByteArray(short value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    @GwtIncompatible(value="doesn't work")
    public static short fromByteArray(byte[] bytes) {
        Preconditions.checkArgument(bytes.length >= 2, "array too small: %s < %s", bytes.length, 2);
        return Shorts.fromBytes(bytes[0], bytes[1]);
    }

    @GwtIncompatible(value="doesn't work")
    public static short fromBytes(byte b12, byte b22) {
        return (short)(b12 << 8 | b22 & 0xFF);
    }

    public static short[] ensureCapacity(short[] array, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array.length < minLength ? Shorts.copyOf(array, minLength + padding) : array;
    }

    private static short[] copyOf(short[] original, int length) {
        short[] copy = new short[length];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, length));
        return copy;
    }

    public static String join(String separator, short ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 6);
        builder.append(array[0]);
        for (int i10 = 1; i10 < array.length; ++i10) {
            builder.append(separator).append(array[i10]);
        }
        return builder.toString();
    }

    public static Comparator<short[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static short[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof ShortArrayAsList) {
            return ((ShortArrayAsList)collection).toShortArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        short[] array = new short[len];
        for (int i10 = 0; i10 < len; ++i10) {
            array[i10] = ((Number)Preconditions.checkNotNull(boxedArray[i10])).shortValue();
        }
        return array;
    }

    public static List<Short> asList(short ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new ShortArrayAsList(backingArray);
    }

    private static enum LexicographicalComparator implements Comparator<short[]>
    {
        INSTANCE;


        @Override
        public int compare(short[] left, short[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i10 = 0; i10 < minLength; ++i10) {
                int result = Shorts.compare(left[i10], right[i10]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }

    @GwtCompatible
    private static class ShortArrayAsList
    extends AbstractList<Short>
    implements RandomAccess,
    Serializable {
        final short[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        ShortArrayAsList(short[] array) {
            this(array, 0, array.length);
        }

        ShortArrayAsList(short[] array, int start, int end) {
            this.array = array;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Short get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return this.array[this.start + index];
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Short && Shorts.indexOf(this.array, (Short)target, this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i10;
            if (target instanceof Short && (i10 = Shorts.indexOf(this.array, (Short)target, this.start, this.end)) >= 0) {
                return i10 - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i10;
            if (target instanceof Short && (i10 = Shorts.lastIndexOf(this.array, (Short)target, this.start, this.end)) >= 0) {
                return i10 - this.start;
            }
            return -1;
        }

        @Override
        public Short set(int index, Short element) {
            Preconditions.checkElementIndex(index, this.size());
            short oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element);
            return oldValue;
        }

        @Override
        public List<Short> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new ShortArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof ShortArrayAsList) {
                ShortArrayAsList that = (ShortArrayAsList)object;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i10 = 0; i10 < size; ++i10) {
                    if (this.array[this.start + i10] == that.array[that.start + i10]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int i10 = this.start; i10 < this.end; ++i10) {
                result = 31 * result + Shorts.hashCode(this.array[i10]);
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 6);
            builder.append('[').append(this.array[this.start]);
            for (int i10 = this.start + 1; i10 < this.end; ++i10) {
                builder.append(", ").append(this.array[i10]);
            }
            return builder.append(']').toString();
        }

        short[] toShortArray() {
            int size = this.size();
            short[] result = new short[size];
            System.arraycopy(this.array, this.start, result, 0, size);
            return result;
        }
    }
}

