/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Longs;
import com.google.common.primitives.ParseRequest;
import java.math.BigInteger;
import java.util.Comparator;

@Beta
@GwtCompatible
public final class UnsignedLongs {
    public static final long MAX_VALUE = -1L;
    private static final long[] maxValueDivs = new long[37];
    private static final int[] maxValueMods = new int[37];
    private static final int[] maxSafeDigits = new int[37];

    private UnsignedLongs() {
    }

    private static long flip(long a10) {
        return a10 ^ Long.MIN_VALUE;
    }

    public static int compare(long a10, long b10) {
        return Longs.compare(UnsignedLongs.flip(a10), UnsignedLongs.flip(b10));
    }

    public static long min(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long min = UnsignedLongs.flip(array[0]);
        for (int i10 = 1; i10 < array.length; ++i10) {
            long next = UnsignedLongs.flip(array[i10]);
            if (next >= min) continue;
            min = next;
        }
        return UnsignedLongs.flip(min);
    }

    public static long max(long ... array) {
        Preconditions.checkArgument(array.length > 0);
        long max = UnsignedLongs.flip(array[0]);
        for (int i10 = 1; i10 < array.length; ++i10) {
            long next = UnsignedLongs.flip(array[i10]);
            if (next <= max) continue;
            max = next;
        }
        return UnsignedLongs.flip(max);
    }

    public static String join(String separator, long ... array) {
        Preconditions.checkNotNull(separator);
        if (array.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array.length * 5);
        builder.append(UnsignedLongs.toString(array[0]));
        for (int i10 = 1; i10 < array.length; ++i10) {
            builder.append(separator).append(UnsignedLongs.toString(array[i10]));
        }
        return builder.toString();
    }

    public static Comparator<long[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(UnsignedLongs.compare(rem, divisor) >= 0 ? 1 : 0);
    }

    public static long remainder(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            if (UnsignedLongs.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (UnsignedLongs.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }

    public static long parseUnsignedLong(String s10) {
        return UnsignedLongs.parseUnsignedLong(s10, 10);
    }

    public static long decode(String stringValue) {
        ParseRequest request = ParseRequest.fromString(stringValue);
        try {
            return UnsignedLongs.parseUnsignedLong(request.rawValue, request.radix);
        }
        catch (NumberFormatException e10) {
            NumberFormatException decodeException = new NumberFormatException("Error parsing value: " + stringValue);
            decodeException.initCause(e10);
            throw decodeException;
        }
    }

    public static long parseUnsignedLong(String s10, int radix) {
        Preconditions.checkNotNull(s10);
        if (s10.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("illegal radix: " + radix);
        }
        int max_safe_pos = maxSafeDigits[radix] - 1;
        long value = 0L;
        for (int pos = 0; pos < s10.length(); ++pos) {
            int digit = Character.digit(s10.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(s10);
            }
            if (pos > max_safe_pos && UnsignedLongs.overflowInParse(value, digit, radix)) {
                throw new NumberFormatException("Too large for unsigned long: " + s10);
            }
            value = value * (long)radix + (long)digit;
        }
        return value;
    }

    private static boolean overflowInParse(long current, int digit, int radix) {
        if (current >= 0L) {
            if (current < maxValueDivs[radix]) {
                return false;
            }
            if (current > maxValueDivs[radix]) {
                return true;
            }
            return digit > maxValueMods[radix];
        }
        return true;
    }

    public static String toString(long x10) {
        return UnsignedLongs.toString(x10, 10);
    }

    public static String toString(long x10, int radix) {
        Preconditions.checkArgument(radix >= 2 && radix <= 36, "radix (%s) must be between Character.MIN_RADIX and Character.MAX_RADIX", radix);
        if (x10 == 0L) {
            return "0";
        }
        char[] buf = new char[64];
        int i10 = buf.length;
        if (x10 < 0L) {
            long quotient = UnsignedLongs.divide(x10, radix);
            long rem = x10 - quotient * (long)radix;
            buf[--i10] = Character.forDigit((int)rem, radix);
            x10 = quotient;
        }
        while (x10 > 0L) {
            buf[--i10] = Character.forDigit((int)(x10 % (long)radix), radix);
            x10 /= (long)radix;
        }
        return new String(buf, i10, buf.length - i10);
    }

    static {
        BigInteger overflow = new BigInteger("10000000000000000", 16);
        for (int i10 = 2; i10 <= 36; ++i10) {
            UnsignedLongs.maxValueDivs[i10] = UnsignedLongs.divide(-1L, i10);
            UnsignedLongs.maxValueMods[i10] = (int)UnsignedLongs.remainder(-1L, i10);
            UnsignedLongs.maxSafeDigits[i10] = overflow.toString(i10).length() - 1;
        }
    }

    static enum LexicographicalComparator implements Comparator<long[]>
    {
        INSTANCE;


        @Override
        public int compare(long[] left, long[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i10 = 0; i10 < minLength; ++i10) {
                if (left[i10] == right[i10]) continue;
                return UnsignedLongs.compare(left[i10], right[i10]);
            }
            return left.length - right.length;
        }
    }
}

