/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.reflect;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.Types;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;

class TypeResolver {
    private final ImmutableMap<TypeVariable<?>, Type> typeTable;

    public TypeResolver() {
        this.typeTable = ImmutableMap.of();
    }

    private TypeResolver(ImmutableMap<TypeVariable<?>, Type> typeTable) {
        this.typeTable = typeTable;
    }

    static TypeResolver accordingTo(Type type) {
        return new TypeResolver().where(TypeMappingIntrospector.getTypeMappings(type));
    }

    public final TypeResolver where(Type formal, Type actual) {
        HashMap<TypeVariable<?>, Type> mappings = Maps.newHashMap();
        TypeResolver.populateTypeMappings(mappings, Preconditions.checkNotNull(formal), Preconditions.checkNotNull(actual));
        return this.where(mappings);
    }

    final TypeResolver where(Map<? extends TypeVariable<?>, ? extends Type> mappings) {
        ImmutableMap.Builder<TypeVariable<?>, Type> builder = ImmutableMap.builder();
        builder.putAll(this.typeTable);
        for (Map.Entry<TypeVariable<?>, Type> mapping : mappings.entrySet()) {
            Type type;
            TypeVariable<?> variable = mapping.getKey();
            Preconditions.checkArgument(!variable.equals(type = mapping.getValue()), "Type variable %s bound to itself", variable);
            builder.put(variable, type);
        }
        return new TypeResolver(builder.build());
    }

    private static void populateTypeMappings(Map<TypeVariable<?>, Type> mappings, Type from, Type to2) {
        if (from.equals(to2)) {
            return;
        }
        if (from instanceof TypeVariable) {
            mappings.put((TypeVariable)from, to2);
        } else if (from instanceof GenericArrayType) {
            TypeResolver.populateTypeMappings(mappings, ((GenericArrayType)from).getGenericComponentType(), TypeResolver.checkNonNullArgument(Types.getComponentType(to2), "%s is not an array type.", to2));
        } else if (from instanceof ParameterizedType) {
            ParameterizedType fromParameterizedType = (ParameterizedType)from;
            ParameterizedType toParameterizedType = TypeResolver.expectArgument(ParameterizedType.class, to2);
            Preconditions.checkArgument(fromParameterizedType.getRawType().equals(toParameterizedType.getRawType()), "Inconsistent raw type: %s vs. %s", from, to2);
            Type[] fromArgs = fromParameterizedType.getActualTypeArguments();
            Type[] toArgs = toParameterizedType.getActualTypeArguments();
            Preconditions.checkArgument(fromArgs.length == toArgs.length);
            for (int i10 = 0; i10 < fromArgs.length; ++i10) {
                TypeResolver.populateTypeMappings(mappings, fromArgs[i10], toArgs[i10]);
            }
        } else if (from instanceof WildcardType) {
            int i11;
            WildcardType fromWildcardType = (WildcardType)from;
            WildcardType toWildcardType = TypeResolver.expectArgument(WildcardType.class, to2);
            Type[] fromUpperBounds = fromWildcardType.getUpperBounds();
            Type[] toUpperBounds = toWildcardType.getUpperBounds();
            Type[] fromLowerBounds = fromWildcardType.getLowerBounds();
            Type[] toLowerBounds = toWildcardType.getLowerBounds();
            Preconditions.checkArgument(fromUpperBounds.length == toUpperBounds.length && fromLowerBounds.length == toLowerBounds.length, "Incompatible type: %s vs. %s", from, to2);
            for (i11 = 0; i11 < fromUpperBounds.length; ++i11) {
                TypeResolver.populateTypeMappings(mappings, fromUpperBounds[i11], toUpperBounds[i11]);
            }
            for (i11 = 0; i11 < fromLowerBounds.length; ++i11) {
                TypeResolver.populateTypeMappings(mappings, fromLowerBounds[i11], toLowerBounds[i11]);
            }
        } else {
            throw new IllegalArgumentException("No type mapping from " + from);
        }
    }

    public final Type resolveType(Type type) {
        Preconditions.checkNotNull(type);
        if (type instanceof TypeVariable) {
            return this.resolveTypeVariable((TypeVariable)type);
        }
        if (type instanceof ParameterizedType) {
            return this.resolveParameterizedType((ParameterizedType)type);
        }
        if (type instanceof GenericArrayType) {
            return this.resolveGenericArrayType((GenericArrayType)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            return new Types.WildcardTypeImpl(this.resolveTypes(wildcardType.getLowerBounds()), this.resolveTypes(wildcardType.getUpperBounds()));
        }
        return type;
    }

    private Type[] resolveTypes(Type[] types) {
        Type[] result = new Type[types.length];
        for (int i10 = 0; i10 < types.length; ++i10) {
            result[i10] = this.resolveType(types[i10]);
        }
        return result;
    }

    private Type resolveGenericArrayType(GenericArrayType type) {
        Type componentType = this.resolveType(type.getGenericComponentType());
        return Types.newArrayType(componentType);
    }

    private Type resolveTypeVariable(final TypeVariable<?> var) {
        final TypeResolver unguarded = this;
        TypeResolver guarded = new TypeResolver(this.typeTable){

            @Override
            Type resolveTypeVariable(TypeVariable<?> intermediateVar, TypeResolver guardedResolver) {
                if (intermediateVar.getGenericDeclaration().equals(var.getGenericDeclaration())) {
                    return intermediateVar;
                }
                return unguarded.resolveTypeVariable(intermediateVar, guardedResolver);
            }
        };
        return this.resolveTypeVariable(var, guarded);
    }

    Type resolveTypeVariable(TypeVariable<?> var, TypeResolver guardedResolver) {
        Preconditions.checkNotNull(guardedResolver);
        Type type = this.typeTable.get(var);
        if (type == null) {
            Type[] bounds = var.getBounds();
            if (bounds.length == 0) {
                return var;
            }
            return Types.newTypeVariable(var.getGenericDeclaration(), var.getName(), guardedResolver.resolveTypes(bounds));
        }
        return guardedResolver.resolveType(type);
    }

    private ParameterizedType resolveParameterizedType(ParameterizedType type) {
        Type owner = type.getOwnerType();
        Type resolvedOwner = owner == null ? null : this.resolveType(owner);
        Type resolvedRawType = this.resolveType(type.getRawType());
        Type[] vars = type.getActualTypeArguments();
        Type[] resolvedArgs = new Type[vars.length];
        for (int i10 = 0; i10 < vars.length; ++i10) {
            resolvedArgs[i10] = this.resolveType(vars[i10]);
        }
        return Types.newParameterizedTypeWithOwner(resolvedOwner, (Class)resolvedRawType, resolvedArgs);
    }

    private static <T> T checkNonNullArgument(T arg, String format, Object ... messageParams) {
        Preconditions.checkArgument(arg != null, format, messageParams);
        return arg;
    }

    private static <T> T expectArgument(Class<T> type, Object arg) {
        try {
            return type.cast(arg);
        }
        catch (ClassCastException e10) {
            throw new IllegalArgumentException(arg + " is not a " + type.getSimpleName());
        }
    }

    private static final class TypeMappingIntrospector {
        private static final WildcardCapturer wildcardCapturer = new WildcardCapturer();
        private final Map<TypeVariable<?>, Type> mappings = Maps.newHashMap();
        private final Set<Type> introspectedTypes = Sets.newHashSet();

        private TypeMappingIntrospector() {
        }

        static ImmutableMap<TypeVariable<?>, Type> getTypeMappings(Type contextType) {
            TypeMappingIntrospector introspector = new TypeMappingIntrospector();
            introspector.introspect(wildcardCapturer.capture(contextType));
            return ImmutableMap.copyOf(introspector.mappings);
        }

        private void introspect(Type type) {
            block4: {
                block6: {
                    block5: {
                        block3: {
                            if (!this.introspectedTypes.add(type)) {
                                return;
                            }
                            if (!(type instanceof ParameterizedType)) break block3;
                            this.introspectParameterizedType((ParameterizedType)type);
                            break block4;
                        }
                        if (!(type instanceof Class)) break block5;
                        this.introspectClass((Class)type);
                        break block4;
                    }
                    if (!(type instanceof TypeVariable)) break block6;
                    for (Type bound : ((TypeVariable)type).getBounds()) {
                        this.introspect(bound);
                    }
                    break block4;
                }
                if (!(type instanceof WildcardType)) break block4;
                for (Type bound : ((WildcardType)type).getUpperBounds()) {
                    this.introspect(bound);
                }
            }
        }

        private void introspectClass(Class<?> clazz) {
            this.introspect(clazz.getGenericSuperclass());
            for (Type interfaceType : clazz.getGenericInterfaces()) {
                this.introspect(interfaceType);
            }
        }

        private void introspectParameterizedType(ParameterizedType parameterizedType) {
            Type[] typeArgs;
            Class rawClass = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] vars = rawClass.getTypeParameters();
            Preconditions.checkState(vars.length == (typeArgs = parameterizedType.getActualTypeArguments()).length);
            for (int i10 = 0; i10 < vars.length; ++i10) {
                this.map(vars[i10], typeArgs[i10]);
            }
            this.introspectClass(rawClass);
            this.introspect(parameterizedType.getOwnerType());
        }

        private void map(TypeVariable<?> var, Type arg) {
            if (this.mappings.containsKey(var)) {
                return;
            }
            Type t10 = arg;
            while (t10 != null) {
                if (var.equals(t10)) {
                    Type x10 = arg;
                    while (x10 != null) {
                        x10 = this.mappings.remove(x10);
                    }
                    return;
                }
                t10 = this.mappings.get(t10);
            }
            this.mappings.put(var, arg);
        }
    }

    private static final class WildcardCapturer {
        private final AtomicInteger id = new AtomicInteger();

        private WildcardCapturer() {
        }

        Type capture(Type type) {
            Preconditions.checkNotNull(type);
            if (type instanceof Class) {
                return type;
            }
            if (type instanceof TypeVariable) {
                return type;
            }
            if (type instanceof GenericArrayType) {
                GenericArrayType arrayType = (GenericArrayType)type;
                return Types.newArrayType(this.capture(arrayType.getGenericComponentType()));
            }
            if (type instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                return Types.newParameterizedTypeWithOwner(this.captureNullable(parameterizedType.getOwnerType()), (Class)parameterizedType.getRawType(), this.capture(parameterizedType.getActualTypeArguments()));
            }
            if (type instanceof WildcardType) {
                WildcardType wildcardType = (WildcardType)type;
                Type[] lowerBounds = wildcardType.getLowerBounds();
                if (lowerBounds.length == 0) {
                    Object[] upperBounds = wildcardType.getUpperBounds();
                    String name = "capture#" + this.id.incrementAndGet() + "-of ? extends " + Joiner.on('&').join(upperBounds);
                    return Types.newTypeVariable(WildcardCapturer.class, name, wildcardType.getUpperBounds());
                }
                return type;
            }
            throw new AssertionError((Object)"must have been one of the known types");
        }

        private Type captureNullable(@Nullable Type type) {
            if (type == null) {
                return null;
            }
            return this.capture(type);
        }

        private Type[] capture(Type[] types) {
            Type[] result = new Type[types.length];
            for (int i10 = 0; i10 < types.length; ++i10) {
                result[i10] = this.capture(types[i10]);
            }
            return result;
        }
    }
}

