/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.util.concurrent;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLongArray;

public class AtomicDoubleArray
implements Serializable {
    private static final long serialVersionUID = 0L;
    private transient AtomicLongArray longs;

    public AtomicDoubleArray(int length) {
        this.longs = new AtomicLongArray(length);
    }

    public AtomicDoubleArray(double[] array) {
        int len = array.length;
        long[] longArray = new long[len];
        for (int i10 = 0; i10 < len; ++i10) {
            longArray[i10] = Double.doubleToRawLongBits(array[i10]);
        }
        this.longs = new AtomicLongArray(longArray);
    }

    public final int length() {
        return this.longs.length();
    }

    public final double get(int i10) {
        return Double.longBitsToDouble(this.longs.get(i10));
    }

    public final void set(int i10, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        this.longs.set(i10, next);
    }

    public final void lazySet(int i10, double newValue) {
        this.set(i10, newValue);
    }

    public final double getAndSet(int i10, double newValue) {
        long next = Double.doubleToRawLongBits(newValue);
        return Double.longBitsToDouble(this.longs.getAndSet(i10, next));
    }

    public final boolean compareAndSet(int i10, double expect, double update) {
        return this.longs.compareAndSet(i10, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final boolean weakCompareAndSet(int i10, double expect, double update) {
        return this.longs.weakCompareAndSet(i10, Double.doubleToRawLongBits(expect), Double.doubleToRawLongBits(update));
    }

    public final double getAndAdd(int i10, double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i10, current = this.longs.get(i10), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current)) + delta))) {
        }
        return currentVal;
    }

    public double addAndGet(int i10, double delta) {
        double currentVal;
        double nextVal;
        long next;
        long current;
        while (!this.longs.compareAndSet(i10, current = this.longs.get(i10), next = Double.doubleToRawLongBits(nextVal = (currentVal = Double.longBitsToDouble(current)) + delta))) {
        }
        return nextVal;
    }

    public String toString() {
        int iMax = this.length() - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b10 = new StringBuilder(19 * (iMax + 1));
        b10.append('[');
        int i10 = 0;
        while (true) {
            b10.append(Double.longBitsToDouble(this.longs.get(i10)));
            if (i10 == iMax) {
                return b10.append(']').toString();
            }
            b10.append(',').append(' ');
            ++i10;
        }
    }

    private void writeObject(ObjectOutputStream s10) throws IOException {
        s10.defaultWriteObject();
        int length = this.length();
        s10.writeInt(length);
        for (int i10 = 0; i10 < length; ++i10) {
            s10.writeDouble(this.get(i10));
        }
    }

    private void readObject(ObjectInputStream s10) throws IOException, ClassNotFoundException {
        s10.defaultReadObject();
        int length = s10.readInt();
        this.longs = new AtomicLongArray(length);
        for (int i10 = 0; i10 < length; ++i10) {
            this.set(i10, s10.readDouble());
        }
    }
}

