/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.ResampleFilter;

class BiCubicFilter
implements ResampleFilter {
    protected final float a;

    public BiCubicFilter() {
        this.a = -0.5f;
    }

    protected BiCubicFilter(float a10) {
        this.a = a10;
    }

    public final float apply(float value) {
        if (value == 0.0f) {
            return 1.0f;
        }
        if (value < 0.0f) {
            value = -value;
        }
        float vv2 = value * value;
        if (value < 1.0f) {
            return (this.a + 2.0f) * vv2 * value - (this.a + 3.0f) * vv2 + 1.0f;
        }
        if (value < 2.0f) {
            return this.a * vv2 * value - 5.0f * this.a * vv2 + 8.0f * this.a * value - 4.0f * this.a;
        }
        return 0.0f;
    }

    public float getSamplingRadius() {
        return 2.0f;
    }

    public String getName() {
        return "BiCubic";
    }
}

