/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class MultiStepRescaleOp
extends AdvancedResizeOp {
    private final Object renderingHintInterpolation;

    public MultiStepRescaleOp(int dstWidth, int dstHeight) {
        this(dstWidth, dstHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public MultiStepRescaleOp(int dstWidth, int dstHeight, Object renderingHintInterpolation) {
        this(DimensionConstrain.createAbsolutionDimension(dstWidth, dstHeight), renderingHintInterpolation);
    }

    public MultiStepRescaleOp(DimensionConstrain dimensionConstain) {
        this(dimensionConstain, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
    }

    public MultiStepRescaleOp(DimensionConstrain dimensionConstain, Object renderingHintInterpolation) {
        super(dimensionConstain);
        this.renderingHintInterpolation = renderingHintInterpolation;
        assert (RenderingHints.KEY_INTERPOLATION.isCompatibleValue(renderingHintInterpolation)) : "Rendering hint " + renderingHintInterpolation + " is not compatible with interpolation";
    }

    public BufferedImage doFilter(BufferedImage img, BufferedImage dest, int dstWidth, int dstHeight) {
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        int w10 = img.getWidth();
        int h10 = img.getHeight();
        do {
            if (w10 > dstWidth) {
                if ((w10 /= 2) < dstWidth) {
                    w10 = dstWidth;
                }
            } else {
                w10 = dstWidth;
            }
            if (h10 > dstHeight) {
                if ((h10 /= 2) < dstHeight) {
                    h10 = dstHeight;
                }
            } else {
                h10 = dstHeight;
            }
            BufferedImage tmp = dest != null && dest.getWidth() == w10 && dest.getHeight() == h10 && w10 == dstWidth && h10 == dstHeight ? dest : new BufferedImage(w10, h10, type);
            Graphics2D g22 = tmp.createGraphics();
            g22.setRenderingHint(RenderingHints.KEY_INTERPOLATION, this.renderingHintInterpolation);
            g22.drawImage(ret, 0, 0, w10, h10, null);
            g22.dispose();
            ret = tmp;
        } while (w10 != dstWidth || h10 != dstHeight);
        return ret;
    }
}

