/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ImageUtils;
import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import java.awt.image.BufferedImage;
import java.util.concurrent.atomic.AtomicInteger;

public class ResampleOp
extends AdvancedResizeOp {
    private final int MAX_CHANNEL_VALUE = 255;
    private int nrChannels;
    private int srcWidth;
    private int srcHeight;
    private int dstWidth;
    private int dstHeight;
    private SubSamplingData horizontalSubsamplingData;
    private SubSamplingData verticalSubsamplingData;
    private int processedItems;
    private float totalItems;
    private int numberOfThreads = Runtime.getRuntime().availableProcessors();
    private AtomicInteger multipleInvocationLock = new AtomicInteger();
    private ResampleFilter filter = ResampleFilters.getLanczos3Filter();

    public ResampleOp(int destWidth, int destHeight) {
        this(DimensionConstrain.createAbsolutionDimension(destWidth, destHeight));
    }

    public ResampleOp(DimensionConstrain dimensionConstrain) {
        super(dimensionConstrain);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ResampleFilter filter) {
        this.filter = filter;
    }

    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    public BufferedImage doFilter(BufferedImage srcImg, BufferedImage dest, int dstWidth, int dstHeight) {
        BufferedImage out;
        byte[] outPixels;
        this.dstWidth = dstWidth;
        this.dstHeight = dstHeight;
        if (dstWidth < 3 || dstHeight < 3) {
            throw new RuntimeException("Error doing rescale. Target size was " + dstWidth + "x" + dstHeight + " but must be at least 3x3.");
        }
        assert (this.multipleInvocationLock.incrementAndGet() == 1) : "Multiple concurrent invocations detected";
        if (srcImg.getType() == 12 || srcImg.getType() == 13 || srcImg.getType() == 0) {
            srcImg = ImageUtils.convert(srcImg, srcImg.getColorModel().hasAlpha() ? 6 : 5);
        }
        this.nrChannels = ImageUtils.nrChannels(srcImg);
        assert (this.nrChannels > 0);
        this.srcWidth = srcImg.getWidth();
        this.srcHeight = srcImg.getHeight();
        byte[][] workPixels = new byte[this.srcHeight][dstWidth * this.nrChannels];
        this.processedItems = 0;
        this.totalItems = this.srcHeight + dstWidth;
        this.horizontalSubsamplingData = ResampleOp.createSubSampling(this.filter, this.srcWidth, dstWidth);
        this.verticalSubsamplingData = ResampleOp.createSubSampling(this.filter, this.srcHeight, dstHeight);
        final BufferedImage scrImgCopy = srcImg;
        final byte[][] workPixelsCopy = workPixels;
        Thread[] threads = new Thread[this.numberOfThreads - 1];
        for (int i10 = 1; i10 < this.numberOfThreads; ++i10) {
            final int finalI = i10;
            threads[i10 - 1] = new Thread(new Runnable(){

                public void run() {
                    ResampleOp.this.horizontallyFromSrcToWork(scrImgCopy, workPixelsCopy, finalI, ResampleOp.this.numberOfThreads);
                }
            });
            threads[i10 - 1].start();
        }
        this.horizontallyFromSrcToWork(scrImgCopy, workPixelsCopy, 0, this.numberOfThreads);
        this.waitForAllThreads(threads);
        final byte[] outPixelsCopy = outPixels = new byte[dstWidth * dstHeight * this.nrChannels];
        for (int i11 = 1; i11 < this.numberOfThreads; ++i11) {
            final int finalI = i11;
            threads[i11 - 1] = new Thread(new Runnable(){

                public void run() {
                    ResampleOp.this.verticalFromWorkToDst(workPixelsCopy, outPixelsCopy, finalI, ResampleOp.this.numberOfThreads);
                }
            });
            threads[i11 - 1].start();
        }
        this.verticalFromWorkToDst(workPixelsCopy, outPixelsCopy, 0, this.numberOfThreads);
        this.waitForAllThreads(threads);
        workPixels = null;
        if (dest != null && dstWidth == dest.getWidth() && dstHeight == dest.getHeight()) {
            out = dest;
            int nrDestChannels = ImageUtils.nrChannels(dest);
            if (nrDestChannels != this.nrChannels) {
                String errorMgs = String.format("Destination image must be compatible width source image. Source image had %d channels destination image had %d channels", this.nrChannels, nrDestChannels);
                throw new RuntimeException(errorMgs);
            }
        } else {
            out = new BufferedImage(dstWidth, dstHeight, this.getResultBufferedImageType(srcImg));
        }
        ImageUtils.setBGRPixels(outPixels, out, 0, 0, dstWidth, dstHeight);
        assert (this.multipleInvocationLock.decrementAndGet() == 0) : "Multiple concurrent invocations detected";
        return out;
    }

    private void waitForAllThreads(Thread[] threads) {
        try {
            for (Thread t10 : threads) {
                t10.join(Long.MAX_VALUE);
            }
        }
        catch (InterruptedException e10) {
            e10.printStackTrace();
            throw new RuntimeException(e10);
        }
    }

    static SubSamplingData createSubSampling(ResampleFilter filter, int srcSize, int dstSize) {
        int[] arrPixel;
        float[] arrWeight;
        int numContributors;
        float scale = (float)dstSize / (float)srcSize;
        int[] arrN = new int[dstSize];
        float fwidth = filter.getSamplingRadius();
        if (scale < 1.0f) {
            float centerOffset = 0.5f / scale;
            float width = fwidth / scale;
            numContributors = (int)(width * 2.0f + 2.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            float fNormFac = (float)(1.0 / (Math.ceil(width) / (double)fwidth));
            for (int i10 = 0; i10 < dstSize; ++i10) {
                int k10;
                int subindex = i10 * numContributors;
                float center = (float)i10 / scale + centerOffset;
                int left = (int)Math.floor(center - width);
                int right = (int)Math.ceil(center + width);
                for (int j10 = left; j10 <= right; ++j10) {
                    float weight = filter.apply((center - (float)j10) * fNormFac);
                    if (weight == 0.0f) continue;
                    int n10 = j10 < 0 ? -j10 : (j10 >= srcSize ? srcSize - j10 + srcSize - 1 : j10);
                    int k11 = arrN[i10];
                    int n11 = i10;
                    arrN[n11] = arrN[n11] + 1;
                    if (n10 < 0 || n10 >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k11] = n10;
                    arrWeight[subindex + k11] = weight;
                }
                int max = arrN[i10];
                float tot = 0.0f;
                for (k10 = 0; k10 < max; ++k10) {
                    tot += arrWeight[subindex + k10];
                }
                if (tot == 0.0f) continue;
                for (k10 = 0; k10 < max; ++k10) {
                    int n12 = subindex + k10;
                    arrWeight[n12] = arrWeight[n12] / tot;
                }
            }
        } else {
            numContributors = (int)(fwidth * 2.0f + 1.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            for (int i11 = 0; i11 < dstSize; ++i11) {
                int k12;
                int subindex = i11 * numContributors;
                float center = (float)i11 / scale;
                int left = (int)Math.floor(center - fwidth);
                int right = (int)Math.ceil(center + fwidth);
                for (int j11 = left; j11 <= right; ++j11) {
                    float weight = filter.apply(center - (float)j11);
                    if (weight == 0.0f) continue;
                    int n13 = j11 < 0 ? -j11 : (j11 >= srcSize ? srcSize - j11 + srcSize - 1 : j11);
                    int k13 = arrN[i11];
                    int n14 = i11;
                    arrN[n14] = arrN[n14] + 1;
                    if (n13 < 0 || n13 >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k13] = n13;
                    arrWeight[subindex + k13] = weight;
                }
                int max = arrN[i11];
                float tot = 0.0f;
                for (k12 = 0; k12 < max; ++k12) {
                    tot += arrWeight[subindex + k12];
                }
                assert (tot != 0.0f) : "should never happen except bug in filter";
                if (tot == 0.0f) continue;
                for (k12 = 0; k12 < max; ++k12) {
                    int n15 = subindex + k12;
                    arrWeight[n15] = arrWeight[n15] / tot;
                }
            }
        }
        return new SubSamplingData(arrN, arrPixel, arrWeight, numContributors);
    }

    private void verticalFromWorkToDst(byte[][] workPixels, byte[] outPixels, int start, int delta) {
        if (this.nrChannels == 1) {
            this.verticalFromWorkToDstGray(workPixels, outPixels, start, this.numberOfThreads);
            return;
        }
        boolean useChannel3 = this.nrChannels > 3;
        for (int x10 = start; x10 < this.dstWidth; x10 += delta) {
            int xLocation = x10 * this.nrChannels;
            for (int y10 = this.dstHeight - 1; y10 >= 0; --y10) {
                int yTimesNumContributors = y10 * this.verticalSubsamplingData.numContributors;
                int max = this.verticalSubsamplingData.arrN[y10];
                int sampleLocation = (y10 * this.dstWidth + x10) * this.nrChannels;
                float sample0 = 0.0f;
                float sample1 = 0.0f;
                float sample2 = 0.0f;
                float sample3 = 0.0f;
                int index = yTimesNumContributors;
                for (int j10 = max - 1; j10 >= 0; --j10) {
                    int valueLocation = this.verticalSubsamplingData.arrPixel[index];
                    float arrWeight = this.verticalSubsamplingData.arrWeight[index];
                    sample0 += (float)(workPixels[valueLocation][xLocation] & 0xFF) * arrWeight;
                    sample1 += (float)(workPixels[valueLocation][xLocation + 1] & 0xFF) * arrWeight;
                    sample2 += (float)(workPixels[valueLocation][xLocation + 2] & 0xFF) * arrWeight;
                    if (useChannel3) {
                        sample3 += (float)(workPixels[valueLocation][xLocation + 3] & 0xFF) * arrWeight;
                    }
                    ++index;
                }
                outPixels[sampleLocation] = this.toByte(sample0);
                outPixels[sampleLocation + 1] = this.toByte(sample1);
                outPixels[sampleLocation + 2] = this.toByte(sample2);
                if (!useChannel3) continue;
                outPixels[sampleLocation + 3] = this.toByte(sample3);
            }
            ++this.processedItems;
            if (start != 0) continue;
            this.setProgress();
        }
    }

    private void verticalFromWorkToDstGray(byte[][] workPixels, byte[] outPixels, int start, int delta) {
        for (int x10 = start; x10 < this.dstWidth; x10 += delta) {
            int xLocation = x10;
            for (int y10 = this.dstHeight - 1; y10 >= 0; --y10) {
                int yTimesNumContributors = y10 * this.verticalSubsamplingData.numContributors;
                int max = this.verticalSubsamplingData.arrN[y10];
                int sampleLocation = y10 * this.dstWidth + x10;
                float sample0 = 0.0f;
                int index = yTimesNumContributors;
                for (int j10 = max - 1; j10 >= 0; --j10) {
                    int valueLocation = this.verticalSubsamplingData.arrPixel[index];
                    float arrWeight = this.verticalSubsamplingData.arrWeight[index];
                    sample0 += (float)(workPixels[valueLocation][xLocation] & 0xFF) * arrWeight;
                    ++index;
                }
                outPixels[sampleLocation] = this.toByte(sample0);
            }
            ++this.processedItems;
            if (start != 0) continue;
            this.setProgress();
        }
    }

    private void horizontallyFromSrcToWork(BufferedImage srcImg, byte[][] workPixels, int start, int delta) {
        if (this.nrChannels == 1) {
            this.horizontallyFromSrcToWorkGray(srcImg, workPixels, start, delta);
            return;
        }
        int[] tempPixels = new int[this.srcWidth];
        byte[] srcPixels = new byte[this.srcWidth * this.nrChannels];
        boolean useChannel3 = this.nrChannels > 3;
        for (int k10 = start; k10 < this.srcHeight; k10 += delta) {
            ImageUtils.getPixelsBGR(srcImg, k10, this.srcWidth, srcPixels, tempPixels);
            for (int i10 = this.dstWidth - 1; i10 >= 0; --i10) {
                int sampleLocation = i10 * this.nrChannels;
                int max = this.horizontalSubsamplingData.arrN[i10];
                float sample0 = 0.0f;
                float sample1 = 0.0f;
                float sample2 = 0.0f;
                float sample3 = 0.0f;
                int index = i10 * this.horizontalSubsamplingData.numContributors;
                for (int j10 = max - 1; j10 >= 0; --j10) {
                    float arrWeight = this.horizontalSubsamplingData.arrWeight[index];
                    int pixelIndex = this.horizontalSubsamplingData.arrPixel[index] * this.nrChannels;
                    sample0 += (float)(srcPixels[pixelIndex] & 0xFF) * arrWeight;
                    sample1 += (float)(srcPixels[pixelIndex + 1] & 0xFF) * arrWeight;
                    sample2 += (float)(srcPixels[pixelIndex + 2] & 0xFF) * arrWeight;
                    if (useChannel3) {
                        sample3 += (float)(srcPixels[pixelIndex + 3] & 0xFF) * arrWeight;
                    }
                    ++index;
                }
                workPixels[k10][sampleLocation] = this.toByte(sample0);
                workPixels[k10][sampleLocation + 1] = this.toByte(sample1);
                workPixels[k10][sampleLocation + 2] = this.toByte(sample2);
                if (!useChannel3) continue;
                workPixels[k10][sampleLocation + 3] = this.toByte(sample3);
            }
            ++this.processedItems;
            if (start != 0) continue;
            this.setProgress();
        }
    }

    private void horizontallyFromSrcToWorkGray(BufferedImage srcImg, byte[][] workPixels, int start, int delta) {
        int[] tempPixels = new int[this.srcWidth];
        byte[] srcPixels = new byte[this.srcWidth];
        for (int k10 = start; k10 < this.srcHeight; k10 += delta) {
            ImageUtils.getPixelsBGR(srcImg, k10, this.srcWidth, srcPixels, tempPixels);
            for (int i10 = this.dstWidth - 1; i10 >= 0; --i10) {
                int sampleLocation = i10;
                int max = this.horizontalSubsamplingData.arrN[i10];
                float sample0 = 0.0f;
                int index = i10 * this.horizontalSubsamplingData.numContributors;
                for (int j10 = max - 1; j10 >= 0; --j10) {
                    float arrWeight = this.horizontalSubsamplingData.arrWeight[index];
                    int pixelIndex = this.horizontalSubsamplingData.arrPixel[index];
                    sample0 += (float)(srcPixels[pixelIndex] & 0xFF) * arrWeight;
                    ++index;
                }
                workPixels[k10][sampleLocation] = this.toByte(sample0);
            }
            ++this.processedItems;
            if (start != 0) continue;
            this.setProgress();
        }
    }

    private byte toByte(float f10) {
        if (f10 < 0.0f) {
            return 0;
        }
        if (f10 > 255.0f) {
            return -1;
        }
        return (byte)(f10 + 0.5f);
    }

    private void setProgress() {
        this.fireProgressChanged((float)this.processedItems / this.totalItems);
    }

    protected int getResultBufferedImageType(BufferedImage srcImg) {
        return this.nrChannels == 3 ? 5 : (this.nrChannels == 4 ? 6 : (srcImg.getSampleModel().getDataType() == 1 ? 11 : 10));
    }

    static class SubSamplingData {
        private final int[] arrN;
        private final int[] arrPixel;
        private final float[] arrWeight;
        private final int numContributors;

        private SubSamplingData(int[] arrN, int[] arrPixel, float[] arrWeight, int numContributors) {
            this.arrN = arrN;
            this.arrPixel = arrPixel;
            this.arrWeight = arrWeight;
            this.numContributors = numContributors;
        }

        public int getNumContributors() {
            return this.numContributors;
        }

        public int[] getArrN() {
            return this.arrN;
        }

        public int[] getArrPixel() {
            return this.arrPixel;
        }

        public float[] getArrWeight() {
            return this.arrWeight;
        }
    }
}

