/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling.experimental;

import com.mortennobel.imagescaling.AdvancedResizeOp;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ImageUtils;
import com.mortennobel.imagescaling.ResampleFilter;
import com.mortennobel.imagescaling.ResampleFilters;
import java.awt.image.BufferedImage;
import java.util.BitSet;

public class ResampleOpSingleThread
extends AdvancedResizeOp {
    private final int MAX_CHANNEL_VALUE = 255;
    private int nrChannels;
    private int srcWidth;
    private int srcHeight;
    private int dstWidth;
    private int dstHeight;
    private SubSamplingData horizontalSubsamplingData;
    private SubSamplingData verticalSubsamplingData;
    private int processedItems;
    private int totalItems;
    private ResampleFilter filter = ResampleFilters.getLanczos3Filter();

    public ResampleOpSingleThread(int destWidth, int destHeight) {
        super(DimensionConstrain.createAbsolutionDimension(destWidth, destHeight));
    }

    public ResampleOpSingleThread(DimensionConstrain dimensionConstrain) {
        super(dimensionConstrain);
    }

    public ResampleFilter getFilter() {
        return this.filter;
    }

    public void setFilter(ResampleFilter filter) {
        this.filter = filter;
    }

    public BufferedImage doFilter(BufferedImage srcImg, BufferedImage dest, int dstWidth, int dstHeight) {
        int i10;
        this.dstWidth = dstWidth;
        this.dstHeight = dstHeight;
        if (srcImg.getType() == 12 || srcImg.getType() == 13 || srcImg.getType() == 0) {
            srcImg = ImageUtils.convert(srcImg, srcImg.getColorModel().hasAlpha() ? 6 : 5);
        }
        this.nrChannels = ImageUtils.nrChannels(srcImg);
        assert (this.nrChannels > 0);
        this.srcWidth = srcImg.getWidth();
        this.srcHeight = srcImg.getHeight();
        this.processedItems = 0;
        this.totalItems = this.srcHeight;
        this.horizontalSubsamplingData = this.createSubSampling(this.srcWidth, dstWidth);
        this.verticalSubsamplingData = this.createSubSampling(this.srcHeight, dstHeight);
        int bufferHeight = (int)Math.ceil(this.verticalSubsamplingData.width) * 2;
        byte[][] workPixels = new byte[this.srcHeight][];
        for (i10 = 0; i10 < bufferHeight && i10 < this.srcHeight; ++i10) {
            workPixels[i10] = new byte[dstWidth * this.nrChannels];
        }
        for (i10 = bufferHeight; i10 < workPixels.length; ++i10) {
            workPixels[i10] = workPixels[i10 % bufferHeight];
        }
        byte[][] workPixelsCopy = workPixels;
        BufferedImage out = dest != null && dstWidth == dest.getWidth() && dstHeight == dest.getHeight() ? dest : new BufferedImage(dstWidth, dstHeight, this.getResultBufferedImageType(srcImg));
        this.scale(srcImg, workPixelsCopy, out);
        return out;
    }

    private SubSamplingData createSubSampling(int srcSize, int dstSize) {
        int[] arrPixel;
        float[] arrWeight;
        int numContributors;
        float width;
        float scale = (float)dstSize / (float)srcSize;
        int[] arrN = new int[dstSize];
        float fwidth = this.filter.getSamplingRadius();
        if (scale < 1.0f) {
            width = fwidth / scale;
            numContributors = (int)(width * 2.0f + 2.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            float fNormFac = (float)(1.0 / (Math.ceil(width) / (double)fwidth));
            for (int i10 = 0; i10 < dstSize; ++i10) {
                int k10;
                int subindex = i10 * numContributors;
                float center = (float)i10 / scale;
                int left = (int)Math.floor(center - width);
                int right = (int)Math.ceil(center + width);
                assert (right - left <= numContributors);
                for (int j10 = left; j10 <= right; ++j10) {
                    float weight = this.filter.apply((center - (float)j10) * fNormFac);
                    if (weight == 0.0f) continue;
                    int n10 = j10 < 0 ? -j10 : (j10 >= srcSize ? srcSize - j10 + srcSize - 1 : j10);
                    int k11 = arrN[i10];
                    int n11 = i10;
                    arrN[n11] = arrN[n11] + 1;
                    if (n10 < 0 || n10 >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k11] = n10;
                    arrWeight[subindex + k11] = weight;
                }
                int max = arrN[i10];
                float tot = 0.0f;
                for (k10 = 0; k10 < max; ++k10) {
                    tot += arrWeight[subindex + k10];
                }
                if (tot == 0.0f) continue;
                for (k10 = 0; k10 < max; ++k10) {
                    int n12 = subindex + k10;
                    arrWeight[n12] = arrWeight[n12] / tot;
                }
            }
        } else {
            width = fwidth;
            numContributors = (int)(fwidth * 2.0f + 1.0f);
            arrWeight = new float[dstSize * numContributors];
            arrPixel = new int[dstSize * numContributors];
            for (int i11 = 0; i11 < dstSize; ++i11) {
                int k12;
                int subindex = i11 * numContributors;
                float center = (float)i11 / scale;
                int left = (int)Math.floor(center - fwidth);
                int right = (int)Math.ceil(center + fwidth);
                for (int j11 = left; j11 <= right; ++j11) {
                    float weight = this.filter.apply(center - (float)j11);
                    if (weight == 0.0f) continue;
                    int n13 = j11 < 0 ? -j11 : (j11 >= srcSize ? srcSize - j11 + srcSize - 1 : j11);
                    int k13 = arrN[i11];
                    int n14 = i11;
                    arrN[n14] = arrN[n14] + 1;
                    if (n13 < 0 || n13 >= srcSize) {
                        weight = 0.0f;
                    }
                    arrPixel[subindex + k13] = n13;
                    arrWeight[subindex + k13] = weight;
                }
                int max = arrN[i11];
                float tot = 0.0f;
                for (k12 = 0; k12 < max; ++k12) {
                    tot += arrWeight[subindex + k12];
                }
                assert (tot != 0.0f) : "should never happen except bug in filter";
                if (tot == 0.0f) continue;
                for (k12 = 0; k12 < max; ++k12) {
                    int n15 = subindex + k12;
                    arrWeight[n15] = arrWeight[n15] / tot;
                }
            }
        }
        return new SubSamplingData(arrN, arrPixel, arrWeight, numContributors, width);
    }

    private void scale(BufferedImage srcImg, byte[][] workPixels, BufferedImage outImage) {
        int[] tempPixels = new int[this.srcWidth];
        byte[] srcPixels = new byte[this.srcWidth * this.nrChannels];
        byte[] dstPixels = new byte[this.dstWidth * this.nrChannels];
        BitSet isRowInitialized = new BitSet(this.srcHeight);
        for (int dstY = this.dstHeight - 1; dstY >= 0; --dstY) {
            int channel;
            int yTimesNumContributors = dstY * this.verticalSubsamplingData.numContributors;
            int max = this.verticalSubsamplingData.arrN[dstY];
            int index = yTimesNumContributors;
            for (int j10 = max - 1; j10 >= 0; --j10) {
                int valueLocation = this.verticalSubsamplingData.arrPixel[index];
                ++index;
                if (isRowInitialized.get(valueLocation)) continue;
                isRowInitialized.set(valueLocation);
                ImageUtils.getPixelsBGR(srcImg, valueLocation, this.srcWidth, srcPixels, tempPixels);
                for (channel = this.nrChannels - 1; channel >= 0; --channel) {
                    this.getSamplesHorizontal(srcPixels, channel, tempPixels);
                    for (int i10 = this.dstWidth - 1; i10 >= 0; --i10) {
                        int sampleLocation = i10 * this.nrChannels;
                        int horizontalMax = this.horizontalSubsamplingData.arrN[i10];
                        float sample = 0.0f;
                        int horizontalIndex = i10 * this.horizontalSubsamplingData.numContributors;
                        for (int jj2 = horizontalMax - 1; jj2 >= 0; --jj2) {
                            sample += (float)tempPixels[this.horizontalSubsamplingData.arrPixel[horizontalIndex]] * this.horizontalSubsamplingData.arrWeight[horizontalIndex];
                            ++horizontalIndex;
                        }
                        this.putSample(workPixels[valueLocation], channel, (int)sample, sampleLocation);
                    }
                }
            }
            for (int x10 = 0; x10 < this.dstWidth; ++x10) {
                int xLocation = x10 * this.nrChannels;
                int sampleLocation = x10 * this.nrChannels;
                for (channel = this.nrChannels - 1; channel >= 0; --channel) {
                    float sample = 0.0f;
                    int index2 = yTimesNumContributors;
                    for (int j11 = max - 1; j11 >= 0; --j11) {
                        int valueLocation = this.verticalSubsamplingData.arrPixel[index2];
                        sample += (float)(workPixels[valueLocation][xLocation + channel] & 0xFF) * this.verticalSubsamplingData.arrWeight[index2];
                        ++index2;
                    }
                    this.putSample(dstPixels, channel, sample, sampleLocation);
                }
            }
            ImageUtils.setBGRPixels(dstPixels, outImage, 0, dstY, this.dstWidth, 1);
            this.setProgress(this.processedItems++, this.totalItems);
        }
    }

    private void putSample(byte[] image, int channel, float sample, int location) {
        int result = (int)sample;
        if (sample < 0.0f) {
            result = 0;
        } else if (result > 255) {
            result = 255;
        }
        image[location + channel] = (byte)result;
    }

    private void getSamplesHorizontal(byte[] src, int channel, int[] dest) {
        int xDest = 0;
        int x10 = channel;
        while (x10 < src.length) {
            dest[xDest] = src[x10] & 0xFF;
            x10 += this.nrChannels;
            ++xDest;
        }
    }

    private void setProgress(int zeroBasedIndex, int totalItems) {
        this.fireProgressChanged((float)zeroBasedIndex / (float)totalItems);
    }

    protected int getResultBufferedImageType(BufferedImage srcImg) {
        return this.nrChannels == 3 ? 5 : (this.nrChannels == 4 ? 6 : (srcImg.getSampleModel().getDataType() == 1 ? 11 : 10));
    }

    private class SubSamplingData {
        private final int[] arrN;
        private final int[] arrPixel;
        private final float[] arrWeight;
        private final int numContributors;
        private final float width;

        private SubSamplingData(int[] arrN, int[] arrPixel, float[] arrWeight, int numContributors, float width) {
            this.arrN = arrN;
            this.arrPixel = arrPixel;
            this.arrWeight = arrWeight;
            this.numContributors = numContributors;
            this.width = width;
        }
    }
}

