/*
 * Decompiled with CFR 0.152.
 */
package com.sun.activation.registries;

import java.util.NoSuchElementException;
import java.util.Vector;

class LineTokenizer {
    private int currentPosition = 0;
    private int maxPosition;
    private String str;
    private Vector stack = new Vector();
    private static final String singles = "=";

    public LineTokenizer(String str) {
        this.str = str;
        this.maxPosition = str.length();
    }

    private void skipWhiteSpace() {
        while (this.currentPosition < this.maxPosition && Character.isWhitespace(this.str.charAt(this.currentPosition))) {
            ++this.currentPosition;
        }
    }

    public boolean hasMoreTokens() {
        if (this.stack.size() > 0) {
            return true;
        }
        this.skipWhiteSpace();
        return this.currentPosition < this.maxPosition;
    }

    public String nextToken() {
        int start;
        char c10;
        int size = this.stack.size();
        if (size > 0) {
            String t10 = (String)this.stack.elementAt(size - 1);
            this.stack.removeElementAt(size - 1);
            return t10;
        }
        this.skipWhiteSpace();
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        if ((c10 = this.str.charAt(start = this.currentPosition++)) == '\"') {
            boolean filter = false;
            while (this.currentPosition < this.maxPosition) {
                String s10;
                if ((c10 = this.str.charAt(this.currentPosition++)) == '\\') {
                    ++this.currentPosition;
                    filter = true;
                    continue;
                }
                if (c10 != '\"') continue;
                if (filter) {
                    StringBuffer sb2 = new StringBuffer();
                    for (int i10 = start + 1; i10 < this.currentPosition - 1; ++i10) {
                        c10 = this.str.charAt(i10);
                        if (c10 == '\\') continue;
                        sb2.append(c10);
                    }
                    s10 = sb2.toString();
                } else {
                    s10 = this.str.substring(start + 1, this.currentPosition - 1);
                }
                return s10;
            }
        } else if (singles.indexOf(c10) >= 0) {
            ++this.currentPosition;
        } else {
            while (this.currentPosition < this.maxPosition && singles.indexOf(this.str.charAt(this.currentPosition)) < 0 && !Character.isWhitespace(this.str.charAt(this.currentPosition))) {
                ++this.currentPosition;
            }
        }
        return this.str.substring(start, this.currentPosition);
    }

    public void pushToken(String token) {
        this.stack.addElement(token);
    }
}

