/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Function;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeString;
import com.sun.jna.Pointer;
import com.sun.jna.WString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringArray
extends Memory
implements Function.PostCallRead {
    private String encoding;
    private List<NativeString> natives = new ArrayList<NativeString>();
    private Object[] original;

    public StringArray(String[] strings) {
        this(strings, false);
    }

    public StringArray(String[] strings, boolean wide) {
        this((Object[])strings, wide ? "--WIDE-STRING--" : Native.getDefaultStringEncoding());
    }

    public StringArray(String[] strings, String encoding) {
        this((Object[])strings, encoding);
    }

    public StringArray(WString[] strings) {
        this(strings, "--WIDE-STRING--");
    }

    private StringArray(Object[] strings, String encoding) {
        super((strings.length + 1) * Native.POINTER_SIZE);
        this.original = strings;
        this.encoding = encoding;
        for (int i10 = 0; i10 < strings.length; ++i10) {
            Pointer p10 = null;
            if (strings[i10] != null) {
                NativeString ns2 = new NativeString(strings[i10].toString(), encoding);
                this.natives.add(ns2);
                p10 = ns2.getPointer();
            }
            this.setPointer(Native.POINTER_SIZE * i10, p10);
        }
        this.setPointer(Native.POINTER_SIZE * strings.length, null);
    }

    @Override
    public void read() {
        boolean returnWide = this.original instanceof WString[];
        boolean wide = "--WIDE-STRING--".equals(this.encoding);
        for (int si2 = 0; si2 < this.original.length; ++si2) {
            Pointer p10 = this.getPointer(si2 * Native.POINTER_SIZE);
            CharSequence s10 = null;
            if (p10 != null) {
                String string = s10 = wide ? p10.getWideString(0L) : p10.getString(0L, this.encoding);
                if (returnWide) {
                    s10 = new WString((String)s10);
                }
            }
            this.original[si2] = s10;
        }
    }

    @Override
    public String toString() {
        boolean wide = "--WIDE-STRING--".equals(this.encoding);
        String s10 = wide ? "const wchar_t*[]" : "const char*[]";
        s10 = s10 + Arrays.asList(this.original);
        return s10;
    }
}

