/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.dnd;

import com.sun.jna.platform.dnd.DragHandler;
import com.sun.jna.platform.dnd.DropTargetPainter;
import java.awt.Component;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DropHandler
implements DropTargetListener {
    private static final Logger LOG = Logger.getLogger(DropHandler.class.getName());
    private int acceptedActions;
    private List<DataFlavor> acceptedFlavors;
    private DropTarget dropTarget;
    private boolean active = true;
    private DropTargetPainter painter;
    private String lastAction;

    public DropHandler(Component c10, int acceptedActions) {
        this(c10, acceptedActions, new DataFlavor[0]);
    }

    public DropHandler(Component c10, int acceptedActions, DataFlavor[] acceptedFlavors) {
        this(c10, acceptedActions, acceptedFlavors, null);
    }

    public DropHandler(Component c10, int acceptedActions, DataFlavor[] acceptedFlavors, DropTargetPainter painter) {
        this.acceptedActions = acceptedActions;
        this.acceptedFlavors = Arrays.asList(acceptedFlavors);
        this.painter = painter;
        this.dropTarget = new DropTarget(c10, acceptedActions, this, this.active);
    }

    protected DropTarget getDropTarget() {
        return this.dropTarget;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.dropTarget != null) {
            this.dropTarget.setActive(active);
        }
    }

    protected int getDropActionsForFlavors(DataFlavor[] dataFlavors) {
        return this.acceptedActions;
    }

    protected int getDropAction(DropTargetEvent e10) {
        int availableActions;
        DropTargetEvent ev2;
        int currentAction = 0;
        int sourceActions = 0;
        Point location = null;
        DataFlavor[] flavors = new DataFlavor[]{};
        if (e10 instanceof DropTargetDragEvent) {
            ev2 = (DropTargetDragEvent)e10;
            currentAction = ((DropTargetDragEvent)ev2).getDropAction();
            sourceActions = ((DropTargetDragEvent)ev2).getSourceActions();
            flavors = ((DropTargetDragEvent)ev2).getCurrentDataFlavors();
            location = ((DropTargetDragEvent)ev2).getLocation();
        } else if (e10 instanceof DropTargetDropEvent) {
            ev2 = (DropTargetDropEvent)e10;
            currentAction = ((DropTargetDropEvent)ev2).getDropAction();
            sourceActions = ((DropTargetDropEvent)ev2).getSourceActions();
            flavors = ((DropTargetDropEvent)ev2).getCurrentDataFlavors();
            location = ((DropTargetDropEvent)ev2).getLocation();
        }
        if (this.isSupported(flavors) && (currentAction = this.getDropAction(e10, currentAction, sourceActions, availableActions = this.getDropActionsForFlavors(flavors))) != 0 && this.canDrop(e10, currentAction, location)) {
            return currentAction;
        }
        return 0;
    }

    protected int getDropAction(DropTargetEvent e10, int currentAction, int sourceActions, int acceptedActions) {
        int action;
        boolean modifiersActive = this.modifiersActive(currentAction);
        if ((currentAction & acceptedActions) == 0 && !modifiersActive) {
            int action2;
            currentAction = action2 = acceptedActions & sourceActions;
        } else if (modifiersActive && (action = currentAction & acceptedActions & sourceActions) != currentAction) {
            currentAction = action;
        }
        return currentAction;
    }

    protected boolean modifiersActive(int dropAction) {
        int mods = DragHandler.getModifiers();
        if (mods == -1) {
            return dropAction == 0x40000000 || dropAction == 1;
        }
        return mods != 0;
    }

    private void describe(String type, DropTargetEvent e10) {
        if (LOG.isLoggable(Level.FINE)) {
            DropTargetContext dtc;
            StringBuilder msgBuilder = new StringBuilder();
            msgBuilder.append("drop: ");
            msgBuilder.append(type);
            if (e10 instanceof DropTargetDragEvent) {
                dtc = e10.getDropTargetContext();
                DropTarget dt2 = dtc.getDropTarget();
                DropTargetDragEvent ev2 = (DropTargetDragEvent)e10;
                msgBuilder.append(": src=");
                msgBuilder.append(DragHandler.actionString(ev2.getSourceActions()));
                msgBuilder.append(" tgt=");
                msgBuilder.append(DragHandler.actionString(dt2.getDefaultActions()));
                msgBuilder.append(" act=");
                msgBuilder.append(DragHandler.actionString(ev2.getDropAction()));
            } else if (e10 instanceof DropTargetDropEvent) {
                dtc = e10.getDropTargetContext();
                DropTarget dt3 = dtc.getDropTarget();
                DropTargetDropEvent ev3 = (DropTargetDropEvent)e10;
                msgBuilder.append(": src=");
                msgBuilder.append(DragHandler.actionString(ev3.getSourceActions()));
                msgBuilder.append(" tgt=");
                msgBuilder.append(DragHandler.actionString(dt3.getDefaultActions()));
                msgBuilder.append(" act=");
                msgBuilder.append(DragHandler.actionString(ev3.getDropAction()));
            }
            String msg = msgBuilder.toString();
            if (!msg.equals(this.lastAction)) {
                LOG.log(Level.FINE, msg);
                this.lastAction = msg;
            }
        }
    }

    protected int acceptOrReject(DropTargetDragEvent e10) {
        int action = this.getDropAction(e10);
        if (action != 0) {
            e10.acceptDrag(action);
        } else {
            e10.rejectDrag();
        }
        return action;
    }

    @Override
    public void dragEnter(DropTargetDragEvent e10) {
        this.describe("enter(tgt)", e10);
        int action = this.acceptOrReject(e10);
        this.paintDropTarget(e10, action, e10.getLocation());
    }

    @Override
    public void dragOver(DropTargetDragEvent e10) {
        this.describe("over(tgt)", e10);
        int action = this.acceptOrReject(e10);
        this.paintDropTarget(e10, action, e10.getLocation());
    }

    @Override
    public void dragExit(DropTargetEvent e10) {
        this.describe("exit(tgt)", e10);
        this.paintDropTarget(e10, 0, null);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e10) {
        this.describe("change(tgt)", e10);
        int action = this.acceptOrReject(e10);
        this.paintDropTarget(e10, action, e10.getLocation());
    }

    @Override
    public void drop(DropTargetDropEvent e10) {
        this.describe("drop(tgt)", e10);
        int action = this.getDropAction(e10);
        if (action != 0) {
            e10.acceptDrop(action);
            try {
                this.drop(e10, action);
                e10.dropComplete(true);
            }
            catch (Exception ex2) {
                e10.dropComplete(false);
            }
        } else {
            e10.rejectDrop();
        }
        this.paintDropTarget(e10, 0, e10.getLocation());
    }

    protected boolean isSupported(DataFlavor[] flavors) {
        HashSet<DataFlavor> set = new HashSet<DataFlavor>(Arrays.asList(flavors));
        set.retainAll(this.acceptedFlavors);
        return !set.isEmpty();
    }

    protected void paintDropTarget(DropTargetEvent e10, int action, Point location) {
        if (this.painter != null) {
            this.painter.paintDropTarget(e10, action, location);
        }
    }

    protected boolean canDrop(DropTargetEvent e10, int action, Point location) {
        return true;
    }

    protected abstract void drop(DropTargetDropEvent var1, int var2) throws UnsupportedFlavorException, IOException;
}

