/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.extended;

import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import java.util.Locale;

public class LocaleConverter
extends AbstractSingleValueConverter {
    public boolean canConvert(Class type) {
        return type.equals(Locale.class);
    }

    public Object fromString(String str) {
        String variant;
        String country;
        String language;
        int[] underscorePositions = this.underscorePositions(str);
        if (underscorePositions[0] == -1) {
            language = str;
            country = "";
            variant = "";
        } else if (underscorePositions[1] == -1) {
            language = str.substring(0, underscorePositions[0]);
            country = str.substring(underscorePositions[0] + 1);
            variant = "";
        } else {
            language = str.substring(0, underscorePositions[0]);
            country = str.substring(underscorePositions[0] + 1, underscorePositions[1]);
            variant = str.substring(underscorePositions[1] + 1);
        }
        return new Locale(language, country, variant);
    }

    private int[] underscorePositions(String in2) {
        int[] result = new int[2];
        for (int i10 = 0; i10 < result.length; ++i10) {
            int last = i10 == 0 ? 0 : result[i10 - 1];
            result[i10] = in2.indexOf(95, last + 1);
        }
        return result;
    }
}

