/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.reflection.FieldKey;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.ImmutableFieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.MissingFieldException;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.core.JVM;
import com.thoughtworks.xstream.core.util.OrderRetainingMap;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class FieldDictionary
implements Caching {
    private static final DictionaryEntry OBJECT_DICTIONARY_ENTRY = new DictionaryEntry(Collections.EMPTY_MAP, Collections.EMPTY_MAP);
    private transient Map dictionaryEntries;
    private final FieldKeySorter sorter;

    public FieldDictionary() {
        this(new ImmutableFieldKeySorter());
    }

    public FieldDictionary(FieldKeySorter sorter) {
        this.sorter = sorter;
        this.init();
    }

    private void init() {
        this.dictionaryEntries = new HashMap();
    }

    public Iterator serializableFieldsFor(Class cls) {
        return this.fieldsFor(cls);
    }

    public Iterator fieldsFor(Class cls) {
        return this.buildMap(cls, true).values().iterator();
    }

    public Field field(Class cls, String name, Class definedIn) {
        Field field = this.fieldOrNull(cls, name, definedIn);
        if (field == null) {
            throw new MissingFieldException(cls.getName(), name);
        }
        return field;
    }

    public Field fieldOrNull(Class cls, String name, Class definedIn) {
        Map fields = this.buildMap(cls, definedIn != null);
        Field field = (Field)fields.get(definedIn != null ? new FieldKey(name, definedIn, -1) : name);
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map buildMap(Class type, boolean tupleKeyed) {
        Class cls2 = type;
        DictionaryEntry lastDictionaryEntry = null;
        LinkedList superClasses = new LinkedList();
        while (lastDictionaryEntry == null) {
            lastDictionaryEntry = Object.class.equals((Object)cls2) || cls2 == null ? OBJECT_DICTIONARY_ENTRY : this.getDictionaryEntry(cls2);
            if (lastDictionaryEntry != null) continue;
            superClasses.addFirst(cls2);
            cls2 = cls2.getSuperclass();
        }
        for (Class cls2 : superClasses) {
            DictionaryEntry newDictionaryEntry = this.buildDictionaryEntryForClass(cls2, lastDictionaryEntry);
            FieldDictionary fieldDictionary = this;
            synchronized (fieldDictionary) {
                DictionaryEntry concurrentEntry = this.getDictionaryEntry(cls2);
                if (concurrentEntry == null) {
                    this.dictionaryEntries.put(cls2, newDictionaryEntry);
                } else {
                    newDictionaryEntry = concurrentEntry;
                }
            }
            lastDictionaryEntry = newDictionaryEntry;
        }
        return tupleKeyed ? lastDictionaryEntry.getKeyedByFieldKey() : lastDictionaryEntry.getKeyedByFieldName();
    }

    private DictionaryEntry buildDictionaryEntryForClass(Class cls, DictionaryEntry lastDictionaryEntry) {
        int i10;
        HashMap<String, Field> keyedByFieldName = new HashMap<String, Field>(lastDictionaryEntry.getKeyedByFieldName());
        OrderRetainingMap keyedByFieldKey = new OrderRetainingMap(lastDictionaryEntry.getKeyedByFieldKey());
        Field[] fields = cls.getDeclaredFields();
        if (JVM.reverseFieldDefinition()) {
            i10 = fields.length >> 1;
            while (i10-- > 0) {
                int idx = fields.length - i10 - 1;
                Field field = fields[i10];
                fields[i10] = fields[idx];
                fields[idx] = field;
            }
        }
        for (i10 = 0; i10 < fields.length; ++i10) {
            Field field = fields[i10];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            FieldKey fieldKey = new FieldKey(field.getName(), field.getDeclaringClass(), i10);
            Field existent = (Field)keyedByFieldName.get(field.getName());
            if (existent == null || (existent.getModifiers() & 8) != 0 || existent != null && (field.getModifiers() & 8) == 0) {
                keyedByFieldName.put(field.getName(), field);
            }
            keyedByFieldKey.put(fieldKey, field);
        }
        Map sortedFieldKeys = this.sorter.sort(cls, keyedByFieldKey);
        return new DictionaryEntry(keyedByFieldName, sortedFieldKeys);
    }

    private synchronized DictionaryEntry getDictionaryEntry(Class cls) {
        return (DictionaryEntry)this.dictionaryEntries.get(cls);
    }

    public synchronized void flushCache() {
        this.dictionaryEntries.clear();
        if (this.sorter instanceof Caching) {
            ((Caching)((Object)this.sorter)).flushCache();
        }
    }

    protected Object readResolve() {
        this.init();
        return this;
    }

    private static final class DictionaryEntry {
        private final Map keyedByFieldName;
        private final Map keyedByFieldKey;

        public DictionaryEntry(Map keyedByFieldName, Map keyedByFieldKey) {
            this.keyedByFieldName = keyedByFieldName;
            this.keyedByFieldKey = keyedByFieldKey;
        }

        public Map getKeyedByFieldName() {
            return this.keyedByFieldName;
        }

        public Map getKeyedByFieldKey() {
            return this.keyedByFieldKey;
        }
    }
}

