/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.converters.reflection;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWritingException;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class SunLimitedUnsafeReflectionProvider
extends PureJavaReflectionProvider {
    protected static final Unsafe unsafe;
    protected static final Exception exception;

    public SunLimitedUnsafeReflectionProvider() {
    }

    public SunLimitedUnsafeReflectionProvider(FieldDictionary fieldDictionary) {
        super(fieldDictionary);
    }

    public Object newInstance(Class type) {
        if (exception != null) {
            ObjectAccessException ex2 = new ObjectAccessException("Cannot construct type", exception);
            ex2.add("construction-type", type.getName());
            throw ex2;
        }
        ErrorWritingException ex3 = null;
        try {
            return unsafe.allocateInstance(type);
        }
        catch (SecurityException e10) {
            ex3 = new ObjectAccessException("Cannot construct type", e10);
        }
        catch (InstantiationException e11) {
            ex3 = new ConversionException("Cannot construct type", e11);
        }
        catch (IllegalArgumentException e12) {
            ex3 = new ObjectAccessException("Cannot construct type", e12);
        }
        ex3.add("construction-type", type.getName());
        throw ex3;
    }

    protected void validateFieldAccess(Field field) {
    }

    private Object readResolve() {
        this.init();
        return this;
    }

    static {
        Unsafe u10 = null;
        Exception ex2 = null;
        try {
            Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            u10 = (Unsafe)unsafeField.get(null);
        }
        catch (SecurityException e10) {
            ex2 = e10;
        }
        catch (NoSuchFieldException e11) {
            ex2 = e11;
        }
        catch (IllegalArgumentException e12) {
            ex2 = e12;
        }
        catch (IllegalAccessException e13) {
            ex2 = e13;
        }
        exception = ex2;
        unsafe = u10;
    }
}

