/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core;

import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.DataHolder;
import com.thoughtworks.xstream.converters.ErrorReporter;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.core.MapBackedDataHolder;
import com.thoughtworks.xstream.core.util.FastStack;
import com.thoughtworks.xstream.core.util.HierarchicalStreams;
import com.thoughtworks.xstream.core.util.PrioritizedList;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.mapper.Mapper;
import java.util.Iterator;

public class TreeUnmarshaller
implements UnmarshallingContext {
    private Object root;
    protected HierarchicalStreamReader reader;
    private ConverterLookup converterLookup;
    private Mapper mapper;
    private FastStack types = new FastStack(16);
    private DataHolder dataHolder;
    private final PrioritizedList validationList = new PrioritizedList();

    public TreeUnmarshaller(Object root, HierarchicalStreamReader reader, ConverterLookup converterLookup, Mapper mapper) {
        this.root = root;
        this.reader = reader;
        this.converterLookup = converterLookup;
        this.mapper = mapper;
    }

    public Object convertAnother(Object parent, Class type) {
        return this.convertAnother(parent, type, null);
    }

    public Object convertAnother(Object parent, Class type, Converter converter) {
        type = this.mapper.defaultImplementationOf(type);
        if (converter == null) {
            converter = this.converterLookup.lookupConverterForType(type);
        } else if (!converter.canConvert(type)) {
            ConversionException e10 = new ConversionException("Explicit selected converter cannot handle type");
            e10.add("item-type", type.getName());
            e10.add("converter-type", converter.getClass().getName());
            throw e10;
        }
        return this.convert(parent, type, converter);
    }

    protected Object convert(Object parent, Class type, Converter converter) {
        try {
            this.types.push(type);
            Object result = converter.unmarshal(this.reader, this);
            this.types.popSilently();
            return result;
        }
        catch (ConversionException conversionException) {
            this.addInformationTo(conversionException, type, converter, parent);
            throw conversionException;
        }
        catch (RuntimeException e10) {
            ConversionException conversionException = new ConversionException(e10);
            this.addInformationTo(conversionException, type, converter, parent);
            throw conversionException;
        }
    }

    private void addInformationTo(ErrorWriter errorWriter, Class type, Converter converter, Object parent) {
        errorWriter.add("class", type.getName());
        errorWriter.add("required-type", this.getRequiredType().getName());
        errorWriter.add("converter-type", converter.getClass().getName());
        if (converter instanceof ErrorReporter) {
            ((ErrorReporter)((Object)converter)).appendErrors(errorWriter);
        }
        if (parent instanceof ErrorReporter) {
            ((ErrorReporter)parent).appendErrors(errorWriter);
        }
        this.reader.appendErrors(errorWriter);
    }

    public void addCompletionCallback(Runnable work, int priority) {
        this.validationList.add(work, priority);
    }

    public Object currentObject() {
        return this.types.size() == 1 ? this.root : null;
    }

    public Class getRequiredType() {
        return (Class)this.types.peek();
    }

    public Object get(Object key) {
        this.lazilyCreateDataHolder();
        return this.dataHolder.get(key);
    }

    public void put(Object key, Object value) {
        this.lazilyCreateDataHolder();
        this.dataHolder.put(key, value);
    }

    public Iterator keys() {
        this.lazilyCreateDataHolder();
        return this.dataHolder.keys();
    }

    private void lazilyCreateDataHolder() {
        if (this.dataHolder == null) {
            this.dataHolder = new MapBackedDataHolder();
        }
    }

    public Object start(DataHolder dataHolder) {
        this.dataHolder = dataHolder;
        Class type = HierarchicalStreams.readClassType(this.reader, this.mapper);
        Object result = this.convertAnother(null, type);
        Iterator validations = this.validationList.iterator();
        while (validations.hasNext()) {
            Runnable runnable = (Runnable)validations.next();
            runnable.run();
        }
        return result;
    }

    protected Mapper getMapper() {
        return this.mapper;
    }
}

