/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class Base64Encoder {
    private static final char[] SIXTY_FOUR_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();
    private static final int[] REVERSE_MAPPING = new int[123];

    public String encode(byte[] input) {
        StringBuffer result = new StringBuffer();
        int outputCharCount = 0;
        for (int i10 = 0; i10 < input.length; i10 += 3) {
            int remaining = Math.min(3, input.length - i10);
            int oneBigNumber = (input[i10] & 0xFF) << 16 | (remaining <= 1 ? 0 : input[i10 + 1] & 0xFF) << 8 | (remaining <= 2 ? 0 : input[i10 + 2] & 0xFF);
            for (int j10 = 0; j10 < 4; ++j10) {
                result.append(remaining + 1 > j10 ? SIXTY_FOUR_CHARS[0x3F & oneBigNumber >> 6 * (3 - j10)] : (char)'=');
            }
            if ((outputCharCount += 4) % 76 != 0) continue;
            result.append('\n');
        }
        return result.toString();
    }

    public byte[] decode(String input) {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StringReader in2 = new StringReader(input);
            for (int i10 = 0; i10 < input.length(); i10 += 4) {
                int[] a10 = new int[]{this.mapCharToInt(in2), this.mapCharToInt(in2), this.mapCharToInt(in2), this.mapCharToInt(in2)};
                int oneBigNumber = (a10[0] & 0x3F) << 18 | (a10[1] & 0x3F) << 12 | (a10[2] & 0x3F) << 6 | a10[3] & 0x3F;
                for (int j10 = 0; j10 < 3; ++j10) {
                    if (a10[j10 + 1] < 0) continue;
                    out.write(0xFF & oneBigNumber >> 8 * (2 - j10));
                }
            }
            return out.toByteArray();
        }
        catch (IOException e10) {
            throw new Error(e10 + ": " + e10.getMessage());
        }
    }

    private int mapCharToInt(Reader input) throws IOException {
        int c10;
        while ((c10 = input.read()) != -1) {
            int result = REVERSE_MAPPING[c10];
            if (result != 0) {
                return result - 1;
            }
            if (c10 != 61) continue;
            return -1;
        }
        return -1;
    }

    static {
        for (int i10 = 0; i10 < SIXTY_FOUR_CHARS.length; ++i10) {
            Base64Encoder.REVERSE_MAPPING[Base64Encoder.SIXTY_FOUR_CHARS[i10]] = i10 + 1;
        }
    }
}

