/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class Cloneables {
    public static Object clone(Object o10) {
        if (o10 instanceof Cloneable) {
            if (o10.getClass().isArray()) {
                Class<?> componentType = o10.getClass().getComponentType();
                if (!componentType.isPrimitive()) {
                    return ((Object[])o10).clone();
                }
                int length = Array.getLength(o10);
                Object clone = Array.newInstance(componentType, length);
                while (length-- > 0) {
                    Array.set(clone, length, Array.get(o10, length));
                }
                return clone;
            }
            try {
                Method clone = o10.getClass().getMethod("clone", null);
                return clone.invoke(o10, (Object[])null);
            }
            catch (NoSuchMethodException e10) {
                throw new ObjectAccessException("Cloneable type has no clone method", e10);
            }
            catch (IllegalAccessException e11) {
                throw new ObjectAccessException("Cannot clone Cloneable type", e11);
            }
            catch (InvocationTargetException e12) {
                throw new ObjectAccessException("Exception cloning Cloneable type", e12.getCause());
            }
        }
        return null;
    }

    public static Object cloneIfPossible(Object o10) {
        Object clone = Cloneables.clone(o10);
        return clone == null ? o10 : clone;
    }
}

