/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.core.util.Primitives;
import com.thoughtworks.xstream.core.util.TypedNull;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.List;

public class DependencyInjectionFactory {
    public static Object newInstance(Class type, Object[] dependencies) {
        return DependencyInjectionFactory.newInstance(type, dependencies, null);
    }

    public static Object newInstance(Class type, Object[] dependencies, BitSet usedDependencies) {
        if (dependencies != null && dependencies.length > 63) {
            throw new IllegalArgumentException("More than 63 arguments are not supported");
        }
        Constructor<?> bestMatchingCtor = null;
        ArrayList<Object> matchingDependencies = new ArrayList<Object>();
        List possibleMatchingDependencies = null;
        long usedDeps = 0L;
        long possibleUsedDeps = 0L;
        if (dependencies != null && dependencies.length > 0) {
            Constructor<?>[] ctors = type.getConstructors();
            if (ctors.length > 1) {
                Arrays.sort(ctors, new Comparator(){

                    public int compare(Object o12, Object o22) {
                        return ((Constructor)o22).getParameterTypes().length - ((Constructor)o12).getParameterTypes().length;
                    }
                });
            }
            TypedValue[] typedDependencies = new TypedValue[dependencies.length];
            for (int i10 = 0; i10 < dependencies.length; ++i10) {
                Object dependency = dependencies[i10];
                Class depType = dependency.getClass();
                if (depType.isPrimitive()) {
                    depType = Primitives.box(depType);
                } else if (depType == TypedNull.class) {
                    depType = ((TypedNull)dependency).getType();
                    dependency = null;
                }
                typedDependencies[i10] = new TypedValue(depType, dependency);
            }
            Constructor<?> possibleCtor = null;
            int arity = Integer.MAX_VALUE;
            for (int i11 = 0; bestMatchingCtor == null && i11 < ctors.length; ++i11) {
                int j10;
                Constructor<?> constructor = ctors[i11];
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length > dependencies.length) continue;
                if (parameterTypes.length == 0) {
                    if (possibleCtor != null) break;
                    bestMatchingCtor = constructor;
                    break;
                }
                if (arity > parameterTypes.length) {
                    if (possibleCtor != null) continue;
                    arity = parameterTypes.length;
                }
                for (j10 = 0; j10 < parameterTypes.length; ++j10) {
                    if (!parameterTypes[j10].isPrimitive()) continue;
                    parameterTypes[j10] = Primitives.box(parameterTypes[j10]);
                }
                matchingDependencies.clear();
                usedDeps = 0L;
                j10 = 0;
                int k10 = 0;
                while (j10 < parameterTypes.length && parameterTypes.length + k10 - j10 <= typedDependencies.length) {
                    if (parameterTypes[j10].isAssignableFrom(typedDependencies[k10].type)) {
                        matchingDependencies.add(typedDependencies[k10].value);
                        usedDeps |= 1L << k10;
                        if (++j10 == parameterTypes.length) {
                            bestMatchingCtor = constructor;
                            break;
                        }
                    }
                    ++k10;
                }
                if (bestMatchingCtor != null) continue;
                boolean possible = true;
                TypedValue[] deps = new TypedValue[typedDependencies.length];
                System.arraycopy(typedDependencies, 0, deps, 0, deps.length);
                matchingDependencies.clear();
                usedDeps = 0L;
                for (int j11 = 0; j11 < parameterTypes.length; ++j11) {
                    int assignable = -1;
                    for (int k11 = 0; k11 < deps.length; ++k11) {
                        if (deps[k11] == null) continue;
                        if (deps[k11].type == parameterTypes[j11]) {
                            assignable = k11;
                            break;
                        }
                        if (!parameterTypes[j11].isAssignableFrom(deps[k11].type) || assignable >= 0 && (deps[assignable].type == deps[k11].type || !deps[assignable].type.isAssignableFrom(deps[k11].type))) continue;
                        assignable = k11;
                    }
                    if (assignable >= 0) {
                        matchingDependencies.add(deps[assignable].value);
                        usedDeps |= 1L << assignable;
                    } else {
                        possible = false;
                        break;
                    }
                    deps[assignable] = null;
                }
                if (!possible || possibleCtor != null && usedDeps >= possibleUsedDeps) continue;
                possibleCtor = constructor;
                possibleMatchingDependencies = (List)matchingDependencies.clone();
                possibleUsedDeps = usedDeps;
            }
            if (bestMatchingCtor == null) {
                if (possibleCtor == null) {
                    usedDeps = 0L;
                    ObjectAccessException ex2 = new ObjectAccessException("Cannot construct type, none of the arguments match any constructor's parameters");
                    ex2.add("construction-type", type.getName());
                    throw ex2;
                }
                bestMatchingCtor = possibleCtor;
                matchingDependencies.clear();
                matchingDependencies.addAll(possibleMatchingDependencies);
                usedDeps = possibleUsedDeps;
            }
        }
        Throwable th2 = null;
        try {
            Object instance = bestMatchingCtor == null ? type.newInstance() : bestMatchingCtor.newInstance(matchingDependencies.toArray());
            if (usedDependencies != null) {
                usedDependencies.clear();
                int i12 = 0;
                long l10 = 1L;
                while (l10 < usedDeps) {
                    if ((usedDeps & l10) > 0L) {
                        usedDependencies.set(i12);
                    }
                    l10 <<= 1;
                    ++i12;
                }
            }
            return instance;
        }
        catch (InstantiationException e10) {
            th2 = e10;
        }
        catch (IllegalAccessException e11) {
            th2 = e11;
        }
        catch (InvocationTargetException e12) {
            th2 = e12.getCause();
        }
        catch (SecurityException e13) {
            th2 = e13;
        }
        catch (ExceptionInInitializerError e14) {
            th2 = e14;
        }
        ObjectAccessException ex3 = new ObjectAccessException("Cannot construct type", th2);
        ex3.add("construction-type", type.getName());
        throw ex3;
    }

    private static class TypedValue {
        final Class type;
        final Object value;

        public TypedValue(Class type, Object value) {
            this.type = type;
            this.value = value;
        }

        public String toString() {
            return this.type.getName() + ":" + this.value;
        }
    }
}

