/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.core.util;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class Fields {
    public static Field locate(Class definedIn, Class fieldType, boolean isStatic) {
        AccessibleObject field = null;
        try {
            Field[] fields = definedIn.getDeclaredFields();
            for (int i10 = 0; i10 < fields.length; ++i10) {
                if (Modifier.isStatic(fields[i10].getModifiers()) != isStatic || !fieldType.isAssignableFrom(fields[i10].getType())) continue;
                field = fields[i10];
            }
            if (field != null && !field.isAccessible()) {
                ((Field)field).setAccessible(true);
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        return field;
    }

    public static Field find(Class type, String name) {
        try {
            Field result = type.getDeclaredField(name);
            if (!result.isAccessible()) {
                result.setAccessible(true);
            }
            return result;
        }
        catch (SecurityException e10) {
            throw Fields.wrap("Cannot access field", type, name, e10);
        }
        catch (NoSuchFieldException e11) {
            throw Fields.wrap("Cannot access field", type, name, e11);
        }
        catch (NoClassDefFoundError e12) {
            throw Fields.wrap("Cannot access field", type, name, e12);
        }
    }

    public static void write(Field field, Object instance, Object value) {
        try {
            field.set(instance, value);
        }
        catch (SecurityException e10) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), e10);
        }
        catch (IllegalArgumentException e11) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), e11);
        }
        catch (IllegalAccessException e12) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), e12);
        }
        catch (NoClassDefFoundError e13) {
            throw Fields.wrap("Cannot write field", field.getType(), field.getName(), e13);
        }
    }

    public static Object read(Field field, Object instance) {
        try {
            return field.get(instance);
        }
        catch (SecurityException e10) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), e10);
        }
        catch (IllegalArgumentException e11) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), e11);
        }
        catch (IllegalAccessException e12) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), e12);
        }
        catch (NoClassDefFoundError e13) {
            throw Fields.wrap("Cannot read field", field.getType(), field.getName(), e13);
        }
    }

    private static ObjectAccessException wrap(String message, Class type, String name, Throwable ex2) {
        ObjectAccessException exception = new ObjectAccessException(message, ex2);
        exception.add("field", type.getName() + "." + name);
        return exception;
    }
}

