/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.path;

import com.thoughtworks.xstream.core.util.FastStack;
import java.util.ArrayList;

public class Path {
    private final String[] chunks;
    private transient String pathAsString;
    private transient String pathExplicit;
    private static final Path DOT = new Path(new String[]{"."});

    public Path(String pathAsString) {
        int nextSeparator;
        ArrayList<String> result = new ArrayList<String>();
        int currentIndex = 0;
        this.pathAsString = pathAsString;
        while ((nextSeparator = pathAsString.indexOf(47, currentIndex)) != -1) {
            result.add(this.normalize(pathAsString, currentIndex, nextSeparator));
            currentIndex = nextSeparator + 1;
        }
        result.add(this.normalize(pathAsString, currentIndex, pathAsString.length()));
        String[] arr = new String[result.size()];
        result.toArray(arr);
        this.chunks = arr;
    }

    private String normalize(String s10, int start, int end) {
        if (end - start > 3 && s10.charAt(end - 3) == '[' && s10.charAt(end - 2) == '1' && s10.charAt(end - 1) == ']') {
            this.pathAsString = null;
            return s10.substring(start, end - 3);
        }
        return s10.substring(start, end);
    }

    public Path(String[] chunks) {
        this.chunks = chunks;
    }

    public String toString() {
        if (this.pathAsString == null) {
            StringBuffer buffer = new StringBuffer();
            for (int i10 = 0; i10 < this.chunks.length; ++i10) {
                if (i10 > 0) {
                    buffer.append('/');
                }
                buffer.append(this.chunks[i10]);
            }
            this.pathAsString = buffer.toString();
        }
        return this.pathAsString;
    }

    public String explicit() {
        if (this.pathExplicit == null) {
            StringBuffer buffer = new StringBuffer();
            for (int i10 = 0; i10 < this.chunks.length; ++i10) {
                char c10;
                if (i10 > 0) {
                    buffer.append('/');
                }
                String chunk = this.chunks[i10];
                buffer.append(chunk);
                int length = chunk.length();
                if (length <= 0 || (c10 = chunk.charAt(length - 1)) == ']' || c10 == '.') continue;
                buffer.append("[1]");
            }
            this.pathExplicit = buffer.toString();
        }
        return this.pathExplicit;
    }

    public boolean equals(Object o10) {
        if (this == o10) {
            return true;
        }
        if (!(o10 instanceof Path)) {
            return false;
        }
        Path other = (Path)o10;
        if (this.chunks.length != other.chunks.length) {
            return false;
        }
        for (int i10 = 0; i10 < this.chunks.length; ++i10) {
            if (this.chunks[i10].equals(other.chunks[i10])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = 543645643;
        for (int i10 = 0; i10 < this.chunks.length; ++i10) {
            result = 29 * result + this.chunks[i10].hashCode();
        }
        return result;
    }

    public Path relativeTo(Path that) {
        int depthOfPathDivergence = this.depthOfPathDivergence(this.chunks, that.chunks);
        String[] result = new String[this.chunks.length + that.chunks.length - 2 * depthOfPathDivergence];
        int count = 0;
        for (int i10 = depthOfPathDivergence; i10 < this.chunks.length; ++i10) {
            result[count++] = "..";
        }
        for (int j10 = depthOfPathDivergence; j10 < that.chunks.length; ++j10) {
            result[count++] = that.chunks[j10];
        }
        if (count == 0) {
            return DOT;
        }
        return new Path(result);
    }

    private int depthOfPathDivergence(String[] path1, String[] path2) {
        int minLength = Math.min(path1.length, path2.length);
        for (int i10 = 0; i10 < minLength; ++i10) {
            if (path1[i10].equals(path2[i10])) continue;
            return i10;
        }
        return minLength;
    }

    public Path apply(Path relativePath) {
        int i10;
        FastStack absoluteStack = new FastStack(16);
        for (i10 = 0; i10 < this.chunks.length; ++i10) {
            absoluteStack.push(this.chunks[i10]);
        }
        for (i10 = 0; i10 < relativePath.chunks.length; ++i10) {
            String relativeChunk = relativePath.chunks[i10];
            if (relativeChunk.equals("..")) {
                absoluteStack.pop();
                continue;
            }
            if (relativeChunk.equals(".")) continue;
            absoluteStack.push(relativeChunk);
        }
        String[] result = new String[absoluteStack.size()];
        for (int i11 = 0; i11 < result.length; ++i11) {
            result[i11] = (String)absoluteStack.get(i11);
        }
        return new Path(result);
    }

    public boolean isAncestor(Path child) {
        if (child == null || child.chunks.length < this.chunks.length) {
            return false;
        }
        for (int i10 = 0; i10 < this.chunks.length; ++i10) {
            if (this.chunks[i10].equals(child.chunks[i10])) continue;
            return false;
        }
        return true;
    }
}

