/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.core.util.XmlHeaderAwareReader;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.StreamException;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.xml.AbstractXmlDriver;
import com.thoughtworks.xstream.io.xml.PrettyPrintWriter;
import com.thoughtworks.xstream.io.xml.XppDomReader;
import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class AbstractXppDomDriver
extends AbstractXmlDriver {
    public AbstractXppDomDriver(NameCoder nameCoder) {
        super(nameCoder);
    }

    public HierarchicalStreamReader createReader(Reader in2) {
        try {
            XmlPullParser parser = this.createParser();
            parser.setInput(in2);
            return new XppDomReader(XppDom.build(parser), this.getNameCoder());
        }
        catch (XmlPullParserException e10) {
            throw new StreamException(e10);
        }
        catch (IOException e11) {
            throw new StreamException(e11);
        }
    }

    public HierarchicalStreamReader createReader(InputStream in2) {
        try {
            return this.createReader(new XmlHeaderAwareReader(in2));
        }
        catch (UnsupportedEncodingException e10) {
            throw new StreamException(e10);
        }
        catch (IOException e11) {
            throw new StreamException(e11);
        }
    }

    public HierarchicalStreamWriter createWriter(Writer out) {
        return new PrettyPrintWriter(out, this.getNameCoder());
    }

    public HierarchicalStreamWriter createWriter(OutputStream out) {
        return this.createWriter(new OutputStreamWriter(out));
    }

    protected abstract XmlPullParser createParser() throws XmlPullParserException;
}

