/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml;

import com.thoughtworks.xstream.converters.reflection.ObjectAccessException;
import com.thoughtworks.xstream.io.naming.NameCoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class XmlFriendlyNameCoder
implements NameCoder,
Cloneable {
    private static final IntPair[] XML_NAME_START_CHAR_BOUNDS;
    private static final IntPair[] XML_NAME_CHAR_EXTRA_BOUNDS;
    private final String dollarReplacement;
    private final String escapeCharReplacement;
    private transient Map escapeCache;
    private transient Map unescapeCache;
    private final String hexPrefix;

    public XmlFriendlyNameCoder() {
        this("_-", "__");
    }

    public XmlFriendlyNameCoder(String dollarReplacement, String escapeCharReplacement) {
        this(dollarReplacement, escapeCharReplacement, "_.");
    }

    public XmlFriendlyNameCoder(String dollarReplacement, String escapeCharReplacement, String hexPrefix) {
        this.dollarReplacement = dollarReplacement;
        this.escapeCharReplacement = escapeCharReplacement;
        this.hexPrefix = hexPrefix;
        this.readResolve();
    }

    public String decodeAttribute(String attributeName) {
        return this.decodeName(attributeName);
    }

    public String decodeNode(String elementName) {
        return this.decodeName(elementName);
    }

    public String encodeAttribute(String name) {
        return this.encodeName(name);
    }

    public String encodeNode(String name) {
        return this.encodeName(name);
    }

    private String encodeName(String name) {
        String s10 = (String)this.escapeCache.get(name);
        if (s10 == null) {
            char c10;
            int i10;
            int length = name.length();
            for (i10 = 0; i10 < length && (c10 = name.charAt(i10)) != '$' && c10 != '_' && c10 > '\u001b' && c10 < '\u007f'; ++i10) {
            }
            if (i10 == length) {
                return name;
            }
            StringBuffer result = new StringBuffer(length + 8);
            if (i10 > 0) {
                result.append(name.substring(0, i10));
            }
            while (i10 < length) {
                char c11 = name.charAt(i10);
                if (c11 == '$') {
                    result.append(this.dollarReplacement);
                } else if (c11 == '_') {
                    result.append(this.escapeCharReplacement);
                } else if (i10 == 0 && !XmlFriendlyNameCoder.isXmlNameStartChar(c11) || i10 > 0 && !XmlFriendlyNameCoder.isXmlNameChar(c11)) {
                    result.append(this.hexPrefix);
                    if (c11 < '\u0010') {
                        result.append("000");
                    } else if (c11 < '\u0100') {
                        result.append("00");
                    } else if (c11 < '\u1000') {
                        result.append("0");
                    }
                    result.append(Integer.toHexString(c11));
                } else {
                    result.append(c11);
                }
                ++i10;
            }
            s10 = result.toString();
            this.escapeCache.put(name, s10);
        }
        return s10;
    }

    private String decodeName(String name) {
        String s10 = (String)this.unescapeCache.get(name);
        if (s10 == null) {
            char c10;
            int i10;
            char dollarReplacementFirstChar = this.dollarReplacement.charAt(0);
            char escapeReplacementFirstChar = this.escapeCharReplacement.charAt(0);
            char hexPrefixFirstChar = this.hexPrefix.charAt(0);
            int length = name.length();
            for (i10 = 0; i10 < length && (c10 = name.charAt(i10)) != dollarReplacementFirstChar && c10 != escapeReplacementFirstChar && c10 != hexPrefixFirstChar; ++i10) {
            }
            if (i10 == length) {
                return name;
            }
            StringBuffer result = new StringBuffer(length + 8);
            if (i10 > 0) {
                result.append(name.substring(0, i10));
            }
            while (i10 < length) {
                char c11 = name.charAt(i10);
                if (c11 == dollarReplacementFirstChar && name.startsWith(this.dollarReplacement, i10)) {
                    i10 += this.dollarReplacement.length() - 1;
                    result.append('$');
                } else if (c11 == hexPrefixFirstChar && name.startsWith(this.hexPrefix, i10)) {
                    c11 = (char)Integer.parseInt(name.substring(i10 += this.hexPrefix.length(), i10 + 4), 16);
                    i10 += 3;
                    result.append(c11);
                } else if (c11 == escapeReplacementFirstChar && name.startsWith(this.escapeCharReplacement, i10)) {
                    i10 += this.escapeCharReplacement.length() - 1;
                    result.append('_');
                } else {
                    result.append(c11);
                }
                ++i10;
            }
            s10 = result.toString();
            this.unescapeCache.put(name, s10);
        }
        return s10;
    }

    public Object clone() {
        try {
            XmlFriendlyNameCoder coder = (XmlFriendlyNameCoder)super.clone();
            coder.readResolve();
            return coder;
        }
        catch (CloneNotSupportedException e10) {
            throw new ObjectAccessException("Cannot clone XmlFriendlyNameCoder", e10);
        }
    }

    private Object readResolve() {
        this.escapeCache = this.createCacheMap();
        this.unescapeCache = this.createCacheMap();
        return this;
    }

    protected Map createCacheMap() {
        return new HashMap();
    }

    private static boolean isXmlNameStartChar(int cp2) {
        return XmlFriendlyNameCoder.isInNameCharBounds(cp2, XML_NAME_START_CHAR_BOUNDS);
    }

    private static boolean isXmlNameChar(int cp2) {
        if (XmlFriendlyNameCoder.isXmlNameStartChar(cp2)) {
            return true;
        }
        return XmlFriendlyNameCoder.isInNameCharBounds(cp2, XML_NAME_CHAR_EXTRA_BOUNDS);
    }

    private static boolean isInNameCharBounds(int cp2, IntPair[] nameCharBounds) {
        for (int i10 = 0; i10 < nameCharBounds.length; ++i10) {
            IntPair p10 = nameCharBounds[i10];
            if (cp2 < p10.min || cp2 > p10.max) continue;
            return true;
        }
        return false;
    }

    static {
        class IntPairList
        extends ArrayList {
            IntPairList() {
            }

            void add(int min, int max) {
                super.add(new IntPair(min, max));
            }

            void add(char cp2) {
                super.add(new IntPair(cp2, cp2));
            }
        }
        IntPairList list = new IntPairList();
        list.add(':');
        list.add(65, 90);
        list.add(97, 122);
        list.add('_');
        list.add(192, 214);
        list.add(216, 246);
        list.add(248, 767);
        list.add(880, 893);
        list.add(895, 8191);
        list.add(8204, 8205);
        list.add(8304, 8591);
        list.add(11264, 12271);
        list.add(12289, 55295);
        list.add(63744, 64975);
        list.add(65008, 65533);
        list.add(65536, 983039);
        XML_NAME_START_CHAR_BOUNDS = list.toArray(new IntPair[list.size()]);
        list.clear();
        list.add('-');
        list.add('.');
        list.add(48, 57);
        list.add('\u00b7');
        list.add(768, 879);
        list.add(8255, 8256);
        XML_NAME_CHAR_EXTRA_BOUNDS = list.toArray(new IntPair[list.size()]);
    }

    private static class IntPair {
        int min;
        int max;

        public IntPair(int min, int max) {
            this.min = min;
            this.max = max;
        }
    }
}

