/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.io.xml.xppdom;

import com.thoughtworks.xstream.io.xml.xppdom.XppDom;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;

public class XppDomComparator
implements Comparator {
    private final ThreadLocal xpath;

    public XppDomComparator() {
        this(null);
    }

    public XppDomComparator(ThreadLocal xpath) {
        this.xpath = xpath;
    }

    public int compare(Object dom1, Object dom2) {
        StringBuffer xpath = new StringBuffer("/");
        int s10 = this.compareInternal((XppDom)dom1, (XppDom)dom2, xpath, -1);
        if (this.xpath != null) {
            if (s10 != 0) {
                this.xpath.set(xpath.toString());
            } else {
                this.xpath.set(null);
            }
        }
        return s10;
    }

    private int compareInternal(XppDom dom1, XppDom dom2, StringBuffer xpath, int count) {
        int len;
        int pathlen = xpath.length();
        String name = dom1.getName();
        int s10 = name.compareTo(dom2.getName());
        xpath.append(name);
        if (count >= 0) {
            xpath.append('[').append(count).append(']');
        }
        if (s10 != 0) {
            xpath.append('?');
            return s10;
        }
        Object[] attributes = dom1.getAttributeNames();
        Object[] attributes2 = dom2.getAttributeNames();
        s10 = attributes2.length - (len = attributes.length);
        if (s10 != 0) {
            xpath.append("::count(@*)");
            return s10 < 0 ? 1 : -1;
        }
        Arrays.sort(attributes);
        Arrays.sort(attributes2);
        for (int i10 = 0; i10 < len; ++i10) {
            Object attribute = attributes[i10];
            s10 = ((String)attribute).compareTo((String)attributes2[i10]);
            if (s10 != 0) {
                xpath.append("[@").append((String)attribute).append("?]");
                return s10;
            }
            s10 = dom1.getAttribute((String)attribute).compareTo(dom2.getAttribute((String)attribute));
            if (s10 == 0) continue;
            xpath.append("[@").append((String)attribute).append(']');
            return s10;
        }
        int children = dom1.getChildCount();
        s10 = dom2.getChildCount() - children;
        if (s10 != 0) {
            xpath.append("::count(*)");
            return s10 < 0 ? 1 : -1;
        }
        if (children > 0) {
            if (dom1.getValue() != null || dom2.getValue() != null) {
                throw new IllegalArgumentException("XppDom cannot handle mixed mode at " + xpath + "::text()");
            }
            xpath.append('/');
            HashMap<String, int[]> names = new HashMap<String, int[]>();
            for (int i11 = 0; i11 < children; ++i11) {
                XppDom child1 = dom1.getChild(i11);
                XppDom child2 = dom2.getChild(i11);
                String child = child1.getName();
                if (!names.containsKey(child)) {
                    names.put(child, new int[1]);
                }
                int[] nArray = (int[])names.get(child);
                int n10 = nArray[0];
                nArray[0] = n10 + 1;
                s10 = this.compareInternal(child1, child2, xpath, n10);
                if (s10 == 0) continue;
                return s10;
            }
        } else {
            String value2 = dom2.getValue();
            String value1 = dom1.getValue();
            if (value1 == null) {
                s10 = value2 == null ? 0 : -1;
            } else {
                int n11 = s10 = value2 == null ? 1 : value1.compareTo(value2);
            }
            if (s10 != 0) {
                xpath.append("::text()");
                return s10;
            }
        }
        xpath.setLength(pathlen);
        return s10;
    }
}

