/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.mapper;

import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.core.Caching;
import com.thoughtworks.xstream.mapper.CannotResolveClassException;
import com.thoughtworks.xstream.mapper.Mapper;
import com.thoughtworks.xstream.mapper.MapperWrapper;
import com.thoughtworks.xstream.security.ForbiddenClassException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class CachingMapper
extends MapperWrapper
implements Caching {
    private transient Map realClassCache;

    public CachingMapper(Mapper wrapped) {
        super(wrapped);
        this.readResolve();
    }

    public Class realClass(String elementName) {
        Object cached = this.realClassCache.get(elementName);
        if (cached != null) {
            if (cached instanceof Class) {
                return (Class)cached;
            }
            throw (XStreamException)cached;
        }
        try {
            Class result = super.realClass(elementName);
            this.realClassCache.put(elementName, result);
            return result;
        }
        catch (ForbiddenClassException e10) {
            this.realClassCache.put(elementName, e10);
            throw e10;
        }
        catch (CannotResolveClassException e11) {
            this.realClassCache.put(elementName, e11);
            throw e11;
        }
    }

    public void flushCache() {
        this.realClassCache.clear();
    }

    private Object readResolve() {
        this.realClassCache = Collections.synchronizedMap(new HashMap(128));
        return this;
    }
}

