/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.persistence;

import com.thoughtworks.xstream.persistence.PersistenceStrategy;
import com.thoughtworks.xstream.persistence.XmlMap;
import java.util.AbstractList;

public class XmlArrayList
extends AbstractList {
    private final XmlMap map;

    public XmlArrayList(PersistenceStrategy persistenceStrategy) {
        this.map = new XmlMap(persistenceStrategy);
    }

    public int size() {
        return this.map.size();
    }

    public Object set(int index, Object element) {
        this.rangeCheck(index);
        Object value = this.get(index);
        this.map.put(new Integer(index), element);
        return value;
    }

    public void add(int index, Object element) {
        int size = this.size();
        if (index >= size + 1 || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
        int to2 = index != size ? index - 1 : index;
        for (int i10 = size; i10 > to2; --i10) {
            this.map.put(new Integer(i10 + 1), this.map.get(new Integer(i10)));
        }
        this.map.put(new Integer(index), element);
    }

    private void rangeCheck(int index) {
        int size = this.size();
        if (index >= size || index < 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + size);
        }
    }

    public Object get(int index) {
        this.rangeCheck(index);
        return this.map.get(new Integer(index));
    }

    public Object remove(int index) {
        int size = this.size();
        this.rangeCheck(index);
        Object value = this.map.get(new Integer(index));
        for (int i10 = index; i10 < size - 1; ++i10) {
            this.map.put(new Integer(i10), this.map.get(new Integer(i10 + 1)));
        }
        this.map.remove(new Integer(size - 1));
        return value;
    }
}

