/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.xstream.security;

import com.thoughtworks.xstream.security.RegExpTypePermission;

public class WildcardTypePermission
extends RegExpTypePermission {
    public WildcardTypePermission(String[] patterns) {
        super(WildcardTypePermission.getRegExpPatterns(patterns));
    }

    private static String[] getRegExpPatterns(String[] wildcards) {
        if (wildcards == null) {
            return null;
        }
        String[] regexps = new String[wildcards.length];
        for (int i10 = 0; i10 < wildcards.length; ++i10) {
            String wildcardExpression = wildcards[i10];
            StringBuffer result = new StringBuffer(wildcardExpression.length() * 2);
            result.append("(?u)");
            int length = wildcardExpression.length();
            block6: for (int j10 = 0; j10 < length; ++j10) {
                char ch2 = wildcardExpression.charAt(j10);
                switch (ch2) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case '\\': 
                    case ']': 
                    case '^': 
                    case '|': {
                        result.append('\\').append(ch2);
                        continue block6;
                    }
                    case '?': {
                        result.append('.');
                        continue block6;
                    }
                    case '*': {
                        if (j10 + 1 < length && wildcardExpression.charAt(j10 + 1) == '*') {
                            result.append("[\\P{C}]*");
                            ++j10;
                            continue block6;
                        }
                        result.append("[\\P{C}&&[^").append('.').append("]]*");
                        continue block6;
                    }
                    default: {
                        result.append(ch2);
                    }
                }
            }
            regexps[i10] = result.toString();
        }
        return regexps;
    }
}

