/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;

public class iM<E extends JComponent>
extends iB<E> {
    protected int width = i8.width;
    protected int round = i8.round;
    protected Color color = i8.color;
    protected Stroke stroke = null;

    public iM() {
        this.updateStroke();
    }

    public iM(int n10) {
        this.width = n10;
    }

    public iM(Color color) {
        this.color = color;
        this.updateStroke();
    }

    public iM(int n10, Color color) {
        this.width = n10;
        this.color = color;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n10) {
        this.width = n10;
        this.updateStroke();
        this.updateAll();
    }

    public int getRound() {
        return this.round;
    }

    public void setRound(int n10) {
        this.round = n10;
        this.updateStroke();
        this.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.repaint();
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.repaint();
    }

    protected void updateStroke() {
        this.stroke = new BasicStroke(this.getWidth(), 1, 1);
    }

    @Override
    public Dimension getPreferredSize(E e10) {
        return new Dimension(Math.max(this.width * 2, this.round * 2), Math.max(this.width * 2, this.round * 2));
    }

    @Override
    public Insets getMargin(E e10) {
        Insets insets = super.getMargin(e10);
        return new Insets(insets.top + this.width, insets.left + this.width, insets.bottom + this.width, insets.right + this.width);
    }

    @Override
    public void paint(Graphics2D graphics2D, Rectangle rectangle, E e10) {
        if (this.width > 0 && this.stroke != null && this.color != null) {
            Object object = rB.setupAntialias(graphics2D);
            Stroke stroke = rB.setupStroke(graphics2D, this.stroke, this.stroke != null);
            graphics2D.setPaint(this.color);
            graphics2D.draw(this.getBorderShape(rectangle));
            rB.restoreStroke(graphics2D, stroke, this.stroke != null);
            rB.restoreAntialias(graphics2D, object);
        }
    }

    protected RectangularShape getBorderShape(Rectangle rectangle) {
        double d10;
        double d11 = d10 = this.width == 1 ? 0.0 : (double)this.width / 2.0;
        if (this.round > 0) {
            return new RoundRectangle2D.Double((double)rectangle.x + d10, (double)rectangle.y + d10, (double)rectangle.width - d10 * 2.0 - 1.0, (double)rectangle.height - d10 * 2.0 - 1.0, this.round * 2, this.round * 2);
        }
        return new Rectangle2D.Double((double)rectangle.x + d10, (double)rectangle.y + d10, (double)rectangle.width - d10 * 2.0 - 1.0, (double)rectangle.height - d10 * 2.0 - 1.0);
    }
}

