/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import com.sun.activation.registries.LogSupport;
import com.sun.activation.registries.MailcapFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.CommandInfo;
import javax.activation.CommandMap;
import javax.activation.DataContentHandler;
import javax.activation.SecuritySupport;

public class MailcapCommandMap
extends CommandMap {
    private static MailcapFile defDB = null;
    private MailcapFile[] DB;
    private static final int PROG = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MailcapCommandMap() {
        ArrayList<MailcapFile> dbv = new ArrayList<MailcapFile>(5);
        MailcapFile mf2 = null;
        dbv.add(null);
        LogSupport.log("MailcapCommandMap: load HOME");
        try {
            String path;
            String user_home = System.getProperty("user.home");
            if (user_home != null && (mf2 = this.loadFile(path = user_home + File.separator + ".mailcap")) != null) {
                dbv.add(mf2);
            }
        }
        catch (SecurityException ex2) {
            // empty catch block
        }
        LogSupport.log("MailcapCommandMap: load SYS");
        try {
            String system_mailcap = System.getProperty("java.home") + File.separator + "lib" + File.separator + "mailcap";
            mf2 = this.loadFile(system_mailcap);
            if (mf2 != null) {
                dbv.add(mf2);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        LogSupport.log("MailcapCommandMap: load JAR");
        this.loadAllResources(dbv, "META-INF/mailcap");
        LogSupport.log("MailcapCommandMap: load DEF");
        Class<MailcapCommandMap> clazz = MailcapCommandMap.class;
        synchronized (MailcapCommandMap.class) {
            if (defDB == null) {
                defDB = this.loadResource("/META-INF/mailcap.default");
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (defDB != null) {
                dbv.add(defDB);
            }
            this.DB = new MailcapFile[dbv.size()];
            this.DB = dbv.toArray(this.DB);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MailcapFile loadResource(String name) {
        InputStream clis = null;
        try {
            clis = SecuritySupport.getResourceAsStream(this.getClass(), name);
            if (clis != null) {
                MailcapFile mf2 = new MailcapFile(clis);
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MailcapCommandMap: successfully loaded mailcap file: " + name);
                }
                MailcapFile mailcapFile = mf2;
                return mailcapFile;
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: not loading mailcap file: " + name);
            }
        }
        catch (IOException e10) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: can't load " + name, e10);
            }
        }
        catch (SecurityException sex) {
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: can't load " + name, sex);
            }
        }
        finally {
            try {
                if (clis != null) {
                    clis.close();
                }
            }
            catch (IOException ex2) {}
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadAllResources(List v10, String name) {
        boolean anyLoaded;
        block26: {
            anyLoaded = false;
            try {
                URL[] urls;
                ClassLoader cld = null;
                cld = SecuritySupport.getContextClassLoader();
                if (cld == null) {
                    cld = this.getClass().getClassLoader();
                }
                if ((urls = cld != null ? SecuritySupport.getResources(cld, name) : SecuritySupport.getSystemResources(name)) == null) break block26;
                if (LogSupport.isLoggable()) {
                    LogSupport.log("MailcapCommandMap: getResources");
                }
                for (int i10 = 0; i10 < urls.length; ++i10) {
                    URL url = urls[i10];
                    InputStream clis = null;
                    if (LogSupport.isLoggable()) {
                        LogSupport.log("MailcapCommandMap: URL " + url);
                    }
                    try {
                        clis = SecuritySupport.openStream(url);
                        if (clis != null) {
                            v10.add(new MailcapFile(clis));
                            anyLoaded = true;
                            if (!LogSupport.isLoggable()) continue;
                            LogSupport.log("MailcapCommandMap: successfully loaded mailcap file from URL: " + url);
                            continue;
                        }
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MailcapCommandMap: not loading mailcap file from URL: " + url);
                        continue;
                    }
                    catch (IOException ioex) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MailcapCommandMap: can't load " + url, ioex);
                        continue;
                    }
                    catch (SecurityException sex) {
                        if (!LogSupport.isLoggable()) continue;
                        LogSupport.log("MailcapCommandMap: can't load " + url, sex);
                        continue;
                    }
                    finally {
                        try {
                            if (clis != null) {
                                clis.close();
                            }
                        }
                        catch (IOException cex) {}
                    }
                }
            }
            catch (Exception ex2) {
                if (!LogSupport.isLoggable()) break block26;
                LogSupport.log("MailcapCommandMap: can't load " + name, ex2);
            }
        }
        if (!anyLoaded) {
            MailcapFile mf2;
            if (LogSupport.isLoggable()) {
                LogSupport.log("MailcapCommandMap: !anyLoaded");
            }
            if ((mf2 = this.loadResource("/" + name)) != null) {
                v10.add(mf2);
            }
        }
    }

    private MailcapFile loadFile(String name) {
        MailcapFile mtf = null;
        try {
            mtf = new MailcapFile(name);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return mtf;
    }

    public MailcapCommandMap(String fileName) throws IOException {
        this();
        if (LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: load PROG from " + fileName);
        }
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile(fileName);
        }
    }

    public MailcapCommandMap(InputStream is2) {
        this();
        LogSupport.log("MailcapCommandMap: load PROG");
        if (this.DB[0] == null) {
            try {
                this.DB[0] = new MailcapFile(is2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized CommandInfo[] getPreferredCommands(String mimeType) {
        Map cmdMap;
        int i10;
        ArrayList cmdList = new ArrayList();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase();
        }
        for (i10 = 0; i10 < this.DB.length; ++i10) {
            if (this.DB[i10] == null || (cmdMap = this.DB[i10].getMailcapList(mimeType)) == null) continue;
            this.appendPrefCmdsToList(cmdMap, cmdList);
        }
        for (i10 = 0; i10 < this.DB.length; ++i10) {
            if (this.DB[i10] == null || (cmdMap = this.DB[i10].getMailcapFallbackList(mimeType)) == null) continue;
            this.appendPrefCmdsToList(cmdMap, cmdList);
        }
        CommandInfo[] cmdInfos = new CommandInfo[cmdList.size()];
        cmdInfos = cmdList.toArray(cmdInfos);
        return cmdInfos;
    }

    private void appendPrefCmdsToList(Map cmdHash, List cmdList) {
        for (String verb : cmdHash.keySet()) {
            if (this.checkForVerb(cmdList, verb)) continue;
            List cmdList2 = (List)cmdHash.get(verb);
            String className = (String)cmdList2.get(0);
            cmdList.add(new CommandInfo(verb, className));
        }
    }

    private boolean checkForVerb(List cmdList, String verb) {
        Iterator ee2 = cmdList.iterator();
        while (ee2.hasNext()) {
            String enum_verb = ((CommandInfo)ee2.next()).getCommandName();
            if (!enum_verb.equals(verb)) continue;
            return true;
        }
        return false;
    }

    public synchronized CommandInfo[] getAllCommands(String mimeType) {
        Map cmdMap;
        int i10;
        ArrayList cmdList = new ArrayList();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase();
        }
        for (i10 = 0; i10 < this.DB.length; ++i10) {
            if (this.DB[i10] == null || (cmdMap = this.DB[i10].getMailcapList(mimeType)) == null) continue;
            this.appendCmdsToList(cmdMap, cmdList);
        }
        for (i10 = 0; i10 < this.DB.length; ++i10) {
            if (this.DB[i10] == null || (cmdMap = this.DB[i10].getMailcapFallbackList(mimeType)) == null) continue;
            this.appendCmdsToList(cmdMap, cmdList);
        }
        CommandInfo[] cmdInfos = new CommandInfo[cmdList.size()];
        cmdInfos = cmdList.toArray(cmdInfos);
        return cmdInfos;
    }

    private void appendCmdsToList(Map typeHash, List cmdList) {
        for (String verb : typeHash.keySet()) {
            List cmdList2 = (List)typeHash.get(verb);
            for (String cmd : cmdList2) {
                cmdList.add(new CommandInfo(verb, cmd));
            }
        }
    }

    public synchronized CommandInfo getCommand(String mimeType, String cmdName) {
        String cmdClassName;
        List v10;
        Map cmdMap;
        int i10;
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase();
        }
        for (i10 = 0; i10 < this.DB.length; ++i10) {
            if (this.DB[i10] == null || (cmdMap = this.DB[i10].getMailcapList(mimeType)) == null || (v10 = (List)cmdMap.get(cmdName)) == null || (cmdClassName = (String)v10.get(0)) == null) continue;
            return new CommandInfo(cmdName, cmdClassName);
        }
        for (i10 = 0; i10 < this.DB.length; ++i10) {
            if (this.DB[i10] == null || (cmdMap = this.DB[i10].getMailcapFallbackList(mimeType)) == null || (v10 = (List)cmdMap.get(cmdName)) == null || (cmdClassName = (String)v10.get(0)) == null) continue;
            return new CommandInfo(cmdName, cmdClassName);
        }
        return null;
    }

    public synchronized void addMailcap(String mail_cap) {
        LogSupport.log("MailcapCommandMap: add to PROG");
        if (this.DB[0] == null) {
            this.DB[0] = new MailcapFile();
        }
        this.DB[0].appendToMailcap(mail_cap);
    }

    public synchronized DataContentHandler createDataContentHandler(String mimeType) {
        String name;
        DataContentHandler dch;
        List v10;
        Map cmdMap;
        int i10;
        if (LogSupport.isLoggable()) {
            LogSupport.log("MailcapCommandMap: createDataContentHandler for " + mimeType);
        }
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase();
        }
        for (i10 = 0; i10 < this.DB.length; ++i10) {
            if (this.DB[i10] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("  search DB #" + i10);
            }
            if ((cmdMap = this.DB[i10].getMailcapList(mimeType)) == null || (v10 = (List)cmdMap.get("content-handler")) == null || (dch = this.getDataContentHandler(name = (String)v10.get(0))) == null) continue;
            return dch;
        }
        for (i10 = 0; i10 < this.DB.length; ++i10) {
            if (this.DB[i10] == null) continue;
            if (LogSupport.isLoggable()) {
                LogSupport.log("  search fallback DB #" + i10);
            }
            if ((cmdMap = this.DB[i10].getMailcapFallbackList(mimeType)) == null || (v10 = (List)cmdMap.get("content-handler")) == null || (dch = this.getDataContentHandler(name = (String)v10.get(0))) == null) continue;
            return dch;
        }
        return null;
    }

    private DataContentHandler getDataContentHandler(String name) {
        block12: {
            if (LogSupport.isLoggable()) {
                LogSupport.log("    got content-handler");
            }
            if (LogSupport.isLoggable()) {
                LogSupport.log("      class " + name);
            }
            try {
                ClassLoader cld = null;
                cld = SecuritySupport.getContextClassLoader();
                if (cld == null) {
                    cld = this.getClass().getClassLoader();
                }
                Class<?> cl2 = null;
                try {
                    cl2 = cld.loadClass(name);
                }
                catch (Exception ex2) {
                    cl2 = Class.forName(name);
                }
                if (cl2 != null) {
                    return (DataContentHandler)cl2.newInstance();
                }
            }
            catch (IllegalAccessException e10) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log("Can't load DCH " + name, e10);
                }
            }
            catch (ClassNotFoundException e11) {
                if (LogSupport.isLoggable()) {
                    LogSupport.log("Can't load DCH " + name, e11);
                }
            }
            catch (InstantiationException e12) {
                if (!LogSupport.isLoggable()) break block12;
                LogSupport.log("Can't load DCH " + name, e12);
            }
        }
        return null;
    }

    public synchronized String[] getMimeTypes() {
        ArrayList<String> mtList = new ArrayList<String>();
        for (int i10 = 0; i10 < this.DB.length; ++i10) {
            String[] ts2;
            if (this.DB[i10] == null || (ts2 = this.DB[i10].getMimeTypes()) == null) continue;
            for (int j10 = 0; j10 < ts2.length; ++j10) {
                if (mtList.contains(ts2[j10])) continue;
                mtList.add(ts2[j10]);
            }
        }
        String[] mts = new String[mtList.size()];
        mts = mtList.toArray(mts);
        return mts;
    }

    public synchronized String[] getNativeCommands(String mimeType) {
        ArrayList<String> cmdList = new ArrayList<String>();
        if (mimeType != null) {
            mimeType = mimeType.toLowerCase();
        }
        for (int i10 = 0; i10 < this.DB.length; ++i10) {
            String[] cmds;
            if (this.DB[i10] == null || (cmds = this.DB[i10].getNativeCommands(mimeType)) == null) continue;
            for (int j10 = 0; j10 < cmds.length; ++j10) {
                if (cmdList.contains(cmds[j10])) continue;
                cmdList.add(cmds[j10]);
            }
        }
        String[] cmds = new String[cmdList.size()];
        cmds = cmdList.toArray(cmds);
        return cmds;
    }
}

