/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.activation.MimeTypeParseException;

public class MimeTypeParameterList {
    private Hashtable parameters = new Hashtable();
    private static final String TSPECIALS = "()<>@,;:/[]?=\\\"";

    public MimeTypeParameterList() {
    }

    public MimeTypeParameterList(String parameterList) throws MimeTypeParseException {
        this.parse(parameterList);
    }

    protected void parse(String parameterList) throws MimeTypeParseException {
        char c10;
        if (parameterList == null) {
            return;
        }
        int length = parameterList.length();
        if (length <= 0) {
            return;
        }
        int i10 = MimeTypeParameterList.skipWhiteSpace(parameterList, 0);
        while (i10 < length && (c10 = parameterList.charAt(i10)) == ';') {
            String value;
            ++i10;
            if ((i10 = MimeTypeParameterList.skipWhiteSpace(parameterList, i10)) >= length) {
                return;
            }
            int lastIndex = i10;
            while (i10 < length && MimeTypeParameterList.isTokenChar(parameterList.charAt(i10))) {
                ++i10;
            }
            String name = parameterList.substring(lastIndex, i10).toLowerCase();
            if ((i10 = MimeTypeParameterList.skipWhiteSpace(parameterList, i10)) >= length || parameterList.charAt(i10) != '=') {
                throw new MimeTypeParseException("Couldn't find the '=' that separates a parameter name from its value.");
            }
            ++i10;
            if ((i10 = MimeTypeParameterList.skipWhiteSpace(parameterList, i10)) >= length) {
                throw new MimeTypeParseException("Couldn't find a value for parameter named " + name);
            }
            c10 = parameterList.charAt(i10);
            if (c10 == '\"') {
                if (++i10 >= length) {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                lastIndex = i10;
                while (i10 < length && (c10 = parameterList.charAt(i10)) != '\"') {
                    if (c10 == '\\') {
                        ++i10;
                    }
                    ++i10;
                }
                if (c10 != '\"') {
                    throw new MimeTypeParseException("Encountered unterminated quoted parameter value.");
                }
                value = MimeTypeParameterList.unquote(parameterList.substring(lastIndex, i10));
                ++i10;
            } else if (MimeTypeParameterList.isTokenChar(c10)) {
                lastIndex = i10;
                while (i10 < length && MimeTypeParameterList.isTokenChar(parameterList.charAt(i10))) {
                    ++i10;
                }
                value = parameterList.substring(lastIndex, i10);
            } else {
                throw new MimeTypeParseException("Unexpected character encountered at index " + i10);
            }
            this.parameters.put(name, value);
            i10 = MimeTypeParameterList.skipWhiteSpace(parameterList, i10);
        }
        if (i10 < length) {
            throw new MimeTypeParseException("More characters encountered in input than expected.");
        }
    }

    public int size() {
        return this.parameters.size();
    }

    public boolean isEmpty() {
        return this.parameters.isEmpty();
    }

    public String get(String name) {
        return (String)this.parameters.get(name.trim().toLowerCase());
    }

    public void set(String name, String value) {
        this.parameters.put(name.trim().toLowerCase(), value);
    }

    public void remove(String name) {
        this.parameters.remove(name.trim().toLowerCase());
    }

    public Enumeration getNames() {
        return this.parameters.keys();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(this.parameters.size() * 16);
        Enumeration keys = this.parameters.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buffer.append("; ");
            buffer.append(key);
            buffer.append('=');
            buffer.append(MimeTypeParameterList.quote((String)this.parameters.get(key)));
        }
        return buffer.toString();
    }

    private static boolean isTokenChar(char c10) {
        return c10 > ' ' && c10 < '\u007f' && TSPECIALS.indexOf(c10) < 0;
    }

    private static int skipWhiteSpace(String rawdata, int i10) {
        int length = rawdata.length();
        while (i10 < length && Character.isWhitespace(rawdata.charAt(i10))) {
            ++i10;
        }
        return i10;
    }

    private static String quote(String value) {
        boolean needsQuotes = false;
        int length = value.length();
        for (int i10 = 0; i10 < length && !needsQuotes; ++i10) {
            needsQuotes = !MimeTypeParameterList.isTokenChar(value.charAt(i10));
        }
        if (needsQuotes) {
            StringBuffer buffer = new StringBuffer();
            buffer.ensureCapacity((int)((double)length * 1.5));
            buffer.append('\"');
            for (int i11 = 0; i11 < length; ++i11) {
                char c10 = value.charAt(i11);
                if (c10 == '\\' || c10 == '\"') {
                    buffer.append('\\');
                }
                buffer.append(c10);
            }
            buffer.append('\"');
            return buffer.toString();
        }
        return value;
    }

    private static String unquote(String value) {
        int valueLength = value.length();
        StringBuffer buffer = new StringBuffer();
        buffer.ensureCapacity(valueLength);
        boolean escaped = false;
        for (int i10 = 0; i10 < valueLength; ++i10) {
            char currentChar = value.charAt(i10);
            if (!escaped && currentChar != '\\') {
                buffer.append(currentChar);
                continue;
            }
            if (escaped) {
                buffer.append(currentChar);
                escaped = false;
                continue;
            }
            escaped = true;
        }
        return buffer.toString();
    }
}

