/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;

class SecuritySupport {
    private SecuritySupport() {
    }

    public static ClassLoader getContextClassLoader() {
        return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ClassLoader cl2 = null;
                try {
                    cl2 = Thread.currentThread().getContextClassLoader();
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return cl2;
            }
        });
    }

    public static InputStream getResourceAsStream(final Class c10, final String name) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return c10.getResourceAsStream(name);
                }
            });
        }
        catch (PrivilegedActionException e10) {
            throw (IOException)e10.getException();
        }
    }

    public static URL[] getResources(final ClassLoader cl2, final String name) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL[] ret = null;
                try {
                    ArrayList<URL> v10 = new ArrayList<URL>();
                    Enumeration<URL> e10 = cl2.getResources(name);
                    while (e10 != null && e10.hasMoreElements()) {
                        URL url = e10.nextElement();
                        if (url == null) continue;
                        v10.add(url);
                    }
                    if (v10.size() > 0) {
                        ret = new URL[v10.size()];
                        ret = v10.toArray(ret);
                    }
                }
                catch (IOException ioex) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    public static URL[] getSystemResources(final String name) {
        return (URL[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                URL[] ret = null;
                try {
                    ArrayList<URL> v10 = new ArrayList<URL>();
                    Enumeration<URL> e10 = ClassLoader.getSystemResources(name);
                    while (e10 != null && e10.hasMoreElements()) {
                        URL url = e10.nextElement();
                        if (url == null) continue;
                        v10.add(url);
                    }
                    if (v10.size() > 0) {
                        ret = new URL[v10.size()];
                        ret = v10.toArray(ret);
                    }
                }
                catch (IOException ioex) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                return ret;
            }
        });
    }

    public static InputStream openStream(final URL url) throws IOException {
        try {
            return (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return url.openStream();
                }
            });
        }
        catch (PrivilegedActionException e10) {
            throw (IOException)e10.getException();
        }
    }
}

