/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.util.ArrayList;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.ConstraintParser;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.UnitValue;

public final class AC
implements Externalizable {
    private final ArrayList<DimConstraint> cList = new ArrayList(1);
    private transient int curIx = 0;

    public AC() {
        this.cList.add(new DimConstraint());
    }

    public final DimConstraint[] getConstaints() {
        return this.cList.toArray(new DimConstraint[this.cList.size()]);
    }

    public final void setConstaints(DimConstraint[] constr) {
        if (constr == null || constr.length < 1) {
            constr = new DimConstraint[]{new DimConstraint()};
        }
        this.cList.clear();
        this.cList.ensureCapacity(constr.length);
        for (DimConstraint c10 : constr) {
            this.cList.add(c10);
        }
    }

    public int getCount() {
        return this.cList.size();
    }

    public final AC count(int size) {
        this.makeSize(size);
        return this;
    }

    public final AC noGrid() {
        return this.noGrid(this.curIx);
    }

    public final AC noGrid(int ... indexes) {
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2);
            this.cList.get(ix2).setNoGrid(true);
        }
        return this;
    }

    public final AC index(int i10) {
        this.makeSize(i10);
        this.curIx = i10;
        return this;
    }

    public final AC fill() {
        return this.fill(this.curIx);
    }

    public final AC fill(int ... indexes) {
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2);
            this.cList.get(ix2).setFill(true);
        }
        return this;
    }

    public final AC sizeGroup() {
        return this.sizeGroup("", this.curIx);
    }

    public final AC sizeGroup(String s10) {
        return this.sizeGroup(s10, this.curIx);
    }

    public final AC sizeGroup(String s10, int ... indexes) {
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2);
            this.cList.get(ix2).setSizeGroup(s10);
        }
        return this;
    }

    public final AC size(String s10) {
        return this.size(s10, this.curIx);
    }

    public final AC size(String size, int ... indexes) {
        BoundSize bs2 = ConstraintParser.parseBoundSize(size, false, true);
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2);
            this.cList.get(ix2).setSize(bs2);
        }
        return this;
    }

    public final AC gap() {
        ++this.curIx;
        this.makeSize(this.curIx);
        return this;
    }

    public final AC gap(String size) {
        return this.gap(size, this.curIx++);
    }

    public final AC gap(String size, int ... indexes) {
        BoundSize bsa = size != null ? ConstraintParser.parseBoundSize(size, true, true) : null;
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2 + 1);
            if (bsa == null) continue;
            this.cList.get(ix2).setGapAfter(bsa);
        }
        return this;
    }

    public final AC align(String side) {
        return this.align(side, this.curIx);
    }

    public final AC align(String side, int ... indexes) {
        UnitValue al10 = ConstraintParser.parseAlignKeywords(side, true);
        if (al10 == null) {
            al10 = ConstraintParser.parseAlignKeywords(side, false);
        }
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2);
            this.cList.get(ix2).setAlign(al10);
        }
        return this;
    }

    public final AC growPrio(int p10) {
        return this.growPrio(p10, this.curIx);
    }

    public final AC growPrio(int p10, int ... indexes) {
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2);
            this.cList.get(ix2).setGrowPriority(p10);
        }
        return this;
    }

    public final AC grow() {
        return this.grow(100.0f, this.curIx);
    }

    public final AC grow(float w10) {
        return this.grow(w10, this.curIx);
    }

    public final AC grow(float w10, int ... indexes) {
        Float gw2 = new Float(w10);
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2);
            this.cList.get(ix2).setGrow(gw2);
        }
        return this;
    }

    public final AC shrinkPrio(int p10) {
        return this.shrinkPrio(p10, this.curIx);
    }

    public final AC shrinkPrio(int p10, int ... indexes) {
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2);
            this.cList.get(ix2).setShrinkPriority(p10);
        }
        return this;
    }

    public final AC shrink() {
        return this.shrink(100.0f, this.curIx);
    }

    public final AC shrink(float w10) {
        return this.shrink(w10, this.curIx);
    }

    public final AC shrink(float w10, int ... indexes) {
        Float sw2 = new Float(w10);
        for (int i10 = indexes.length - 1; i10 >= 0; --i10) {
            int ix2 = indexes[i10];
            this.makeSize(ix2);
            this.cList.get(ix2).setShrink(sw2);
        }
        return this;
    }

    public final AC shrinkWeight(float w10) {
        return this.shrink(w10);
    }

    public final AC shrinkWeight(float w10, int ... indexes) {
        return this.shrink(w10, indexes);
    }

    private void makeSize(int sz2) {
        if (this.cList.size() <= sz2) {
            this.cList.ensureCapacity(sz2);
            for (int i10 = this.cList.size(); i10 <= sz2; ++i10) {
                this.cList.add(new DimConstraint());
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return LayoutUtil.getSerializedObject(this);
    }

    @Override
    public void readExternal(ObjectInput in2) throws IOException, ClassNotFoundException {
        LayoutUtil.setSerializedObject(this, LayoutUtil.readAsXML(in2));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.getClass() == AC.class) {
            LayoutUtil.writeAsXML(out, this);
        }
    }
}

