/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.layout.ResizeConstraint;
import net.miginfocom.layout.UnitValue;

public final class ConstraintParser {
    private ConstraintParser() {
    }

    public static LC parseLayoutConstraint(String s10) {
        LC lc2 = new LC();
        if (s10.isEmpty()) {
            return lc2;
        }
        String[] parts = ConstraintParser.toTrimmedTokens(s10, ',');
        for (int i10 = 0; i10 < parts.length; ++i10) {
            int len;
            String part = parts[i10];
            if (part == null || (len = part.length()) != 3 && len != 11) continue;
            if (part.equals("ltr") || part.equals("rtl") || part.equals("lefttoright") || part.equals("righttoleft")) {
                lc2.setLeftToRight(part.charAt(0) == 'l' ? Boolean.TRUE : Boolean.FALSE);
                parts[i10] = null;
            }
            if (!part.equals("ttb") && !part.equals("btt") && !part.equals("toptobottom") && !part.equals("bottomtotop")) continue;
            lc2.setTopToBottom(part.charAt(0) == 't');
            parts[i10] = null;
        }
        for (String part : parts) {
            if (part == null || part.length() == 0) continue;
            try {
                UnitValue alignX;
                int ix2 = -1;
                char c10 = part.charAt(0);
                if (c10 == 'w' || c10 == 'h') {
                    String sz2;
                    boolean isHor;
                    ix2 = ConstraintParser.startsWithLenient(part, "wrap", -1, true);
                    if (ix2 > -1) {
                        String num = part.substring(ix2).trim();
                        lc2.setWrapAfter(num.length() != 0 ? Integer.parseInt(num) : 0);
                        continue;
                    }
                    boolean bl2 = isHor = c10 == 'w';
                    if (isHor && (part.startsWith("w ") || part.startsWith("width "))) {
                        sz2 = part.substring(part.charAt(1) == ' ' ? 2 : 6).trim();
                        lc2.setWidth(ConstraintParser.parseBoundSize(sz2, false, true));
                        continue;
                    }
                    if (!isHor && (part.startsWith("h ") || part.startsWith("height "))) {
                        String uvStr = part.substring(part.charAt(1) == ' ' ? 2 : 7).trim();
                        lc2.setHeight(ConstraintParser.parseBoundSize(uvStr, false, false));
                        continue;
                    }
                    if (part.length() > 5) {
                        sz2 = part.substring(5).trim();
                        if (part.startsWith("wmin ")) {
                            lc2.minWidth(sz2);
                            continue;
                        }
                        if (part.startsWith("wmax ")) {
                            lc2.maxWidth(sz2);
                            continue;
                        }
                        if (part.startsWith("hmin ")) {
                            lc2.minHeight(sz2);
                            continue;
                        }
                        if (part.startsWith("hmax ")) {
                            lc2.maxHeight(sz2);
                            continue;
                        }
                    }
                    if (part.startsWith("hidemode ")) {
                        lc2.setHideMode(Integer.parseInt(part.substring(9)));
                        continue;
                    }
                }
                if (c10 == 'g') {
                    if (part.startsWith("gapx ")) {
                        lc2.setGridGapX(ConstraintParser.parseBoundSize(part.substring(5).trim(), true, true));
                        continue;
                    }
                    if (part.startsWith("gapy ")) {
                        lc2.setGridGapY(ConstraintParser.parseBoundSize(part.substring(5).trim(), true, false));
                        continue;
                    }
                    if (part.startsWith("gap ")) {
                        String[] gaps = ConstraintParser.toTrimmedTokens(part.substring(4).trim(), ' ');
                        lc2.setGridGapX(ConstraintParser.parseBoundSize(gaps[0], true, true));
                        lc2.setGridGapY(gaps.length > 1 ? ConstraintParser.parseBoundSize(gaps[1], true, false) : lc2.getGridGapX());
                        continue;
                    }
                }
                if (c10 == 'd' && (ix2 = ConstraintParser.startsWithLenient(part, "debug", 5, true)) > -1) {
                    String millis = part.substring(ix2).trim();
                    lc2.setDebugMillis(millis.length() > 0 ? Integer.parseInt(millis) : 1000);
                    continue;
                }
                if (c10 == 'n') {
                    if (part.equals("nogrid")) {
                        lc2.setNoGrid(true);
                        continue;
                    }
                    if (part.equals("nocache")) {
                        lc2.setNoCache(true);
                        continue;
                    }
                    if (part.equals("novisualpadding")) {
                        lc2.setVisualPadding(false);
                        continue;
                    }
                }
                if (c10 == 'f') {
                    if (part.equals("fill") || part.equals("fillx") || part.equals("filly")) {
                        lc2.setFillX(part.length() == 4 || part.charAt(4) == 'x');
                        lc2.setFillY(part.length() == 4 || part.charAt(4) == 'y');
                        continue;
                    }
                    if (part.equals("flowy")) {
                        lc2.setFlowX(false);
                        continue;
                    }
                    if (part.equals("flowx")) {
                        lc2.setFlowX(true);
                        continue;
                    }
                }
                if (c10 == 'i' && (ix2 = ConstraintParser.startsWithLenient(part, "insets", 3, true)) > -1) {
                    String insStr = part.substring(ix2).trim();
                    UnitValue[] ins = ConstraintParser.parseInsets(insStr, true);
                    LayoutUtil.putCCString(ins, insStr);
                    lc2.setInsets(ins);
                    continue;
                }
                if (c10 == 'a') {
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"aligny", "ay"}, new int[]{6, 2}, true);
                    if (ix2 > -1) {
                        UnitValue align = ConstraintParser.parseUnitValueOrAlign(part.substring(ix2).trim(), false, null);
                        if (align == UnitValue.BASELINE_IDENTITY) {
                            throw new IllegalArgumentException("'baseline' can not be used to align the whole component group.");
                        }
                        lc2.setAlignY(align);
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"alignx", "ax"}, new int[]{6, 2}, true);
                    if (ix2 > -1) {
                        lc2.setAlignX(ConstraintParser.parseUnitValueOrAlign(part.substring(ix2).trim(), true, null));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "align", 2, true);
                    if (ix2 > -1) {
                        String[] gaps = ConstraintParser.toTrimmedTokens(part.substring(ix2).trim(), ' ');
                        lc2.setAlignX(ConstraintParser.parseUnitValueOrAlign(gaps[0], true, null));
                        if (gaps.length > 1) {
                            UnitValue align = ConstraintParser.parseUnitValueOrAlign(gaps[1], false, null);
                            if (align == UnitValue.BASELINE_IDENTITY) {
                                throw new IllegalArgumentException("'baseline' can not be used to align the whole component group.");
                            }
                            lc2.setAlignY(align);
                        }
                        continue;
                    }
                }
                if (c10 == 'p') {
                    if (part.startsWith("packalign ")) {
                        String[] packs = ConstraintParser.toTrimmedTokens(part.substring(10).trim(), ' ');
                        lc2.setPackWidthAlign(packs[0].length() > 0 ? Float.parseFloat(packs[0]) : 0.5f);
                        if (packs.length > 1) {
                            lc2.setPackHeightAlign(Float.parseFloat(packs[1]));
                        }
                        continue;
                    }
                    if (part.startsWith("pack ") || part.equals("pack")) {
                        String ps2 = part.substring(4).trim();
                        String[] packs = ConstraintParser.toTrimmedTokens(ps2.length() > 0 ? ps2 : "pref pref", ' ');
                        lc2.setPackWidth(ConstraintParser.parseBoundSize(packs[0], false, true));
                        if (packs.length > 1) {
                            lc2.setPackHeight(ConstraintParser.parseBoundSize(packs[1], false, false));
                        }
                        continue;
                    }
                }
                if (lc2.getAlignX() == null && (alignX = ConstraintParser.parseAlignKeywords(part, true)) != null) {
                    lc2.setAlignX(alignX);
                    continue;
                }
                UnitValue alignY = ConstraintParser.parseAlignKeywords(part, false);
                if (alignY != null) {
                    lc2.setAlignY(alignY);
                    continue;
                }
                throw new IllegalArgumentException("Unknown Constraint: '" + part + "'\n");
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException("Illegal Constraint: '" + part + "'\n" + ex2.getMessage());
            }
        }
        return lc2;
    }

    public static AC parseRowConstraints(String s10) {
        return ConstraintParser.parseAxisConstraint(s10, false);
    }

    public static AC parseColumnConstraints(String s10) {
        return ConstraintParser.parseAxisConstraint(s10, true);
    }

    private static AC parseAxisConstraint(String s10, boolean isCols) {
        if ((s10 = s10.trim()).length() == 0) {
            return new AC();
        }
        s10 = s10.toLowerCase();
        ArrayList<String> parts = ConstraintParser.getRowColAndGapsTrimmed(s10);
        BoundSize[] gaps = new BoundSize[(parts.size() >> 1) + 1];
        int i10 = 0;
        int iSz = parts.size();
        int gIx = 0;
        while (i10 < iSz) {
            gaps[gIx] = ConstraintParser.parseBoundSize(parts.get(i10), true, isCols);
            i10 += 2;
            ++gIx;
        }
        DimConstraint[] colSpecs = new DimConstraint[parts.size() >> 1];
        int i11 = 0;
        gIx = 0;
        while (i11 < colSpecs.length) {
            if (gIx >= gaps.length - 1) {
                gIx = gaps.length - 2;
            }
            colSpecs[i11] = ConstraintParser.parseDimConstraint(parts.get((i11 << 1) + 1), gaps[gIx], gaps[gIx + 1], isCols);
            ++i11;
            ++gIx;
        }
        AC ac10 = new AC();
        ac10.setConstaints(colSpecs);
        return ac10;
    }

    private static DimConstraint parseDimConstraint(String s10, BoundSize gapBefore, BoundSize gapAfter, boolean isCols) {
        DimConstraint dimConstraint = new DimConstraint();
        dimConstraint.setGapBefore(gapBefore);
        dimConstraint.setGapAfter(gapAfter);
        String[] parts = ConstraintParser.toTrimmedTokens(s10, ',');
        for (int i10 = 0; i10 < parts.length; ++i10) {
            String part = parts[i10];
            try {
                if (part.length() == 0) continue;
                if (part.equals("fill")) {
                    dimConstraint.setFill(true);
                    continue;
                }
                if (part.equals("nogrid")) {
                    dimConstraint.setNoGrid(true);
                    continue;
                }
                int ix2 = -1;
                char c10 = part.charAt(0);
                if (c10 == 's') {
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"sizegroup", "sg"}, new int[]{5, 2}, true);
                    if (ix2 > -1) {
                        dimConstraint.setSizeGroup(part.substring(ix2).trim());
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"shrinkprio", "shp"}, new int[]{10, 3}, true);
                    if (ix2 > -1) {
                        dimConstraint.setShrinkPriority(Integer.parseInt(part.substring(ix2).trim()));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "shrink", 6, true);
                    if (ix2 > -1) {
                        dimConstraint.setShrink(ConstraintParser.parseFloat(part.substring(ix2).trim(), ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                }
                if (c10 == 'g') {
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"growpriority", "gp"}, new int[]{5, 2}, true);
                    if (ix2 > -1) {
                        dimConstraint.setGrowPriority(Integer.parseInt(part.substring(ix2).trim()));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "grow", 4, true);
                    if (ix2 > -1) {
                        dimConstraint.setGrow(ConstraintParser.parseFloat(part.substring(ix2).trim(), ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                }
                if (c10 == 'a' && (ix2 = ConstraintParser.startsWithLenient(part, "align", 2, true)) > -1) {
                    dimConstraint.setAlign(ConstraintParser.parseUnitValueOrAlign(part.substring(ix2).trim(), isCols, null));
                    continue;
                }
                UnitValue align = ConstraintParser.parseAlignKeywords(part, isCols);
                if (align != null) {
                    dimConstraint.setAlign(align);
                    continue;
                }
                dimConstraint.setSize(ConstraintParser.parseBoundSize(part, false, isCols));
                continue;
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException("Illegal constraint: '" + part + "'\n" + ex2.getMessage());
            }
        }
        return dimConstraint;
    }

    public static Map<ComponentWrapper, CC> parseComponentConstraints(Map<ComponentWrapper, String> constrMap) {
        HashMap<ComponentWrapper, CC> flowConstrMap = new HashMap<ComponentWrapper, CC>();
        for (Map.Entry<ComponentWrapper, String> entry : constrMap.entrySet()) {
            flowConstrMap.put(entry.getKey(), ConstraintParser.parseComponentConstraint(entry.getValue()));
        }
        return flowConstrMap;
    }

    public static CC parseComponentConstraint(String s10) {
        String[] parts;
        CC cc2 = new CC();
        if (s10 == null || s10.isEmpty()) {
            return cc2;
        }
        for (String part : parts = ConstraintParser.toTrimmedTokens(s10, ',')) {
            try {
                char c22;
                if (part.length() == 0) continue;
                int ix2 = -1;
                char c10 = part.charAt(0);
                if (c10 == 'n') {
                    if (part.equals("north")) {
                        cc2.setDockSide(0);
                        continue;
                    }
                    if (part.equals("newline")) {
                        cc2.setNewline(true);
                        continue;
                    }
                    if (part.startsWith("newline ")) {
                        String gapSz = part.substring(7).trim();
                        cc2.setNewlineGapSize(ConstraintParser.parseBoundSize(gapSz, true, true));
                        continue;
                    }
                }
                if (c10 == 'f' && (part.equals("flowy") || part.equals("flowx"))) {
                    cc2.setFlowX(part.charAt(4) == 'x' ? Boolean.TRUE : Boolean.FALSE);
                    continue;
                }
                if (c10 == 's') {
                    ix2 = ConstraintParser.startsWithLenient(part, "skip", 4, true);
                    if (ix2 > -1) {
                        String num = part.substring(ix2).trim();
                        cc2.setSkip(num.length() != 0 ? Integer.parseInt(num) : 1);
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "split", 5, true);
                    if (ix2 > -1) {
                        String split = part.substring(ix2).trim();
                        cc2.setSplit(split.length() > 0 ? Integer.parseInt(split) : 2097051);
                        continue;
                    }
                    if (part.equals("south")) {
                        cc2.setDockSide(2);
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"spany", "sy"}, new int[]{5, 2}, true);
                    if (ix2 > -1) {
                        cc2.setSpanY(ConstraintParser.parseSpan(part.substring(ix2).trim()));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"spanx", "sx"}, new int[]{5, 2}, true);
                    if (ix2 > -1) {
                        cc2.setSpanX(ConstraintParser.parseSpan(part.substring(ix2).trim()));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "span", 4, true);
                    if (ix2 > -1) {
                        String[] spans = ConstraintParser.toTrimmedTokens(part.substring(ix2).trim(), ' ');
                        cc2.setSpanX(spans[0].length() > 0 ? Integer.parseInt(spans[0]) : 2097051);
                        cc2.setSpanY(spans.length > 1 ? Integer.parseInt(spans[1]) : 1);
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "shrinkx", 7, true);
                    if (ix2 > -1) {
                        cc2.getHorizontal().setShrink(ConstraintParser.parseFloat(part.substring(ix2).trim(), ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "shrinky", 7, true);
                    if (ix2 > -1) {
                        cc2.getVertical().setShrink(ConstraintParser.parseFloat(part.substring(ix2).trim(), ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "shrink", 6, false);
                    if (ix2 > -1) {
                        String[] shrinks = ConstraintParser.toTrimmedTokens(part.substring(ix2).trim(), ' ');
                        cc2.getHorizontal().setShrink(ConstraintParser.parseFloat(shrinks[0], ResizeConstraint.WEIGHT_100));
                        if (shrinks.length > 1) {
                            cc2.getVertical().setShrink(ConstraintParser.parseFloat(shrinks[1], ResizeConstraint.WEIGHT_100));
                        }
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"shrinkprio", "shp"}, new int[]{10, 3}, true);
                    if (ix2 > -1) {
                        String sp2 = part.substring(ix2).trim();
                        if (sp2.startsWith("x") || sp2.startsWith("y")) {
                            (sp2.startsWith("x") ? cc2.getHorizontal() : cc2.getVertical()).setShrinkPriority(Integer.parseInt(sp2.substring(2)));
                            continue;
                        }
                        String[] shrinks = ConstraintParser.toTrimmedTokens(sp2, ' ');
                        cc2.getHorizontal().setShrinkPriority(Integer.parseInt(shrinks[0]));
                        if (shrinks.length <= 1) continue;
                        cc2.getVertical().setShrinkPriority(Integer.parseInt(shrinks[1]));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"sizegroupx", "sizegroupy", "sgx", "sgy"}, new int[]{9, 9, 2, 2}, true);
                    if (ix2 > -1) {
                        String sg2 = part.substring(ix2).trim();
                        char lc2 = part.charAt(ix2 - 1);
                        if (lc2 != 'y') {
                            cc2.getHorizontal().setSizeGroup(sg2);
                        }
                        if (lc2 != 'x') {
                            cc2.getVertical().setSizeGroup(sg2);
                        }
                        continue;
                    }
                }
                if (c10 == 'g') {
                    ix2 = ConstraintParser.startsWithLenient(part, "growx", 5, true);
                    if (ix2 > -1) {
                        cc2.getHorizontal().setGrow(ConstraintParser.parseFloat(part.substring(ix2).trim(), ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "growy", 5, true);
                    if (ix2 > -1) {
                        cc2.getVertical().setGrow(ConstraintParser.parseFloat(part.substring(ix2).trim(), ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "grow", 4, false);
                    if (ix2 > -1) {
                        String[] grows = ConstraintParser.toTrimmedTokens(part.substring(ix2).trim(), ' ');
                        cc2.getHorizontal().setGrow(ConstraintParser.parseFloat(grows[0], ResizeConstraint.WEIGHT_100));
                        cc2.getVertical().setGrow(ConstraintParser.parseFloat(grows.length > 1 ? grows[1] : "", ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"growprio", "gp"}, new int[]{8, 2}, true);
                    if (ix2 > -1) {
                        int c02;
                        String gp2 = part.substring(ix2).trim();
                        int n10 = c02 = gp2.length() > 0 ? (int)gp2.charAt(0) : 32;
                        if (c02 == 120 || c02 == 121) {
                            (c02 == 120 ? cc2.getHorizontal() : cc2.getVertical()).setGrowPriority(Integer.parseInt(gp2.substring(2)));
                            continue;
                        }
                        String[] grows = ConstraintParser.toTrimmedTokens(gp2, ' ');
                        cc2.getHorizontal().setGrowPriority(Integer.parseInt(grows[0]));
                        if (grows.length <= 1) continue;
                        cc2.getVertical().setGrowPriority(Integer.parseInt(grows[1]));
                        continue;
                    }
                    if (part.startsWith("gap")) {
                        BoundSize[] gaps = ConstraintParser.parseGaps(part);
                        if (gaps[0] != null) {
                            cc2.getVertical().setGapBefore(gaps[0]);
                        }
                        if (gaps[1] != null) {
                            cc2.getHorizontal().setGapBefore(gaps[1]);
                        }
                        if (gaps[2] != null) {
                            cc2.getVertical().setGapAfter(gaps[2]);
                        }
                        if (gaps[3] != null) {
                            cc2.getHorizontal().setGapAfter(gaps[3]);
                        }
                        continue;
                    }
                }
                if (c10 == 'a') {
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"aligny", "ay"}, new int[]{6, 2}, true);
                    if (ix2 > -1) {
                        cc2.getVertical().setAlign(ConstraintParser.parseUnitValueOrAlign(part.substring(ix2).trim(), false, null));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"alignx", "ax"}, new int[]{6, 2}, true);
                    if (ix2 > -1) {
                        cc2.getHorizontal().setAlign(ConstraintParser.parseUnitValueOrAlign(part.substring(ix2).trim(), true, null));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "align", 2, true);
                    if (ix2 > -1) {
                        String[] gaps = ConstraintParser.toTrimmedTokens(part.substring(ix2).trim(), ' ');
                        cc2.getHorizontal().setAlign(ConstraintParser.parseUnitValueOrAlign(gaps[0], true, null));
                        if (gaps.length > 1) {
                            cc2.getVertical().setAlign(ConstraintParser.parseUnitValueOrAlign(gaps[1], false, null));
                        }
                        continue;
                    }
                }
                if ((c10 == 'x' || c10 == 'y') && part.length() > 2 && ((c22 = part.charAt(1)) == ' ' || c22 == '2' && part.charAt(2) == ' ')) {
                    if (cc2.getPos() == null) {
                        cc2.setPos(new UnitValue[4]);
                    } else if (!cc2.isBoundsInGrid()) {
                        throw new IllegalArgumentException("Cannot combine 'position' with 'x/y/x2/y2' keywords.");
                    }
                    int edge = (c10 == 'x' ? 0 : 1) + (c22 == '2' ? 2 : 0);
                    UnitValue[] pos = cc2.getPos();
                    pos[edge] = ConstraintParser.parseUnitValue(part.substring(2).trim(), null, c10 == 'x');
                    cc2.setPos(pos);
                    cc2.setBoundsInGrid(true);
                    continue;
                }
                if (c10 == 'c' && (ix2 = ConstraintParser.startsWithLenient(part, "cell", 4, true)) > -1) {
                    String[] grs = ConstraintParser.toTrimmedTokens(part.substring(ix2).trim(), ' ');
                    if (grs.length < 2) {
                        throw new IllegalArgumentException("At least two integers must follow " + part);
                    }
                    cc2.setCellX(Integer.parseInt(grs[0]));
                    cc2.setCellY(Integer.parseInt(grs[1]));
                    if (grs.length > 2) {
                        cc2.setSpanX(Integer.parseInt(grs[2]));
                    }
                    if (grs.length > 3) {
                        cc2.setSpanY(Integer.parseInt(grs[3]));
                    }
                    continue;
                }
                if (c10 == 'p') {
                    ix2 = ConstraintParser.startsWithLenient(part, "pos", 3, true);
                    if (ix2 > -1) {
                        if (cc2.getPos() != null && cc2.isBoundsInGrid()) {
                            throw new IllegalArgumentException("Can not combine 'pos' with 'x/y/x2/y2' keywords.");
                        }
                        String[] pos = ConstraintParser.toTrimmedTokens(part.substring(ix2).trim(), ' ');
                        UnitValue[] bounds = new UnitValue[4];
                        for (int j10 = 0; j10 < pos.length; ++j10) {
                            bounds[j10] = ConstraintParser.parseUnitValue(pos[j10], null, j10 % 2 == 0);
                        }
                        if (bounds[0] == null && bounds[2] == null || bounds[1] == null && bounds[3] == null) {
                            throw new IllegalArgumentException("Both x and x2 or y and y2 can not be null!");
                        }
                        cc2.setPos(bounds);
                        cc2.setBoundsInGrid(false);
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "pad", 3, true);
                    if (ix2 > -1) {
                        UnitValue[] p10 = ConstraintParser.parseInsets(part.substring(ix2).trim(), false);
                        cc2.setPadding(new UnitValue[]{p10[0], p10.length > 1 ? p10[1] : null, p10.length > 2 ? p10[2] : null, p10.length > 3 ? p10[3] : null});
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "pushx", 5, true);
                    if (ix2 > -1) {
                        cc2.setPushX(ConstraintParser.parseFloat(part.substring(ix2).trim(), ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "pushy", 5, true);
                    if (ix2 > -1) {
                        cc2.setPushY(ConstraintParser.parseFloat(part.substring(ix2).trim(), ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, "push", 4, false);
                    if (ix2 > -1) {
                        String[] pushs = ConstraintParser.toTrimmedTokens(part.substring(ix2).trim(), ' ');
                        cc2.setPushX(ConstraintParser.parseFloat(pushs[0], ResizeConstraint.WEIGHT_100));
                        cc2.setPushY(ConstraintParser.parseFloat(pushs.length > 1 ? pushs[1] : "", ResizeConstraint.WEIGHT_100));
                        continue;
                    }
                }
                if (c10 == 't' && (ix2 = ConstraintParser.startsWithLenient(part, "tag", 3, true)) > -1) {
                    cc2.setTag(part.substring(ix2).trim());
                    continue;
                }
                if (c10 == 'w' || c10 == 'h') {
                    String uvStr;
                    boolean isHor;
                    if (part.equals("wrap")) {
                        cc2.setWrap(true);
                        continue;
                    }
                    if (part.startsWith("wrap ")) {
                        String gapSz = part.substring(5).trim();
                        cc2.setWrapGapSize(ConstraintParser.parseBoundSize(gapSz, true, true));
                        continue;
                    }
                    boolean bl2 = isHor = c10 == 'w';
                    if (isHor && (part.startsWith("w ") || part.startsWith("width "))) {
                        String uvStr2 = part.substring(part.charAt(1) == ' ' ? 2 : 6).trim();
                        cc2.getHorizontal().setSize(ConstraintParser.parseBoundSize(uvStr2, false, true));
                        continue;
                    }
                    if (!isHor && (part.startsWith("h ") || part.startsWith("height "))) {
                        String uvStr3 = part.substring(part.charAt(1) == ' ' ? 2 : 7).trim();
                        cc2.getVertical().setSize(ConstraintParser.parseBoundSize(uvStr3, false, false));
                        continue;
                    }
                    if ((part.startsWith("wmin ") || part.startsWith("wmax ") || part.startsWith("hmin ") || part.startsWith("hmax ")) && (uvStr = part.substring(5).trim()).length() > 0) {
                        UnitValue uv2 = ConstraintParser.parseUnitValue(uvStr, null, isHor);
                        boolean isMin = part.charAt(3) == 'n';
                        DimConstraint dc2 = isHor ? cc2.getHorizontal() : cc2.getVertical();
                        dc2.setSize(new BoundSize(isMin ? uv2 : dc2.getSize().getMin(), dc2.getSize().getPreferred(), isMin ? dc2.getSize().getMax() : uv2, uvStr));
                        continue;
                    }
                    if (part.equals("west")) {
                        cc2.setDockSide(1);
                        continue;
                    }
                    if (part.startsWith("hidemode ")) {
                        cc2.setHideMode(Integer.parseInt(part.substring(9)));
                        continue;
                    }
                }
                if (c10 == 'i' && part.startsWith("id ")) {
                    cc2.setId(part.substring(3).trim());
                    int dIx = cc2.getId().indexOf(46);
                    if (dIx != 0 && dIx != cc2.getId().length() - 1) continue;
                    throw new IllegalArgumentException("Dot must not be first or last!");
                }
                if (c10 == 'e') {
                    if (part.equals("east")) {
                        cc2.setDockSide(3);
                        continue;
                    }
                    if (part.equals("external")) {
                        cc2.setExternal(true);
                        continue;
                    }
                    ix2 = ConstraintParser.startsWithLenient(part, new String[]{"endgroupx", "endgroupy", "egx", "egy"}, new int[]{-1, -1, -1, -1}, true);
                    if (ix2 > -1) {
                        String sg3 = part.substring(ix2).trim();
                        char lc3 = part.charAt(ix2 - 1);
                        DimConstraint dc3 = lc3 == 'x' ? cc2.getHorizontal() : cc2.getVertical();
                        dc3.setEndGroup(sg3);
                        continue;
                    }
                }
                if (c10 == 'd') {
                    if (part.equals("dock north")) {
                        cc2.setDockSide(0);
                        continue;
                    }
                    if (part.equals("dock west")) {
                        cc2.setDockSide(1);
                        continue;
                    }
                    if (part.equals("dock south")) {
                        cc2.setDockSide(2);
                        continue;
                    }
                    if (part.equals("dock east")) {
                        cc2.setDockSide(3);
                        continue;
                    }
                    if (part.equals("dock center")) {
                        cc2.getHorizontal().setGrow(Float.valueOf(100.0f));
                        cc2.getVertical().setGrow(Float.valueOf(100.0f));
                        cc2.setPushX(Float.valueOf(100.0f));
                        cc2.setPushY(Float.valueOf(100.0f));
                        continue;
                    }
                }
                if (c10 == 'v' && (ix2 = ConstraintParser.startsWithLenient(part, new String[]{"visualpadding", "vp"}, new int[]{3, 2}, true)) > -1) {
                    UnitValue[] p11 = ConstraintParser.parseInsets(part.substring(ix2).trim(), false);
                    cc2.setVisualPadding(new UnitValue[]{p11[0], p11.length > 1 ? p11[1] : null, p11.length > 2 ? p11[2] : null, p11.length > 3 ? p11[3] : null});
                    continue;
                }
                UnitValue horAlign = ConstraintParser.parseAlignKeywords(part, true);
                if (horAlign != null) {
                    cc2.getHorizontal().setAlign(horAlign);
                    continue;
                }
                UnitValue verAlign = ConstraintParser.parseAlignKeywords(part, false);
                if (verAlign != null) {
                    cc2.getVertical().setAlign(verAlign);
                    continue;
                }
                throw new IllegalArgumentException("Unknown keyword.");
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException("Error parsing Constraint: '" + part + "'", ex2);
            }
        }
        return cc2;
    }

    public static UnitValue[] parseInsets(String s10, boolean acceptPanel) {
        if (s10.length() == 0 || s10.equals("dialog") || s10.equals("panel")) {
            if (!acceptPanel) {
                throw new IllegalArgumentException("Insets now allowed: " + s10 + "\n");
            }
            boolean isPanel = s10.startsWith("p");
            UnitValue[] ins = new UnitValue[4];
            for (int j10 = 0; j10 < 4; ++j10) {
                ins[j10] = isPanel ? PlatformDefaults.getPanelInsets(j10) : PlatformDefaults.getDialogInsets(j10);
            }
            return ins;
        }
        String[] insS = ConstraintParser.toTrimmedTokens(s10, ' ');
        UnitValue[] ins = new UnitValue[4];
        for (int j11 = 0; j11 < 4; ++j11) {
            UnitValue insSz = ConstraintParser.parseUnitValue(insS[j11 < insS.length ? j11 : insS.length - 1], UnitValue.ZERO, j11 % 2 == 1);
            ins[j11] = insSz != null ? insSz : PlatformDefaults.getPanelInsets(j11);
        }
        return ins;
    }

    private static BoundSize[] parseGaps(String s10) {
        BoundSize[] ret = new BoundSize[4];
        int ix2 = ConstraintParser.startsWithLenient(s10, "gaptop", -1, true);
        if (ix2 > -1) {
            s10 = s10.substring(ix2).trim();
            ret[0] = ConstraintParser.parseBoundSize(s10, true, false);
            return ret;
        }
        ix2 = ConstraintParser.startsWithLenient(s10, "gapleft", -1, true);
        if (ix2 > -1) {
            s10 = s10.substring(ix2).trim();
            ret[1] = ConstraintParser.parseBoundSize(s10, true, true);
            return ret;
        }
        ix2 = ConstraintParser.startsWithLenient(s10, "gapbottom", -1, true);
        if (ix2 > -1) {
            s10 = s10.substring(ix2).trim();
            ret[2] = ConstraintParser.parseBoundSize(s10, true, false);
            return ret;
        }
        ix2 = ConstraintParser.startsWithLenient(s10, "gapright", -1, true);
        if (ix2 > -1) {
            s10 = s10.substring(ix2).trim();
            ret[3] = ConstraintParser.parseBoundSize(s10, true, true);
            return ret;
        }
        ix2 = ConstraintParser.startsWithLenient(s10, "gapbefore", -1, true);
        if (ix2 > -1) {
            s10 = s10.substring(ix2).trim();
            ret[1] = ConstraintParser.parseBoundSize(s10, true, true);
            return ret;
        }
        ix2 = ConstraintParser.startsWithLenient(s10, "gapafter", -1, true);
        if (ix2 > -1) {
            s10 = s10.substring(ix2).trim();
            ret[3] = ConstraintParser.parseBoundSize(s10, true, true);
            return ret;
        }
        ix2 = ConstraintParser.startsWithLenient(s10, new String[]{"gapx", "gapy"}, null, true);
        if (ix2 > -1) {
            boolean x10 = s10.charAt(3) == 'x';
            String[] gaps = ConstraintParser.toTrimmedTokens(s10.substring(ix2).trim(), ' ');
            ret[x10 ? 1 : 0] = ConstraintParser.parseBoundSize(gaps[0], true, x10);
            if (gaps.length > 1) {
                ret[x10 ? 3 : 2] = ConstraintParser.parseBoundSize(gaps[1], true, !x10);
            }
            return ret;
        }
        ix2 = ConstraintParser.startsWithLenient(s10, "gap ", 1, true);
        if (ix2 > -1) {
            String[] gaps = ConstraintParser.toTrimmedTokens(s10.substring(ix2).trim(), ' ');
            ret[1] = ConstraintParser.parseBoundSize(gaps[0], true, true);
            if (gaps.length > 1) {
                ret[3] = ConstraintParser.parseBoundSize(gaps[1], true, false);
                if (gaps.length > 2) {
                    ret[0] = ConstraintParser.parseBoundSize(gaps[2], true, true);
                    if (gaps.length > 3) {
                        ret[2] = ConstraintParser.parseBoundSize(gaps[3], true, false);
                    }
                }
            }
            return ret;
        }
        throw new IllegalArgumentException("Unknown Gap part: '" + s10 + "'");
    }

    private static int parseSpan(String s10) {
        return s10.length() > 0 ? Integer.parseInt(s10) : 2097051;
    }

    private static Float parseFloat(String s10, Float nullVal) {
        return s10.length() > 0 ? new Float(Float.parseFloat(s10)) : nullVal;
    }

    public static BoundSize parseBoundSize(String s10, boolean isGap, boolean isHor) {
        if (s10.length() == 0 || s10.equals("null") || s10.equals("n")) {
            return null;
        }
        String cs2 = s10;
        boolean push = false;
        if (s10.endsWith("push")) {
            push = true;
            int l10 = s10.length();
            if ((s10 = s10.substring(0, l10 - (s10.endsWith(":push") ? 5 : 4))).length() == 0) {
                return new BoundSize(null, null, null, true, cs2);
            }
        }
        String[] sizes = ConstraintParser.toTrimmedTokens(s10, ':');
        String s02 = sizes[0];
        if (sizes.length == 1) {
            boolean hasEM = s02.endsWith("!");
            if (hasEM) {
                s02 = s02.substring(0, s02.length() - 1);
            }
            UnitValue uv2 = ConstraintParser.parseUnitValue(s02, null, isHor);
            return new BoundSize(isGap || hasEM ? uv2 : null, uv2, hasEM ? uv2 : null, push, cs2);
        }
        if (sizes.length == 2) {
            return new BoundSize(ConstraintParser.parseUnitValue(s02, null, isHor), ConstraintParser.parseUnitValue(sizes[1], null, isHor), null, push, cs2);
        }
        if (sizes.length == 3) {
            return new BoundSize(ConstraintParser.parseUnitValue(s02, null, isHor), ConstraintParser.parseUnitValue(sizes[1], null, isHor), ConstraintParser.parseUnitValue(sizes[2], null, isHor), push, cs2);
        }
        throw new IllegalArgumentException("Min:Preferred:Max size section must contain 0, 1 or 2 colons. '" + cs2 + "'");
    }

    public static UnitValue parseUnitValueOrAlign(String s10, boolean isHor, UnitValue emptyReplacement) {
        if (s10.length() == 0) {
            return emptyReplacement;
        }
        UnitValue align = ConstraintParser.parseAlignKeywords(s10, isHor);
        if (align != null) {
            return align;
        }
        return ConstraintParser.parseUnitValue(s10, emptyReplacement, isHor);
    }

    public static UnitValue parseUnitValue(String s10, boolean isHor) {
        return ConstraintParser.parseUnitValue(s10, null, isHor);
    }

    private static UnitValue parseUnitValue(String s10, UnitValue emptyReplacement, boolean isHor) {
        boolean inline;
        if (s10 == null || s10.length() == 0) {
            return emptyReplacement;
        }
        String cs2 = s10;
        char c02 = s10.charAt(0);
        if (c02 == '(' && s10.charAt(s10.length() - 1) == ')') {
            s10 = s10.substring(1, s10.length() - 1);
        }
        if (c02 == 'n' && (s10.equals("null") || s10.equals("n"))) {
            return null;
        }
        if (c02 == 'i' && s10.equals("inf")) {
            return UnitValue.INF;
        }
        int oper = ConstraintParser.getOper(s10);
        boolean bl2 = inline = oper == 101 || oper == 102 || oper == 103 || oper == 104;
        if (oper != 100) {
            String[] uvs;
            if (!inline) {
                String sub = s10.substring(4, s10.length() - 1).trim();
                uvs = ConstraintParser.toTrimmedTokens(sub, ',');
                if (uvs.length == 1) {
                    return ConstraintParser.parseUnitValue(sub, null, isHor);
                }
            } else {
                int delim = oper == 101 ? 43 : (oper == 102 ? 45 : (oper == 103 ? 42 : 47));
                uvs = ConstraintParser.toTrimmedTokens(s10, (char)delim);
                if (uvs.length > 2) {
                    String last = uvs[uvs.length - 1];
                    String first = s10.substring(0, s10.length() - last.length() - 1);
                    uvs = new String[]{first, last};
                }
            }
            if (uvs.length != 2) {
                throw new IllegalArgumentException("Malformed UnitValue: '" + s10 + "'");
            }
            UnitValue sub1 = ConstraintParser.parseUnitValue(uvs[0], null, isHor);
            UnitValue sub2 = ConstraintParser.parseUnitValue(uvs[1], null, isHor);
            if (sub1 == null || sub2 == null) {
                throw new IllegalArgumentException("Malformed UnitValue. Must be two sub-values: '" + s10 + "'");
            }
            return new UnitValue(isHor, oper, sub1, sub2, cs2);
        }
        try {
            String[] numParts = ConstraintParser.getNumTextParts(s10);
            float value = numParts[0].length() > 0 ? Float.parseFloat(numParts[0]) : 1.0f;
            return new UnitValue(value, numParts[1], isHor, oper, cs2);
        }
        catch (Exception e10) {
            throw new IllegalArgumentException("Malformed UnitValue: '" + s10 + "'", e10);
        }
    }

    static UnitValue parseAlignKeywords(String s10, boolean isHor) {
        if (ConstraintParser.startsWithLenient(s10, "center", 1, false) != -1) {
            return UnitValue.CENTER;
        }
        if (isHor) {
            if (ConstraintParser.startsWithLenient(s10, "left", 1, false) != -1) {
                return UnitValue.LEFT;
            }
            if (ConstraintParser.startsWithLenient(s10, "right", 1, false) != -1) {
                return UnitValue.RIGHT;
            }
            if (ConstraintParser.startsWithLenient(s10, "leading", 4, false) != -1) {
                return UnitValue.LEADING;
            }
            if (ConstraintParser.startsWithLenient(s10, "trailing", 5, false) != -1) {
                return UnitValue.TRAILING;
            }
            if (ConstraintParser.startsWithLenient(s10, "label", 5, false) != -1) {
                return UnitValue.LABEL;
            }
        } else {
            if (ConstraintParser.startsWithLenient(s10, "baseline", 4, false) != -1) {
                return UnitValue.BASELINE_IDENTITY;
            }
            if (ConstraintParser.startsWithLenient(s10, "top", 1, false) != -1) {
                return UnitValue.TOP;
            }
            if (ConstraintParser.startsWithLenient(s10, "bottom", 1, false) != -1) {
                return UnitValue.BOTTOM;
            }
        }
        return null;
    }

    private static String[] getNumTextParts(String s10) {
        int iSz = s10.length();
        for (int i10 = 0; i10 < iSz; ++i10) {
            char c10 = s10.charAt(i10);
            if (c10 == ' ') {
                throw new IllegalArgumentException("Space in UnitValue: '" + s10 + "'");
            }
            if (c10 >= '0' && c10 <= '9' || c10 == '.' || c10 == '-') continue;
            return new String[]{s10.substring(0, i10).trim(), s10.substring(i10).trim()};
        }
        return new String[]{s10, ""};
    }

    private static int getOper(String s10) {
        int len = s10.length();
        if (len < 3) {
            return 100;
        }
        if (len > 5 && s10.charAt(3) == '(' && s10.charAt(len - 1) == ')') {
            if (s10.startsWith("min(")) {
                return 105;
            }
            if (s10.startsWith("max(")) {
                return 106;
            }
            if (s10.startsWith("mid(")) {
                return 107;
            }
        }
        for (int j10 = 0; j10 < 2; ++j10) {
            int p10 = 0;
            for (int i10 = len - 1; i10 > 0; --i10) {
                char c10 = s10.charAt(i10);
                if (c10 == ')') {
                    ++p10;
                    continue;
                }
                if (c10 == '(') {
                    --p10;
                    continue;
                }
                if (p10 != 0) continue;
                if (j10 == 0) {
                    if (c10 == '+') {
                        return 101;
                    }
                    if (c10 != '-') continue;
                    return 102;
                }
                if (c10 == '*') {
                    return 103;
                }
                if (c10 != '/') continue;
                return 104;
            }
        }
        return 100;
    }

    private static int startsWithLenient(String s10, String[] matches, int[] minChars, boolean acceptTrailing) {
        for (int i10 = 0; i10 < matches.length; ++i10) {
            int minChar = minChars != null ? minChars[i10] : -1;
            int ix2 = ConstraintParser.startsWithLenient(s10, matches[i10], minChar, acceptTrailing);
            if (ix2 <= -1) continue;
            return ix2;
        }
        return -1;
    }

    private static int startsWithLenient(String s10, String match, int minChars, boolean acceptTrailing) {
        int sSz;
        if (s10.charAt(0) != match.charAt(0)) {
            return -1;
        }
        if (minChars == -1) {
            minChars = match.length();
        }
        if ((sSz = s10.length()) < minChars) {
            return -1;
        }
        int mSz = match.length();
        int sIx = 0;
        for (int mIx = 0; mIx < mSz; ++mIx) {
            while (sIx < sSz && (s10.charAt(sIx) == ' ' || s10.charAt(sIx) == '_')) {
                ++sIx;
            }
            if (sIx >= sSz || s10.charAt(sIx) != match.charAt(mIx)) {
                return !(mIx < minChars || !acceptTrailing && sIx < sSz || sIx < sSz && s10.charAt(sIx - 1) != ' ') ? sIx : -1;
            }
            ++sIx;
        }
        return sIx >= sSz || acceptTrailing || s10.charAt(sIx) == ' ' ? sIx : -1;
    }

    private static String[] toTrimmedTokens(String s10, char sep) {
        int toks = 0;
        int sSize = s10.length();
        boolean disregardDoubles = sep == ' ';
        int p10 = 0;
        for (int i10 = 0; i10 < sSize; ++i10) {
            char c10 = s10.charAt(i10);
            if (c10 == '(') {
                ++p10;
            } else if (c10 == ')') {
                --p10;
            } else if (p10 == 0 && c10 == sep) {
                ++toks;
                while (disregardDoubles && i10 < sSize - 1 && s10.charAt(i10 + 1) == ' ') {
                    ++i10;
                }
            }
            if (p10 >= 0) continue;
            throw new IllegalArgumentException("Unbalanced parentheses: '" + s10 + "'");
        }
        if (p10 != 0) {
            throw new IllegalArgumentException("Unbalanced parentheses: '" + s10 + "'");
        }
        if (toks == 0) {
            return new String[]{s10.trim()};
        }
        String[] retArr = new String[toks + 1];
        int st2 = 0;
        int pNr = 0;
        p10 = 0;
        for (int i11 = 0; i11 < sSize; ++i11) {
            char c11 = s10.charAt(i11);
            if (c11 == '(') {
                ++p10;
                continue;
            }
            if (c11 == ')') {
                --p10;
                continue;
            }
            if (p10 != 0 || c11 != sep) continue;
            retArr[pNr++] = s10.substring(st2, i11).trim();
            st2 = i11 + 1;
            while (disregardDoubles && i11 < sSize - 1 && s10.charAt(i11 + 1) == ' ') {
                ++i11;
            }
        }
        retArr[pNr++] = s10.substring(st2, sSize).trim();
        return retArr;
    }

    private static ArrayList<String> getRowColAndGapsTrimmed(String s10) {
        if (s10.indexOf(124) != -1) {
            s10 = s10.replaceAll("\\|", "][");
        }
        ArrayList<String> retList = new ArrayList<String>(Math.max(s10.length() >> 3, 3));
        int s02 = 0;
        int s12 = 0;
        int st2 = 0;
        int iSz = s10.length();
        for (int i10 = 0; i10 < iSz; ++i10) {
            char c10 = s10.charAt(i10);
            if (c10 == '[') {
                ++s02;
            } else {
                if (c10 != ']') continue;
                ++s12;
            }
            if (s02 != s12 && s02 - 1 != s12) break;
            retList.add(s10.substring(st2, i10).trim());
            st2 = i10 + 1;
        }
        if (s02 != s12) {
            throw new IllegalArgumentException("'[' and ']' mismatch in row/column format string: " + s10);
        }
        if (s02 == 0) {
            retList.add("");
            retList.add(s10);
            retList.add("");
        } else if (retList.size() % 2 == 0) {
            retList.add(s10.substring(st2, s10.length()));
        }
        return retList;
    }

    public static String prepare(String s10) {
        return s10 != null ? s10.trim().toLowerCase() : "";
    }
}

