/*
 * Decompiled with CFR 0.152.
 */
package net.miginfocom.layout;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.WeakHashMap;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.BoundSize;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.ComponentWrapper;
import net.miginfocom.layout.ContainerWrapper;
import net.miginfocom.layout.DimConstraint;
import net.miginfocom.layout.LC;
import net.miginfocom.layout.LayoutCallback;
import net.miginfocom.layout.LayoutUtil;
import net.miginfocom.layout.LinkHandler;
import net.miginfocom.layout.PlatformDefaults;
import net.miginfocom.layout.ResizeConstraint;
import net.miginfocom.layout.UnitValue;

public final class Grid {
    public static final boolean TEST_GAPS = true;
    private static final Float[] GROW_100 = new Float[]{ResizeConstraint.WEIGHT_100};
    private static final DimConstraint DOCK_DIM_CONSTRAINT = new DimConstraint();
    private static final int MAX_GRID = 30000;
    private static final int MAX_DOCK_GRID = Short.MAX_VALUE;
    private static final ResizeConstraint GAP_RC_CONST;
    private static final ResizeConstraint GAP_RC_CONST_PUSH;
    private static final CC DEF_CC;
    private final LC lc;
    private final ContainerWrapper container;
    private final LinkedHashMap<Integer, Cell> grid = new LinkedHashMap();
    private HashMap<Integer, BoundSize> wrapGapMap = null;
    private final TreeSet<Integer> rowIndexes = new TreeSet();
    private final TreeSet<Integer> colIndexes = new TreeSet();
    private final AC rowConstr;
    private final AC colConstr;
    private FlowSizeSpec colFlowSpecs = null;
    private FlowSizeSpec rowFlowSpecs = null;
    private final ArrayList<LinkedDimGroup>[] colGroupLists;
    private final ArrayList<LinkedDimGroup>[] rowGroupLists;
    private int[] width = null;
    private int[] height = null;
    private ArrayList<int[]> debugRects = null;
    private HashMap<String, Boolean> linkTargetIDs = null;
    private final int dockOffY;
    private final int dockOffX;
    private final Float[] pushXs;
    private final Float[] pushYs;
    private final ArrayList<LayoutCallback> callbackList;
    private int lastRefWidth = 0;
    private int lastRefHeight = 0;
    private static WeakHashMap<Object, int[][]>[] PARENT_ROWCOL_SIZES_MAP;
    private static WeakHashMap<Object, ArrayList<WeakCell>> PARENT_GRIDPOS_MAP;

    public Grid(ContainerWrapper container, LC lc2, AC rowConstr, AC colConstr, Map<? extends ComponentWrapper, CC> ccMap, ArrayList<LayoutCallback> callbackList) {
        this.lc = lc2;
        this.rowConstr = rowConstr;
        this.colConstr = colConstr;
        this.container = container;
        this.callbackList = callbackList;
        int wrap = lc2.getWrapAfter() != 0 ? lc2.getWrapAfter() : (lc2.isFlowX() ? colConstr : rowConstr).getConstaints().length;
        boolean useVisualPadding = lc2.isVisualPadding();
        ComponentWrapper[] comps = container.getComponents();
        boolean hasTagged = false;
        boolean hasPushX = false;
        boolean hasPushY = false;
        boolean hitEndOfRow = false;
        int[] cellXY = new int[2];
        ArrayList<int[]> spannedRects = new ArrayList<int[]>(2);
        Object[] specs = (lc2.isFlowX() ? rowConstr : colConstr).getConstaints();
        int sizeGroupsX = 0;
        int sizeGroupsY = 0;
        int[] dockInsets = null;
        LinkHandler.clearTemporaryBounds(container.getLayout());
        int i10 = 0;
        while (i10 < comps.length) {
            boolean spanRestOfRow;
            Cell cell;
            int hideMode;
            ComponentWrapper comp = comps[i10];
            CC rootCc = Grid.getCC(comp, ccMap);
            this.addLinkIDs(rootCc);
            int n10 = comp.isVisible() ? -1 : (hideMode = rootCc.getHideMode() != -1 ? rootCc.getHideMode() : lc2.getHideMode());
            if (hideMode == 3) {
                this.setLinkedBounds(comp, rootCc, comp.getX(), comp.getY(), comp.getWidth(), comp.getHeight(), rootCc.isExternal());
                ++i10;
                continue;
            }
            if (rootCc.getHorizontal().getSizeGroup() != null) {
                ++sizeGroupsX;
            }
            if (rootCc.getVertical().getSizeGroup() != null) {
                ++sizeGroupsY;
            }
            if (this.getPos(comp, rootCc) != null || rootCc.isExternal()) {
                CompWrap cw2 = new CompWrap(comp, rootCc, hideMode, useVisualPadding);
                cell = this.grid.get(null);
                if (cell == null) {
                    this.grid.put(null, new Cell(cw2));
                } else {
                    cell.compWraps.add(cw2);
                }
                if (!rootCc.isBoundsInGrid() || rootCc.isExternal()) {
                    this.setLinkedBounds(comp, rootCc, comp.getX(), comp.getY(), comp.getWidth(), comp.getHeight(), rootCc.isExternal());
                    ++i10;
                    continue;
                }
            }
            if (rootCc.getDockSide() != -1) {
                if (dockInsets == null) {
                    dockInsets = new int[]{-32767, -32767, Short.MAX_VALUE, Short.MAX_VALUE};
                }
                this.addDockingCell(dockInsets, rootCc.getDockSide(), new CompWrap(comp, rootCc, hideMode, useVisualPadding));
                ++i10;
                continue;
            }
            Boolean cellFlowX = rootCc.getFlowX();
            cell = null;
            if (rootCc.isNewline()) {
                this.wrap(cellXY, rootCc.getNewlineGapSize());
            } else if (hitEndOfRow) {
                this.wrap(cellXY, null);
            }
            hitEndOfRow = false;
            boolean isRowInGridMode = !lc2.isNoGrid() && !((DimConstraint)LayoutUtil.getIndexSafe(specs, lc2.isFlowX() ? cellXY[1] : cellXY[0])).isNoGrid();
            int cx2 = rootCc.getCellX();
            int cy2 = rootCc.getCellY();
            if ((cx2 < 0 || cy2 < 0) && isRowInGridMode && rootCc.getSkip() == 0) {
                while (!this.isCellFree(cellXY[1], cellXY[0], spannedRects)) {
                    if (Math.abs(this.increase(cellXY, 1)) < wrap) continue;
                    this.wrap(cellXY, null);
                }
            } else {
                if (cx2 >= 0 && cy2 >= 0) {
                    if (cy2 >= 0) {
                        cellXY[0] = cx2;
                        cellXY[1] = cy2;
                    } else if (lc2.isFlowX()) {
                        cellXY[0] = cx2;
                    } else {
                        cellXY[1] = cx2;
                    }
                    this.ensureIndexSizes(cx2, cy2);
                }
                cell = this.getCell(cellXY[1], cellXY[0]);
            }
            int skipCount = rootCc.getSkip();
            for (int s10 = 0; s10 < skipCount; ++s10) {
                do {
                    if (Math.abs(this.increase(cellXY, 1)) < wrap) continue;
                    this.wrap(cellXY, null);
                } while (!this.isCellFree(cellXY[1], cellXY[0], spannedRects));
            }
            if (cell == null) {
                int spanx = Math.min(!isRowInGridMode && lc2.isFlowX() ? 2097051 : rootCc.getSpanX(), 30000 - cellXY[0]);
                int spany = Math.min(!isRowInGridMode && !lc2.isFlowX() ? 2097051 : rootCc.getSpanY(), 30000 - cellXY[1]);
                cell = new Cell(spanx, spany, cellFlowX != null ? cellFlowX.booleanValue() : lc2.isFlowX());
                this.setCell(cellXY[1], cellXY[0], cell);
                if (spanx > 1 || spany > 1) {
                    spannedRects.add(new int[]{cellXY[0], cellXY[1], spanx, spany});
                }
            }
            boolean wrapHandled = false;
            boolean splitExit = false;
            boolean bl2 = spanRestOfRow = (lc2.isFlowX() ? rootCc.getSpanX() : rootCc.getSpanY()) == 2097051;
            for (int splitLeft = isRowInGridMode ? rootCc.getSplit() - 1 : 2097051; splitLeft >= 0 && i10 < comps.length; --splitLeft) {
                ComponentWrapper compAdd = comps[i10];
                CC cc2 = Grid.getCC(compAdd, ccMap);
                this.addLinkIDs(cc2);
                boolean visible = compAdd.isVisible();
                int n11 = visible ? -1 : (hideMode = cc2.getHideMode() != -1 ? cc2.getHideMode() : lc2.getHideMode());
                if (cc2.isExternal() || hideMode == 3) {
                    ++i10;
                    ++splitLeft;
                    continue;
                }
                hasPushX |= (visible || hideMode > 1) && cc2.getPushX() != null;
                hasPushY |= (visible || hideMode > 1) && cc2.getPushY() != null;
                if (cc2 != rootCc) {
                    if (cc2.isNewline() || !cc2.isBoundsInGrid() || cc2.getDockSide() != -1) break;
                    if (splitLeft > 0 && cc2.getSkip() > 0) {
                        splitExit = true;
                        break;
                    }
                }
                CompWrap cw3 = new CompWrap(compAdd, cc2, hideMode, useVisualPadding);
                cell.compWraps.add(cw3);
                Cell cell2 = cell;
                cell2.hasTagged = cell2.hasTagged | cc2.getTag() != null;
                hasTagged |= cell.hasTagged;
                if (cc2 != rootCc) {
                    if (cc2.getHorizontal().getSizeGroup() != null) {
                        ++sizeGroupsX;
                    }
                    if (cc2.getVertical().getSizeGroup() != null) {
                        ++sizeGroupsY;
                    }
                }
                ++i10;
                if (!cc2.isWrap() && (!spanRestOfRow || splitLeft != 0)) continue;
                if (cc2.isWrap()) {
                    this.wrap(cellXY, cc2.getWrapGapSize());
                } else {
                    hitEndOfRow = true;
                }
                wrapHandled = true;
                break;
            }
            if (wrapHandled || !isRowInGridMode) continue;
            int span = lc2.isFlowX() ? cell.spanx : cell.spany;
            if (Math.abs(lc2.isFlowX() ? cellXY[0] : cellXY[1]) + span >= wrap) {
                hitEndOfRow = true;
                continue;
            }
            this.increase(cellXY, splitExit ? span - 1 : span);
        }
        if (sizeGroupsX > 0 || sizeGroupsY > 0) {
            HashMap<String, int[]> sizeGroupMapX = sizeGroupsX > 0 ? new HashMap<String, int[]>(sizeGroupsX) : null;
            HashMap<String, int[]> sizeGroupMapY = sizeGroupsY > 0 ? new HashMap<String, int[]>(sizeGroupsY) : null;
            ArrayList<CompWrap> sizeGroupCWs = new ArrayList<CompWrap>(Math.max(sizeGroupsX, sizeGroupsY));
            for (Cell cell : this.grid.values()) {
                for (int i11 = 0; i11 < cell.compWraps.size(); ++i11) {
                    CompWrap cw4 = (CompWrap)cell.compWraps.get(i11);
                    String sgx = cw4.cc.getHorizontal().getSizeGroup();
                    String sgy = cw4.cc.getVertical().getSizeGroup();
                    if (sgx == null && sgy == null) continue;
                    if (sgx != null && sizeGroupMapX != null) {
                        Grid.addToSizeGroup(sizeGroupMapX, sgx, cw4.getSizes(true));
                    }
                    if (sgy != null && sizeGroupMapY != null) {
                        Grid.addToSizeGroup(sizeGroupMapY, sgy, cw4.getSizes(false));
                    }
                    sizeGroupCWs.add(cw4);
                }
            }
            for (CompWrap cw2 : sizeGroupCWs) {
                if (sizeGroupMapX != null) {
                    cw2.setForcedSizes((int[])sizeGroupMapX.get(cw2.cc.getHorizontal().getSizeGroup()), true);
                }
                if (sizeGroupMapY == null) continue;
                cw2.setForcedSizes((int[])sizeGroupMapY.get(cw2.cc.getVertical().getSizeGroup()), false);
            }
        }
        if (hasTagged) {
            Grid.sortCellsByPlatform(this.grid.values(), container);
        }
        boolean ltr = LayoutUtil.isLeftToRight(lc2, container);
        for (Cell cell : this.grid.values()) {
            ArrayList cws = cell.compWraps;
            int lastI = cws.size() - 1;
            for (int i12 = 0; i12 <= lastI; ++i12) {
                CompWrap cw5 = (CompWrap)cws.get(i12);
                ComponentWrapper cwBef = i12 > 0 ? ((CompWrap)cws.get(i12 - 1)).comp : null;
                ComponentWrapper cwAft = i12 < lastI ? ((CompWrap)cws.get(i12 + 1)).comp : null;
                String tag = Grid.getCC(cw5.comp, ccMap).getTag();
                CC ccBef = cwBef != null ? Grid.getCC(cwBef, ccMap) : null;
                CC ccAft = cwAft != null ? Grid.getCC(cwAft, ccMap) : null;
                cw5.calcGaps(cwBef, ccBef, cwAft, ccAft, tag, cell.flowx, ltr);
            }
        }
        this.dockOffX = Grid.getDockInsets(this.colIndexes);
        this.dockOffY = Grid.getDockInsets(this.rowIndexes);
        this.ensureIndexSizes(colConstr.getCount(), rowConstr.getCount());
        this.colGroupLists = this.divideIntoLinkedGroups(false);
        this.rowGroupLists = this.divideIntoLinkedGroups(true);
        this.pushXs = hasPushX || lc2.isFillX() ? this.getDefaultPushWeights(false) : null;
        Object object = this.pushYs = hasPushY || lc2.isFillY() ? this.getDefaultPushWeights(true) : null;
        if (LayoutUtil.isDesignTime(container)) {
            Grid.saveGrid(container, this.grid);
        }
    }

    private void ensureIndexSizes(int colCount, int rowCount) {
        int i10;
        for (i10 = 0; i10 < colCount; ++i10) {
            this.colIndexes.add(i10);
        }
        for (i10 = 0; i10 < rowCount; ++i10) {
            this.rowIndexes.add(i10);
        }
    }

    private static CC getCC(ComponentWrapper comp, Map<? extends ComponentWrapper, CC> ccMap) {
        CC cc2 = ccMap.get(comp);
        return cc2 != null ? cc2 : DEF_CC;
    }

    private void addLinkIDs(CC cc2) {
        String[] linkIDs;
        for (String linkID : linkIDs = cc2.getLinkTargets()) {
            if (this.linkTargetIDs == null) {
                this.linkTargetIDs = new HashMap();
            }
            this.linkTargetIDs.put(linkID, null);
        }
    }

    public void invalidateContainerSize() {
        this.colFlowSpecs = null;
        this.invalidateComponentSizes();
    }

    private void invalidateComponentSizes() {
        for (Cell cell : this.grid.values()) {
            for (CompWrap compWrap : cell.compWraps) {
                compWrap.invalidateSizes();
            }
        }
    }

    public boolean layout(int[] bounds, UnitValue alignX, UnitValue alignY, boolean debug, boolean notUsed) {
        return this.layoutImpl(bounds, alignX, alignY, debug, false);
    }

    public boolean layout(int[] bounds, UnitValue alignX, UnitValue alignY, boolean debug) {
        return this.layoutImpl(bounds, alignX, alignY, debug, false);
    }

    private boolean layoutImpl(int[] bounds, UnitValue alignX, UnitValue alignY, boolean debug, boolean trialRun) {
        if (debug) {
            this.debugRects = new ArrayList();
        }
        if (this.colFlowSpecs == null) {
            this.checkSizeCalcs(bounds[2], bounds[3]);
        }
        this.resetLinkValues(true, true);
        this.layoutInOneDim(bounds[2], alignX, false, this.pushXs);
        this.layoutInOneDim(bounds[3], alignY, true, this.pushYs);
        HashMap<String, Integer> endGrpXMap = null;
        HashMap<String, Integer> endGrpYMap = null;
        int compCount = this.container.getComponentCount();
        boolean addVisualPadding = this.lc.isVisualPadding();
        boolean layoutAgain = false;
        if (compCount > 0) {
            block0: for (int j10 = 0; j10 < (this.linkTargetIDs != null ? 2 : 1); ++j10) {
                boolean doAgain;
                int count = 0;
                do {
                    doAgain = false;
                    for (Cell cell : this.grid.values()) {
                        for (CompWrap cw2 : cell.compWraps) {
                            if (j10 == 0) {
                                if (!(doAgain |= this.doAbsoluteCorrections(cw2, bounds))) {
                                    if (cw2.cc.getHorizontal().getEndGroup() != null) {
                                        endGrpXMap = Grid.addToEndGroup(endGrpXMap, cw2.cc.getHorizontal().getEndGroup(), cw2.x + cw2.w);
                                    }
                                    if (cw2.cc.getVertical().getEndGroup() != null) {
                                        endGrpYMap = Grid.addToEndGroup(endGrpYMap, cw2.cc.getVertical().getEndGroup(), cw2.y + cw2.h);
                                    }
                                }
                                if (this.linkTargetIDs != null && (this.linkTargetIDs.containsKey("visual") || this.linkTargetIDs.containsKey("container"))) {
                                    layoutAgain = true;
                                }
                            }
                            if (this.linkTargetIDs != null && j10 != 1) continue;
                            if (cw2.cc.getHorizontal().getEndGroup() != null) {
                                cw2.w = (Integer)endGrpXMap.get(cw2.cc.getHorizontal().getEndGroup()) - cw2.x;
                            }
                            if (cw2.cc.getVertical().getEndGroup() != null) {
                                cw2.h = (Integer)endGrpYMap.get(cw2.cc.getVertical().getEndGroup()) - cw2.y;
                            }
                            Object object = cw2;
                            ((CompWrap)object).x = ((CompWrap)object).x + bounds[0];
                            object = cw2;
                            ((CompWrap)object).y = ((CompWrap)object).y + bounds[1];
                            if (!trialRun) {
                                cw2.transferBounds(addVisualPadding);
                            }
                            if (this.callbackList == null) continue;
                            for (LayoutCallback callback : this.callbackList) {
                                callback.correctBounds(cw2.comp);
                            }
                        }
                    }
                    this.clearGroupLinkBounds();
                    if (++count <= (compCount << 3) + 10) continue;
                    System.err.println("Unstable cyclic dependency in absolute linked values.");
                    continue block0;
                } while (doAgain);
            }
        }
        if (debug) {
            for (Cell cell : this.grid.values()) {
                ArrayList compWraps = cell.compWraps;
                for (CompWrap cw3 : compWraps) {
                    LinkedDimGroup hGrp = Grid.getGroupContaining(this.colGroupLists, cw3);
                    LinkedDimGroup vGrp = Grid.getGroupContaining(this.rowGroupLists, cw3);
                    if (hGrp == null || vGrp == null) continue;
                    this.debugRects.add(new int[]{hGrp.lStart + bounds[0] - (hGrp.fromEnd ? hGrp.lSize : 0), vGrp.lStart + bounds[1] - (vGrp.fromEnd ? vGrp.lSize : 0), hGrp.lSize, vGrp.lSize});
                }
            }
        }
        return layoutAgain;
    }

    public void paintDebug() {
        if (this.debugRects != null) {
            this.container.paintDebugOutline(this.lc.isVisualPadding());
            ArrayList<int[]> painted = new ArrayList<int[]>();
            for (int[] r10 : this.debugRects) {
                if (painted.contains(r10)) continue;
                this.container.paintDebugCell(r10[0], r10[1], r10[2], r10[3]);
                painted.add(r10);
            }
            for (Cell cell : this.grid.values()) {
                ArrayList compWraps = cell.compWraps;
                for (CompWrap compWrap : compWraps) {
                    compWrap.comp.paintDebugOutline(this.lc.isVisualPadding());
                }
            }
        }
    }

    public ContainerWrapper getContainer() {
        return this.container;
    }

    public final int[] getWidth() {
        return this.getWidth(this.lastRefHeight);
    }

    public final int[] getWidth(int refHeight) {
        this.checkSizeCalcs(this.lastRefWidth, refHeight);
        return (int[])this.width.clone();
    }

    public final int[] getHeight() {
        return this.getHeight(this.lastRefWidth);
    }

    public final int[] getHeight(int refWidth) {
        this.checkSizeCalcs(refWidth, this.lastRefHeight);
        return (int[])this.height.clone();
    }

    private void checkSizeCalcs(int refWidth, int refHeight) {
        if (this.colFlowSpecs == null) {
            this.calcGridSizes(refWidth, refHeight);
        }
        if (refWidth > 0 && refWidth != this.lastRefWidth || refHeight > 0 && refHeight != this.lastRefHeight) {
            int[] refBounds = new int[]{0, 0, refWidth > 0 ? refWidth : this.width[1], refHeight > 0 ? refHeight : this.height[1]};
            this.layoutImpl(refBounds, null, null, false, true);
            this.calcGridSizes(refWidth, refHeight);
        }
        this.lastRefWidth = refWidth;
        this.lastRefHeight = refHeight;
    }

    private void calcGridSizes(int refWidth, int refHeight) {
        FlowSizeSpec colSpecs = this.calcRowsOrColsSizes(true, refWidth);
        FlowSizeSpec rowSpecs = this.calcRowsOrColsSizes(false, refHeight);
        this.colFlowSpecs = colSpecs;
        this.rowFlowSpecs = rowSpecs;
        this.width = this.getMinPrefMaxSumSize(true, colSpecs.sizes);
        this.height = this.getMinPrefMaxSumSize(false, rowSpecs.sizes);
        if (this.linkTargetIDs == null) {
            this.resetLinkValues(false, true);
        } else {
            this.layout(new int[]{0, 0, refWidth, refHeight}, null, null, false);
            this.resetLinkValues(false, false);
        }
        this.adjustSizeForAbsolute(true);
        this.adjustSizeForAbsolute(false);
    }

    private UnitValue[] getPos(ComponentWrapper cw2, CC cc2) {
        UnitValue[] callbackPos = null;
        if (this.callbackList != null) {
            for (int i10 = 0; i10 < this.callbackList.size() && callbackPos == null; ++i10) {
                callbackPos = this.callbackList.get(i10).getPosition(cw2);
            }
        }
        UnitValue[] ccPos = cc2.getPos();
        if (callbackPos == null || ccPos == null) {
            return callbackPos != null ? callbackPos : ccPos;
        }
        for (int i11 = 0; i11 < 4; ++i11) {
            UnitValue cbUv = callbackPos[i11];
            if (cbUv == null) continue;
            ccPos[i11] = cbUv;
        }
        return ccPos;
    }

    private BoundSize[] getCallbackSize(ComponentWrapper cw2) {
        if (this.callbackList != null) {
            for (LayoutCallback callback : this.callbackList) {
                BoundSize[] bs2 = callback.getSize(cw2);
                if (bs2 == null) continue;
                return bs2;
            }
        }
        return null;
    }

    private static int getDockInsets(TreeSet<Integer> set) {
        int c10 = 0;
        for (Integer i10 : set) {
            if (i10 >= -30000) break;
            ++c10;
        }
        return c10;
    }

    private boolean setLinkedBounds(ComponentWrapper cw2, CC cc2, int x10, int y10, int w10, int h10, boolean external) {
        String id2;
        String string = id2 = cc2.getId() != null ? cc2.getId() : cw2.getLinkId();
        if (id2 == null) {
            return false;
        }
        String gid = null;
        int grIx = id2.indexOf(46);
        if (grIx != -1) {
            gid = id2.substring(0, grIx);
            id2 = id2.substring(grIx + 1);
        }
        Object lay = this.container.getLayout();
        boolean changed = false;
        if (external || this.linkTargetIDs != null && this.linkTargetIDs.containsKey(id2)) {
            changed = LinkHandler.setBounds(lay, id2, x10, y10, w10, h10, !external, false);
        }
        if (gid != null && (external || this.linkTargetIDs != null && this.linkTargetIDs.containsKey(gid))) {
            if (this.linkTargetIDs == null) {
                this.linkTargetIDs = new HashMap(4);
            }
            this.linkTargetIDs.put(gid, Boolean.TRUE);
            changed |= LinkHandler.setBounds(lay, gid, x10, y10, w10, h10, !external, true);
        }
        return changed;
    }

    private int increase(int[] p10, int cnt) {
        return this.lc.isFlowX() ? p10[0] + cnt : p10[1] + cnt;
    }

    private void wrap(int[] cellXY, BoundSize gapSize) {
        boolean flowx = this.lc.isFlowX();
        cellXY[0] = flowx ? 0 : cellXY[0] + 1;
        int n10 = cellXY[1] = flowx ? cellXY[1] + 1 : 0;
        if (gapSize != null) {
            if (this.wrapGapMap == null) {
                this.wrapGapMap = new HashMap(8);
            }
            this.wrapGapMap.put(cellXY[flowx ? 1 : 0], gapSize);
        }
        if (flowx) {
            this.rowIndexes.add(cellXY[1]);
        } else {
            this.colIndexes.add(cellXY[0]);
        }
    }

    private static void sortCellsByPlatform(Collection<Cell> cells, ContainerWrapper parent) {
        String order = PlatformDefaults.getButtonOrder();
        String orderLo = order.toLowerCase();
        int unrelSize = PlatformDefaults.convertToPixels(1.0f, "u", true, 0.0f, parent, null);
        if (unrelSize == -87654312) {
            throw new IllegalArgumentException("'unrelated' not recognized by PlatformDefaults!");
        }
        int[] gapUnrel = new int[]{unrelSize, unrelSize, -2147471302};
        int[] flGap = new int[]{0, 0, -2147471302};
        for (Cell cell : cells) {
            if (!cell.hasTagged) continue;
            CompWrap prevCW = null;
            boolean nextUnrel = false;
            boolean nextPush = false;
            ArrayList<CompWrap> sortedList = new ArrayList<CompWrap>(cell.compWraps.size());
            int iSz = orderLo.length();
            for (int i10 = 0; i10 < iSz; ++i10) {
                char c10 = orderLo.charAt(i10);
                if (c10 == '+' || c10 == '_') {
                    nextUnrel = true;
                    if (c10 != '+') continue;
                    nextPush = true;
                    continue;
                }
                String tag = PlatformDefaults.getTagForChar(c10);
                if (tag == null) continue;
                int jSz = cell.compWraps.size();
                for (int j10 = 0; j10 < jSz; ++j10) {
                    CompWrap cw2 = (CompWrap)cell.compWraps.get(j10);
                    if (!tag.equals(cw2.cc.getTag())) continue;
                    if (Character.isUpperCase(order.charAt(i10))) {
                        cw2.adjustMinHorSizeUp((int)PlatformDefaults.getMinimumButtonWidthIncludingPadding(0.0f, parent, cw2.comp));
                    }
                    sortedList.add(cw2);
                    if (nextUnrel) {
                        (prevCW != null ? prevCW : cw2).mergeGapSizes(gapUnrel, cell.flowx, prevCW == null);
                        if (nextPush) {
                            cw2.forcedPushGaps = 1;
                            nextUnrel = false;
                            nextPush = false;
                        }
                    }
                    if (c10 == 'u') {
                        nextUnrel = true;
                    }
                    prevCW = cw2;
                }
            }
            if (sortedList.size() > 0) {
                CompWrap cw3 = (CompWrap)sortedList.get(sortedList.size() - 1);
                if (nextUnrel) {
                    cw3.mergeGapSizes(gapUnrel, cell.flowx, false);
                    if (nextPush) {
                        CompWrap compWrap = cw3;
                        compWrap.forcedPushGaps = compWrap.forcedPushGaps | 2;
                    }
                }
                if (cw3.cc.getHorizontal().getGapAfter() == null) {
                    cw3.setGaps(flGap, 3);
                }
                if ((cw3 = (CompWrap)sortedList.get(0)).cc.getHorizontal().getGapBefore() == null) {
                    cw3.setGaps(flGap, 1);
                }
            }
            if (cell.compWraps.size() == sortedList.size()) {
                cell.compWraps.clear();
            } else {
                cell.compWraps.removeAll(sortedList);
            }
            cell.compWraps.addAll(sortedList);
        }
    }

    private Float[] getDefaultPushWeights(boolean isRows) {
        ArrayList<LinkedDimGroup>[] groupLists = isRows ? this.rowGroupLists : this.colGroupLists;
        Float[] pushWeightArr = GROW_100;
        int i10 = 0;
        int ix2 = 1;
        while (i10 < groupLists.length) {
            ArrayList<LinkedDimGroup> grps = groupLists[i10];
            Float rowPushWeight = null;
            for (LinkedDimGroup grp : grps) {
                for (int c10 = 0; c10 < grp._compWraps.size(); ++c10) {
                    Float pushWeight;
                    int hideMode;
                    CompWrap cw2 = (CompWrap)grp._compWraps.get(c10);
                    int n10 = cw2.comp.isVisible() ? -1 : (hideMode = cw2.cc.getHideMode() != -1 ? cw2.cc.getHideMode() : this.lc.getHideMode());
                    Float f10 = hideMode < 2 ? (isRows ? cw2.cc.getPushY() : cw2.cc.getPushX()) : (pushWeight = null);
                    if (rowPushWeight != null && (pushWeight == null || !(pushWeight.floatValue() > rowPushWeight.floatValue()))) continue;
                    rowPushWeight = pushWeight;
                }
            }
            if (rowPushWeight != null) {
                if (pushWeightArr == GROW_100) {
                    pushWeightArr = new Float[(groupLists.length << 1) + 1];
                }
                pushWeightArr[ix2] = rowPushWeight;
            }
            ++i10;
            ix2 += 2;
        }
        return pushWeightArr;
    }

    private void clearGroupLinkBounds() {
        if (this.linkTargetIDs == null) {
            return;
        }
        for (Map.Entry<String, Boolean> o10 : this.linkTargetIDs.entrySet()) {
            if (o10.getValue() != Boolean.TRUE) continue;
            LinkHandler.clearBounds(this.container.getLayout(), o10.getKey());
        }
    }

    private void resetLinkValues(boolean parentSize, boolean compLinks) {
        Object lay = this.container.getLayout();
        if (compLinks) {
            LinkHandler.clearTemporaryBounds(lay);
        }
        boolean defIns = !this.hasDocks();
        int parW = parentSize ? this.lc.getWidth().constrain(this.container.getWidth(), Grid.getParentSize(this.container, true), this.container) : 0;
        int parH = parentSize ? this.lc.getHeight().constrain(this.container.getHeight(), Grid.getParentSize(this.container, false), this.container) : 0;
        int insX = LayoutUtil.getInsets(this.lc, 0, defIns).getPixels(0.0f, this.container, null);
        int insY = LayoutUtil.getInsets(this.lc, 1, defIns).getPixels(0.0f, this.container, null);
        int visW = parW - insX - LayoutUtil.getInsets(this.lc, 2, defIns).getPixels(0.0f, this.container, null);
        int visH = parH - insY - LayoutUtil.getInsets(this.lc, 3, defIns).getPixels(0.0f, this.container, null);
        LinkHandler.setBounds(lay, "visual", insX, insY, visW, visH, true, false);
        LinkHandler.setBounds(lay, "container", 0, 0, parW, parH, true, false);
    }

    private static LinkedDimGroup getGroupContaining(ArrayList<LinkedDimGroup>[] groupLists, CompWrap cw2) {
        for (ArrayList<LinkedDimGroup> groups : groupLists) {
            for (LinkedDimGroup group : groups) {
                ArrayList cwList = group._compWraps;
                for (CompWrap aCwList : cwList) {
                    if (aCwList != cw2) continue;
                    return group;
                }
            }
        }
        return null;
    }

    private boolean doAbsoluteCorrections(CompWrap cw2, int[] bounds) {
        boolean changed = false;
        int[] stSz = this.getAbsoluteDimBounds(cw2, bounds[2], true);
        if (stSz != null) {
            cw2.setDimBounds(stSz[0], stSz[1], true);
        }
        if ((stSz = this.getAbsoluteDimBounds(cw2, bounds[3], false)) != null) {
            cw2.setDimBounds(stSz[0], stSz[1], false);
        }
        if (this.linkTargetIDs != null) {
            changed = this.setLinkedBounds(cw2.comp, cw2.cc, cw2.x, cw2.y, cw2.w, cw2.h, false);
        }
        return changed;
    }

    private void adjustSizeForAbsolute(boolean isHor) {
        int[] curSizes = isHor ? this.width : this.height;
        Cell absCell = this.grid.get(null);
        if (absCell == null || absCell.compWraps.size() == 0) {
            return;
        }
        ArrayList cws = absCell.compWraps;
        int maxEnd = 0;
        int cwSz = absCell.compWraps.size();
        for (int j10 = 0; j10 < cwSz + 3; ++j10) {
            boolean doAgain = false;
            for (int i10 = 0; i10 < cwSz; ++i10) {
                CompWrap cw2 = (CompWrap)cws.get(i10);
                int[] stSz = this.getAbsoluteDimBounds(cw2, 0, isHor);
                int end = stSz[0] + stSz[1];
                if (maxEnd < end) {
                    maxEnd = end;
                }
                if (this.linkTargetIDs == null) continue;
                doAgain |= this.setLinkedBounds(cw2.comp, cw2.cc, stSz[0], stSz[0], stSz[1], stSz[1], false);
            }
            if (!doAgain) break;
            maxEnd = 0;
            this.clearGroupLinkBounds();
        }
        if (curSizes[0] < (maxEnd += LayoutUtil.getInsets(this.lc, isHor ? 3 : 2, !this.hasDocks()).getPixels(0.0f, this.container, null))) {
            curSizes[0] = maxEnd;
        }
        if (curSizes[1] < maxEnd) {
            curSizes[1] = maxEnd;
        }
    }

    private int[] getAbsoluteDimBounds(CompWrap cw2, int refSize, boolean isHor) {
        int sz2;
        if (cw2.cc.isExternal()) {
            if (isHor) {
                return new int[]{cw2.comp.getX(), cw2.comp.getWidth()};
            }
            return new int[]{cw2.comp.getY(), cw2.comp.getHeight()};
        }
        UnitValue[] pad = cw2.cc.getPadding();
        UnitValue[] pos = this.getPos(cw2.comp, cw2.cc);
        if (pos == null && pad == null) {
            return null;
        }
        int st2 = isHor ? cw2.x : cw2.y;
        int n10 = sz2 = isHor ? cw2.w : cw2.h;
        if (pos != null) {
            UnitValue stUV = pos[isHor ? 0 : 1];
            UnitValue endUV = pos[isHor ? 2 : 3];
            int minSz = cw2.getSize(0, isHor);
            int maxSz = cw2.getSize(2, isHor);
            sz2 = Math.min(Math.max(cw2.getSize(1, isHor), minSz), maxSz);
            if (stUV != null) {
                st2 = stUV.getPixels(stUV.getUnit() == 12 ? (float)sz2 : (float)refSize, this.container, cw2.comp);
                if (endUV != null) {
                    sz2 = Math.min(Math.max((isHor ? cw2.x + cw2.w : cw2.y + cw2.h) - st2, minSz), maxSz);
                }
            }
            if (endUV != null) {
                if (stUV != null) {
                    sz2 = Math.min(Math.max(endUV.getPixels(refSize, this.container, cw2.comp) - st2, minSz), maxSz);
                } else {
                    st2 = endUV.getPixels(refSize, this.container, cw2.comp) - sz2;
                }
            }
        }
        if (pad != null) {
            UnitValue uv2 = pad[isHor ? 1 : 0];
            int p10 = uv2 != null ? uv2.getPixels(refSize, this.container, cw2.comp) : 0;
            st2 += p10;
            uv2 = pad[isHor ? 3 : 2];
            sz2 += -p10 + (uv2 != null ? uv2.getPixels(refSize, this.container, cw2.comp) : 0);
        }
        return new int[]{st2, sz2};
    }

    private void layoutInOneDim(int refSize, UnitValue align, boolean isRows, Float[] defaultPushWeights) {
        int curPos;
        boolean fromEnd = !(!isRows ? LayoutUtil.isLeftToRight(this.lc, this.container) : this.lc.isTopToBottom());
        DimConstraint[] primDCs = (isRows ? this.rowConstr : this.colConstr).getConstaints();
        FlowSizeSpec fss = isRows ? this.rowFlowSpecs : this.colFlowSpecs;
        ArrayList<LinkedDimGroup>[] rowCols = isRows ? this.rowGroupLists : this.colGroupLists;
        int[] rowColSizes = LayoutUtil.calculateSerial(fss.sizes, fss.resConstsInclGaps, defaultPushWeights, 1, refSize);
        if (LayoutUtil.isDesignTime(this.container)) {
            TreeSet<Integer> indexes = isRows ? this.rowIndexes : this.colIndexes;
            int[] ixArr = new int[indexes.size()];
            int ix2 = 0;
            for (Integer i10 : indexes) {
                ixArr[ix2++] = i10;
            }
            Grid.putSizesAndIndexes(this.container.getComponent(), rowColSizes, ixArr, isRows);
        }
        int n10 = curPos = align != null ? align.getPixels(refSize - LayoutUtil.sum(rowColSizes), this.container, null) : 0;
        if (fromEnd) {
            curPos = refSize - curPos;
        }
        for (int i11 = 0; i11 < rowCols.length; ++i11) {
            ArrayList<LinkedDimGroup> linkedGroups = rowCols[i11];
            int scIx = i11 - (isRows ? this.dockOffY : this.dockOffX);
            int bIx = i11 << 1;
            int bIx2 = bIx + 1;
            curPos += fromEnd ? -rowColSizes[bIx] : rowColSizes[bIx];
            DimConstraint primDC = scIx >= 0 ? primDCs[scIx >= primDCs.length ? primDCs.length - 1 : scIx] : DOCK_DIM_CONSTRAINT;
            int rowSize = rowColSizes[bIx2];
            for (LinkedDimGroup group : linkedGroups) {
                int groupSize = rowSize;
                if (group.span > 1) {
                    groupSize = LayoutUtil.sum(rowColSizes, bIx2, Math.min((group.span << 1) - 1, rowColSizes.length - bIx2 - 1));
                }
                group.layout(primDC, curPos, groupSize, group.span);
            }
            curPos += fromEnd ? -rowSize : rowSize;
        }
    }

    private static void addToSizeGroup(HashMap<String, int[]> sizeGroups, String sizeGroup, int[] size) {
        int[] sgSize = sizeGroups.get(sizeGroup);
        if (sgSize == null) {
            sizeGroups.put(sizeGroup, new int[]{size[0], size[1], size[2]});
        } else {
            sgSize[0] = Math.max(size[0], sgSize[0]);
            sgSize[1] = Math.max(size[1], sgSize[1]);
            sgSize[2] = Math.min(size[2], sgSize[2]);
        }
    }

    private static HashMap<String, Integer> addToEndGroup(HashMap<String, Integer> endGroups, String endGroup, int end) {
        if (endGroup != null) {
            Integer oldEnd;
            if (endGroups == null) {
                endGroups = new HashMap(4);
            }
            if ((oldEnd = endGroups.get(endGroup)) == null || end > oldEnd) {
                endGroups.put(endGroup, end);
            }
        }
        return endGroups;
    }

    private FlowSizeSpec calcRowsOrColsSizes(boolean isHor, int containerSize) {
        int r10;
        BoundSize cSz;
        Float[] defPush;
        ArrayList<LinkedDimGroup>[] groupsLists = isHor ? this.colGroupLists : this.rowGroupLists;
        Float[] floatArray = defPush = isHor ? this.pushXs : this.pushYs;
        if (containerSize <= 0) {
            containerSize = isHor ? this.container.getWidth() : this.container.getHeight();
        }
        BoundSize boundSize = cSz = isHor ? this.lc.getWidth() : this.lc.getHeight();
        if (!cSz.isUnset()) {
            containerSize = cSz.constrain(containerSize, Grid.getParentSize(this.container, isHor), this.container);
        }
        DimConstraint[] primDCs = (isHor ? this.colConstr : this.rowConstr).getConstaints();
        TreeSet<Integer> primIndexes = isHor ? this.colIndexes : this.rowIndexes;
        int[][] rowColBoundSizes = new int[primIndexes.size()][];
        HashMap<String, int[]> sizeGroupMap = new HashMap<String, int[]>(4);
        DimConstraint[] allDCs = new DimConstraint[primIndexes.size()];
        Iterator<Integer> primIt = primIndexes.iterator();
        for (r10 = 0; r10 < rowColBoundSizes.length; ++r10) {
            int cellIx = primIt.next();
            int[] rowColSizes = new int[3];
            allDCs[r10] = cellIx >= -30000 && cellIx <= 30000 ? primDCs[cellIx >= primDCs.length ? primDCs.length - 1 : cellIx] : DOCK_DIM_CONSTRAINT;
            ArrayList<LinkedDimGroup> groups = groupsLists[r10];
            int[] groupSizes = new int[]{Grid.getTotalGroupsSizeParallel(groups, 0, false), Grid.getTotalGroupsSizeParallel(groups, 1, false), 2097051};
            Grid.correctMinMax(groupSizes);
            BoundSize dimSize = allDCs[r10].getSize();
            for (int sType = 0; sType <= 2; ++sType) {
                int rowColSize = groupSizes[sType];
                UnitValue uv2 = dimSize.getSize(sType);
                if (uv2 != null) {
                    int unit = uv2.getUnit();
                    rowColSize = unit == 14 ? groupSizes[1] : (unit == 13 ? groupSizes[0] : (unit == 15 ? groupSizes[2] : uv2.getPixels(containerSize, this.container, null)));
                } else if (cellIx >= -30000 && cellIx <= 30000 && rowColSize == 0) {
                    rowColSize = LayoutUtil.isDesignTime(this.container) ? LayoutUtil.getDesignTimeEmptySize() : 0;
                }
                rowColSizes[sType] = rowColSize;
            }
            Grid.correctMinMax(rowColSizes);
            Grid.addToSizeGroup(sizeGroupMap, allDCs[r10].getSizeGroup(), rowColSizes);
            rowColBoundSizes[r10] = rowColSizes;
        }
        if (sizeGroupMap.size() > 0) {
            for (r10 = 0; r10 < rowColBoundSizes.length; ++r10) {
                if (allDCs[r10].getSizeGroup() == null) continue;
                rowColBoundSizes[r10] = (int[])sizeGroupMap.get(allDCs[r10].getSizeGroup());
            }
        }
        ResizeConstraint[] resConstrs = Grid.getRowResizeConstraints(allDCs);
        boolean[] fillInPushGaps = new boolean[allDCs.length + 1];
        int[][] gapSizes = this.getRowGaps(allDCs, containerSize, isHor, fillInPushGaps);
        FlowSizeSpec fss = Grid.mergeSizesGapsAndResConstrs(resConstrs, fillInPushGaps, rowColBoundSizes, gapSizes);
        this.adjustMinPrefForSpanningComps(allDCs, defPush, fss, groupsLists);
        return fss;
    }

    private static int getParentSize(ComponentWrapper cw2, boolean isHor) {
        ContainerWrapper p10 = cw2.getParent();
        return p10 != null ? (isHor ? cw2.getWidth() : cw2.getHeight()) : 0;
    }

    private int[] getMinPrefMaxSumSize(boolean isHor, int[][] sizes) {
        int[] retSizes = new int[3];
        BoundSize sz2 = isHor ? this.lc.getWidth() : this.lc.getHeight();
        for (int i10 = 0; i10 < sizes.length; ++i10) {
            if (sizes[i10] == null) continue;
            int[] size = sizes[i10];
            for (int sType = 0; sType <= 2; ++sType) {
                if (sz2.getSize(sType) != null) {
                    if (i10 != 0) continue;
                    retSizes[sType] = sz2.getSize(sType).getPixels(Grid.getParentSize(this.container, isHor), this.container, null);
                    continue;
                }
                int s10 = size[sType];
                if (s10 != -2147471302) {
                    if (sType == 1) {
                        int bnd = size[2];
                        if (bnd != -2147471302 && bnd < s10) {
                            s10 = bnd;
                        }
                        if ((bnd = size[0]) > s10) {
                            s10 = bnd;
                        }
                    }
                    int n10 = sType;
                    retSizes[n10] = retSizes[n10] + s10;
                }
                if (size[2] != -2147471302 && retSizes[2] <= 2097051) continue;
                retSizes[2] = 2097051;
            }
        }
        Grid.correctMinMax(retSizes);
        return retSizes;
    }

    private static ResizeConstraint[] getRowResizeConstraints(DimConstraint[] specs) {
        ResizeConstraint[] resConsts = new ResizeConstraint[specs.length];
        for (int i10 = 0; i10 < resConsts.length; ++i10) {
            resConsts[i10] = specs[i10].resize;
        }
        return resConsts;
    }

    private static ResizeConstraint[] getComponentResizeConstraints(ArrayList<CompWrap> compWraps, boolean isHor) {
        ResizeConstraint[] resConsts = new ResizeConstraint[compWraps.size()];
        for (int i10 = 0; i10 < resConsts.length; ++i10) {
            CC fc2 = compWraps.get(i10).cc;
            resConsts[i10] = fc2.getDimConstraint((boolean)isHor).resize;
            int dock = fc2.getDockSide();
            if (!(isHor ? dock == 0 || dock == 2 : dock == 1 || dock == 3)) continue;
            ResizeConstraint dc2 = resConsts[i10];
            resConsts[i10] = new ResizeConstraint(dc2.shrinkPrio, dc2.shrink, dc2.growPrio, ResizeConstraint.WEIGHT_100);
        }
        return resConsts;
    }

    private static boolean[] getComponentGapPush(ArrayList<CompWrap> compWraps, boolean isHor) {
        boolean[] barr = new boolean[compWraps.size() + 1];
        for (int i10 = 0; i10 < barr.length; ++i10) {
            boolean push;
            boolean bl2 = push = i10 > 0 && compWraps.get(i10 - 1).isPushGap(isHor, false);
            if (!push && i10 < barr.length - 1) {
                push = compWraps.get(i10).isPushGap(isHor, true);
            }
            barr[i10] = push;
        }
        return barr;
    }

    private int[][] getRowGaps(DimConstraint[] specs, int refSize, boolean isHor, boolean[] fillInPushGaps) {
        BoundSize defGap;
        BoundSize boundSize = defGap = isHor ? this.lc.getGridGapX() : this.lc.getGridGapY();
        if (defGap == null) {
            defGap = isHor ? PlatformDefaults.getGridGapX() : PlatformDefaults.getGridGapY();
        }
        int[] defGapArr = defGap.getPixelSizes(refSize, this.container, null);
        boolean defIns = !this.hasDocks();
        UnitValue firstGap = LayoutUtil.getInsets(this.lc, isHor ? 1 : 0, defIns);
        UnitValue lastGap = LayoutUtil.getInsets(this.lc, isHor ? 3 : 2, defIns);
        int[][] retValues = new int[specs.length + 1][];
        int wgIx = 0;
        for (int i10 = 0; i10 < retValues.length; ++i10) {
            BoundSize wrapGapSize;
            boolean edgeAfter;
            DimConstraint specBefore = i10 > 0 ? specs[i10 - 1] : null;
            DimConstraint specAfter = i10 < specs.length ? specs[i10] : null;
            boolean edgeBefore = specBefore == DOCK_DIM_CONSTRAINT || specBefore == null;
            boolean bl2 = edgeAfter = specAfter == DOCK_DIM_CONSTRAINT || specAfter == null;
            if (edgeBefore && edgeAfter) continue;
            BoundSize boundSize2 = wrapGapSize = this.wrapGapMap == null || isHor == this.lc.isFlowX() ? null : this.wrapGapMap.get(wgIx++);
            if (wrapGapSize == null) {
                int[] gapAfter;
                int[] gapBefore = specBefore != null ? specBefore.getRowGaps(this.container, null, refSize, false) : null;
                int[] nArray = gapAfter = specAfter != null ? specAfter.getRowGaps(this.container, null, refSize, true) : null;
                if (edgeBefore && gapAfter == null && firstGap != null) {
                    int bef = firstGap.getPixels(refSize, this.container, null);
                    retValues[i10] = new int[]{bef, bef, bef};
                } else if (edgeAfter && gapBefore == null && firstGap != null) {
                    int aft2 = lastGap.getPixels(refSize, this.container, null);
                    retValues[i10] = new int[]{aft2, aft2, aft2};
                } else {
                    int[] nArray2;
                    if (gapAfter != gapBefore) {
                        nArray2 = Grid.mergeSizes(gapAfter, gapBefore);
                    } else {
                        int[] nArray3 = new int[3];
                        nArray3[0] = defGapArr[0];
                        nArray3[1] = defGapArr[1];
                        nArray2 = nArray3;
                        nArray3[2] = defGapArr[2];
                    }
                    retValues[i10] = nArray2;
                }
                if ((specBefore == null || !specBefore.isGapAfterPush()) && (specAfter == null || !specAfter.isGapBeforePush())) continue;
                fillInPushGaps[i10] = true;
                continue;
            }
            retValues[i10] = wrapGapSize.isUnset() ? new int[]{defGapArr[0], defGapArr[1], defGapArr[2]} : wrapGapSize.getPixelSizes(refSize, this.container, null);
            fillInPushGaps[i10] = wrapGapSize.getGapPush();
        }
        return retValues;
    }

    private static int[][] getGaps(ArrayList<CompWrap> compWraps, boolean isHor) {
        int compCount = compWraps.size();
        int[][] retValues = new int[compCount + 1][];
        retValues[0] = compWraps.get(0).getGaps(isHor, true);
        for (int i10 = 0; i10 < compCount; ++i10) {
            int[] gap1 = compWraps.get(i10).getGaps(isHor, false);
            int[] gap2 = i10 < compCount - 1 ? compWraps.get(i10 + 1).getGaps(isHor, true) : null;
            retValues[i10 + 1] = Grid.mergeSizes(gap1, gap2);
        }
        return retValues;
    }

    private boolean hasDocks() {
        return this.dockOffX > 0 || this.dockOffY > 0 || this.rowIndexes.last() > 30000 || this.colIndexes.last() > 30000;
    }

    private void adjustMinPrefForSpanningComps(DimConstraint[] specs, Float[] defPush, FlowSizeSpec fss, ArrayList<LinkedDimGroup>[] groupsLists) {
        for (int r10 = groupsLists.length - 1; r10 >= 0; --r10) {
            ArrayList<LinkedDimGroup> groups = groupsLists[r10];
            for (LinkedDimGroup group : groups) {
                if (group.span == 1) continue;
                int[] sizes = group.getMinPrefMax();
                for (int s10 = 0; s10 <= 1; ++s10) {
                    int cSize = sizes[s10];
                    if (cSize == -2147471302) continue;
                    int rowSize = 0;
                    int sIx = (r10 << 1) + 1;
                    int len = Math.min(group.span << 1, fss.sizes.length - sIx) - 1;
                    for (int j10 = sIx; j10 < sIx + len; ++j10) {
                        int sz2 = fss.sizes[j10][s10];
                        if (sz2 == -2147471302) continue;
                        rowSize += sz2;
                    }
                    if (rowSize >= cSize || len <= 0) continue;
                    int newRowSize = 0;
                    for (int eagerness = 0; eagerness < 4 && newRowSize < cSize; ++eagerness) {
                        newRowSize = fss.expandSizes(specs, defPush, cSize, sIx, len, s10, eagerness);
                    }
                }
            }
        }
    }

    private ArrayList<LinkedDimGroup>[] divideIntoLinkedGroups(boolean isRows) {
        boolean fromEnd = !(!isRows ? LayoutUtil.isLeftToRight(this.lc, this.container) : this.lc.isTopToBottom());
        TreeSet<Integer> primIndexes = isRows ? this.rowIndexes : this.colIndexes;
        TreeSet<Integer> secIndexes = isRows ? this.colIndexes : this.rowIndexes;
        DimConstraint[] primDCs = (isRows ? this.rowConstr : this.colConstr).getConstaints();
        ArrayList[] groupLists = new ArrayList[primIndexes.size()];
        int gIx = 0;
        for (int i10 : primIndexes) {
            DimConstraint dc2 = i10 >= -30000 && i10 <= 30000 ? primDCs[i10 >= primDCs.length ? primDCs.length - 1 : i10] : DOCK_DIM_CONSTRAINT;
            ArrayList<LinkedDimGroup> groupList = new ArrayList<LinkedDimGroup>(4);
            groupLists[gIx++] = groupList;
            for (Integer ix2 : secIndexes) {
                boolean isPar;
                int span;
                Cell cell = isRows ? this.getCell(i10, ix2) : this.getCell(ix2, i10);
                if (cell == null || cell.compWraps.size() == 0) continue;
                int n10 = span = isRows ? cell.spany : cell.spanx;
                if (span > 1) {
                    span = Grid.convertSpanToSparseGrid(i10, span, primIndexes);
                }
                boolean bl2 = isPar = cell.flowx == isRows;
                if (!isPar && cell.compWraps.size() > 1 || span > 1) {
                    int linkType = isPar ? 1 : 0;
                    LinkedDimGroup lg2 = new LinkedDimGroup("p," + ix2, span, linkType, !isRows, fromEnd);
                    lg2.setCompWraps(cell.compWraps);
                    groupList.add(lg2);
                    continue;
                }
                for (int cwIx = 0; cwIx < cell.compWraps.size(); ++cwIx) {
                    CompWrap cw2 = (CompWrap)cell.compWraps.get(cwIx);
                    boolean rowBaselineAlign = isRows && this.lc.isTopToBottom() && dc2.getAlignOrDefault(!isRows) == UnitValue.BASELINE_IDENTITY;
                    boolean isBaseline = isRows && cw2.isBaselineAlign(rowBaselineAlign);
                    String linkCtx = isBaseline ? "baseline" : null;
                    boolean foundList = false;
                    int lastGl = groupList.size() - 1;
                    for (int glIx = 0; glIx <= lastGl; ++glIx) {
                        LinkedDimGroup group = (LinkedDimGroup)groupList.get(glIx);
                        if (group.linkCtx != linkCtx && (linkCtx == null || !linkCtx.equals(group.linkCtx))) continue;
                        group.addCompWrap(cw2);
                        foundList = true;
                        break;
                    }
                    if (foundList) continue;
                    int linkType = isBaseline ? 2 : 1;
                    LinkedDimGroup lg3 = new LinkedDimGroup(linkCtx, 1, linkType, !isRows, fromEnd);
                    lg3.addCompWrap(cw2);
                    groupList.add(lg3);
                }
            }
        }
        return groupLists;
    }

    private static int convertSpanToSparseGrid(int curIx, int span, TreeSet<Integer> indexes) {
        int lastIx = curIx + span;
        int retSpan = 1;
        for (Integer ix2 : indexes) {
            if (ix2 <= curIx) continue;
            if (ix2 >= lastIx) break;
            ++retSpan;
        }
        return retSpan;
    }

    private boolean isCellFree(int r10, int c10, ArrayList<int[]> occupiedRects) {
        if (this.getCell(r10, c10) != null) {
            return false;
        }
        for (int[] rect : occupiedRects) {
            if (rect[0] > c10 || rect[1] > r10 || rect[0] + rect[2] <= c10 || rect[1] + rect[3] <= r10) continue;
            return false;
        }
        return true;
    }

    private Cell getCell(int r10, int c10) {
        return this.grid.get((r10 << 16) + (c10 & 0xFFFF));
    }

    private void setCell(int r10, int c10, Cell cell) {
        if (c10 < 0 || r10 < 0) {
            throw new IllegalArgumentException("Cell position cannot be negative. row: " + r10 + ", col: " + c10);
        }
        if (c10 > 30000 || r10 > 30000) {
            throw new IllegalArgumentException("Cell position out of bounds. Out of cells. row: " + r10 + ", col: " + c10);
        }
        this.rowIndexes.add(r10);
        this.colIndexes.add(c10);
        this.grid.put((r10 << 16) + (c10 & 0xFFFF), cell);
    }

    private void addDockingCell(int[] dockInsets, int side, CompWrap cw2) {
        int c10;
        int r10;
        int spanx = 1;
        int spany = 1;
        switch (side) {
            case 0: 
            case 2: {
                int n10;
                if (side == 0) {
                    int n11 = dockInsets[0];
                    n10 = n11;
                    dockInsets[0] = n11 + 1;
                } else {
                    int n12 = dockInsets[2];
                    n10 = n12;
                    dockInsets[2] = n12 - 1;
                }
                r10 = n10;
                c10 = dockInsets[1];
                spanx = dockInsets[3] - dockInsets[1] + 1;
                this.colIndexes.add(dockInsets[3]);
                break;
            }
            case 1: 
            case 3: {
                int n13;
                if (side == 1) {
                    int n14 = dockInsets[1];
                    n13 = n14;
                    dockInsets[1] = n14 + 1;
                } else {
                    int n15 = dockInsets[3];
                    n13 = n15;
                    dockInsets[3] = n15 - 1;
                }
                c10 = n13;
                r10 = dockInsets[0];
                spany = dockInsets[2] - dockInsets[0] + 1;
                this.rowIndexes.add(dockInsets[2]);
                break;
            }
            default: {
                throw new IllegalArgumentException("Internal error 123.");
            }
        }
        this.rowIndexes.add(r10);
        this.colIndexes.add(c10);
        this.grid.put((r10 << 16) + (c10 & 0xFFFF), new Cell(cw2, spanx, spany, spanx > 1));
    }

    private static void layoutBaseline(ContainerWrapper parent, ArrayList<CompWrap> compWraps, DimConstraint dc2, int start, int size, int sizeType, int spanCount) {
        AboveBelow aboveBelow = Grid.getBaselineAboveBelow(compWraps, sizeType, true);
        int blRowSize = aboveBelow.sum();
        CC cc2 = compWraps.get(0).cc;
        UnitValue align = cc2.getVertical().getAlign();
        if (spanCount == 1 && align == null) {
            align = dc2.getAlignOrDefault(false);
        }
        if (align == UnitValue.BASELINE_IDENTITY) {
            align = UnitValue.CENTER;
        }
        int offset = start + aboveBelow.maxAbove + (align != null ? Math.max(0, align.getPixels(size - blRowSize, parent, null)) : 0);
        Iterator<CompWrap> iterator = compWraps.iterator();
        while (iterator.hasNext()) {
            CompWrap cw2;
            CompWrap compWrap = cw2 = iterator.next();
            compWrap.y = compWrap.y + offset;
            if (cw2.y + cw2.h <= start + size) continue;
            cw2.h = start + size - cw2.y;
        }
    }

    private static void layoutSerial(ContainerWrapper parent, ArrayList<CompWrap> compWraps, DimConstraint dc2, int start, int size, boolean isHor, int spanCount, boolean fromEnd) {
        FlowSizeSpec fss = Grid.mergeSizesGapsAndResConstrs(Grid.getComponentResizeConstraints(compWraps, isHor), Grid.getComponentGapPush(compWraps, isHor), Grid.getComponentSizes(compWraps, isHor), Grid.getGaps(compWraps, isHor));
        Float[] pushW = dc2.isFill() ? GROW_100 : null;
        int[] sizes = LayoutUtil.calculateSerial(fss.sizes, fss.resConstsInclGaps, pushW, 1, size);
        Grid.setCompWrapBounds(parent, sizes, compWraps, dc2.getAlignOrDefault(isHor), start, size, isHor, fromEnd);
    }

    private static void setCompWrapBounds(ContainerWrapper parent, int[] allSizes, ArrayList<CompWrap> compWraps, UnitValue rowAlign, int start, int size, boolean isHor, boolean fromEnd) {
        int totSize = LayoutUtil.sum(allSizes);
        CC cc2 = compWraps.get(0).cc;
        UnitValue align = Grid.correctAlign(cc2, rowAlign, isHor, fromEnd);
        int cSt = start;
        int slack = size - totSize;
        if (slack > 0 && align != null) {
            int al10 = Math.min(slack, Math.max(0, align.getPixels(slack, parent, null)));
            cSt += fromEnd ? -al10 : al10;
        }
        int bIx = 0;
        int iSz = compWraps.size();
        for (int i10 = 0; i10 < iSz; ++i10) {
            CompWrap cw2 = compWraps.get(i10);
            if (fromEnd) {
                cw2.setDimBounds((cSt -= allSizes[bIx++]) - allSizes[bIx], allSizes[bIx], isHor);
                cSt -= allSizes[bIx++];
                continue;
            }
            cw2.setDimBounds(cSt += allSizes[bIx++], allSizes[bIx], isHor);
            cSt += allSizes[bIx++];
        }
    }

    private static void layoutParallel(ContainerWrapper parent, ArrayList<CompWrap> compWraps, DimConstraint dc2, int start, int size, boolean isHor, boolean fromEnd) {
        int[][] sizes = new int[compWraps.size()][];
        for (int i10 = 0; i10 < sizes.length; ++i10) {
            CompWrap cw2 = compWraps.get(i10);
            DimConstraint cDc = cw2.cc.getDimConstraint(isHor);
            ResizeConstraint[] resConstr = new ResizeConstraint[]{cw2.isPushGap(isHor, true) ? GAP_RC_CONST_PUSH : GAP_RC_CONST, cDc.resize, cw2.isPushGap(isHor, false) ? GAP_RC_CONST_PUSH : GAP_RC_CONST};
            int[][] sz2 = new int[][]{cw2.getGaps(isHor, true), cw2.getSizes(isHor), cw2.getGaps(isHor, false)};
            Float[] pushW = dc2.isFill() ? GROW_100 : null;
            sizes[i10] = LayoutUtil.calculateSerial(sz2, resConstr, pushW, 1, size);
        }
        UnitValue rowAlign = dc2.getAlignOrDefault(isHor);
        Grid.setCompWrapBounds(parent, sizes, compWraps, rowAlign, start, size, isHor, fromEnd);
    }

    private static void setCompWrapBounds(ContainerWrapper parent, int[][] sizes, ArrayList<CompWrap> compWraps, UnitValue rowAlign, int start, int size, boolean isHor, boolean fromEnd) {
        for (int i10 = 0; i10 < sizes.length; ++i10) {
            CompWrap cw2 = compWraps.get(i10);
            UnitValue align = Grid.correctAlign(cw2.cc, rowAlign, isHor, fromEnd);
            int[] cSizes = sizes[i10];
            int gapBef = cSizes[0];
            int cSize = cSizes[1];
            int gapAft = cSizes[2];
            int cSt = fromEnd ? start - gapBef : start + gapBef;
            int slack = size - cSize - gapBef - gapAft;
            if (slack > 0 && align != null) {
                int al10 = Math.min(slack, Math.max(0, align.getPixels(slack, parent, null)));
                cSt += fromEnd ? -al10 : al10;
            }
            cw2.setDimBounds(fromEnd ? cSt - cSize : cSt, cSize, isHor);
        }
    }

    private static UnitValue correctAlign(CC cc2, UnitValue rowAlign, boolean isHor, boolean fromEnd) {
        UnitValue align = (isHor ? cc2.getHorizontal() : cc2.getVertical()).getAlign();
        if (align == null) {
            align = rowAlign;
        }
        if (align == UnitValue.BASELINE_IDENTITY) {
            align = UnitValue.CENTER;
        }
        if (fromEnd) {
            if (align == UnitValue.LEFT) {
                align = UnitValue.RIGHT;
            } else if (align == UnitValue.RIGHT) {
                align = UnitValue.LEFT;
            }
        }
        return align;
    }

    private static AboveBelow getBaselineAboveBelow(ArrayList<CompWrap> compWraps, int sType, boolean centerBaseline) {
        int maxAbove = Integer.MIN_VALUE;
        int maxBelow = Integer.MIN_VALUE;
        for (CompWrap cw2 : compWraps) {
            int height = cw2.getSize(sType, false);
            if (height >= 2097051) {
                return new AboveBelow(1048525, 1048525);
            }
            int baseline = cw2.getBaseline(sType);
            int above = baseline + cw2.getGapBefore(sType, false);
            maxAbove = Math.max(above, maxAbove);
            maxBelow = Math.max(height - baseline + cw2.getGapAfter(sType, false), maxBelow);
            if (!centerBaseline) continue;
            cw2.setDimBounds(-baseline, height, false);
        }
        return new AboveBelow(maxAbove, maxBelow);
    }

    private static int getTotalSizeParallel(ArrayList<CompWrap> compWraps, int sType, boolean isHor) {
        int size = sType == 2 ? 2097051 : 0;
        for (CompWrap cw2 : compWraps) {
            int cwSize = cw2.getSizeInclGaps(sType, isHor);
            if (cwSize >= 2097051) {
                return 2097051;
            }
            if (!(sType == 2 ? cwSize < size : cwSize > size)) continue;
            size = cwSize;
        }
        return Grid.constrainSize(size);
    }

    private static int getTotalSizeSerial(ArrayList<CompWrap> compWraps, int sType, boolean isHor) {
        int totSize = 0;
        int iSz = compWraps.size();
        int lastGapAfter = 0;
        for (int i10 = 0; i10 < iSz; ++i10) {
            CompWrap wrap = compWraps.get(i10);
            int gapBef = wrap.getGapBefore(sType, isHor);
            if (gapBef > lastGapAfter) {
                totSize += gapBef - lastGapAfter;
            }
            totSize += wrap.getSize(sType, isHor);
            lastGapAfter = wrap.getGapAfter(sType, isHor);
            if ((totSize += lastGapAfter) < 2097051) continue;
            return 2097051;
        }
        return Grid.constrainSize(totSize);
    }

    private static int getTotalGroupsSizeParallel(ArrayList<LinkedDimGroup> groups, int sType, boolean countSpanning) {
        int size = sType == 2 ? 2097051 : 0;
        for (LinkedDimGroup group : groups) {
            if (!countSpanning && group.span != 1) continue;
            int grpSize = group.getMinPrefMax()[sType];
            if (grpSize >= 2097051) {
                return 2097051;
            }
            if (!(sType == 2 ? grpSize < size : grpSize > size)) continue;
            size = grpSize;
        }
        return Grid.constrainSize(size);
    }

    private static int[][] getComponentSizes(ArrayList<CompWrap> compWraps, boolean isHor) {
        int[][] compSizes = new int[compWraps.size()][];
        for (int i10 = 0; i10 < compSizes.length; ++i10) {
            compSizes[i10] = compWraps.get(i10).getSizes(isHor);
        }
        return compSizes;
    }

    private static FlowSizeSpec mergeSizesGapsAndResConstrs(ResizeConstraint[] resConstr, boolean[] gapPush, int[][] minPrefMaxSizes, int[][] gapSizes) {
        int[][] sizes = new int[(minPrefMaxSizes.length << 1) + 1][];
        ResizeConstraint[] resConstsInclGaps = new ResizeConstraint[sizes.length];
        sizes[0] = gapSizes[0];
        int i10 = 0;
        int crIx = 1;
        while (i10 < minPrefMaxSizes.length) {
            resConstsInclGaps[crIx] = resConstr[i10];
            sizes[crIx] = minPrefMaxSizes[i10];
            sizes[crIx + 1] = gapSizes[i10 + 1];
            if (sizes[crIx - 1] != null) {
                ResizeConstraint resizeConstraint = resConstsInclGaps[crIx - 1] = gapPush[i10 < gapPush.length ? i10 : gapPush.length - 1] ? GAP_RC_CONST_PUSH : GAP_RC_CONST;
            }
            if (i10 == minPrefMaxSizes.length - 1 && sizes[crIx + 1] != null) {
                resConstsInclGaps[crIx + 1] = gapPush[i10 + 1 < gapPush.length ? i10 + 1 : gapPush.length - 1] ? GAP_RC_CONST_PUSH : GAP_RC_CONST;
            }
            ++i10;
            crIx += 2;
        }
        for (i10 = 0; i10 < sizes.length; ++i10) {
            if (sizes[i10] != null) continue;
            sizes[i10] = new int[3];
        }
        return new FlowSizeSpec(sizes, resConstsInclGaps);
    }

    private static int[] mergeSizes(int[] oldValues, int[] newValues) {
        if (oldValues == null) {
            return newValues;
        }
        if (newValues == null) {
            return oldValues;
        }
        int[] ret = new int[oldValues.length];
        for (int i10 = 0; i10 < ret.length; ++i10) {
            ret[i10] = Grid.mergeSizes(oldValues[i10], newValues[i10], true);
        }
        return ret;
    }

    private static int mergeSizes(int oldValue, int newValue, boolean toMax) {
        if (oldValue == -2147471302 || oldValue == newValue) {
            return newValue;
        }
        if (newValue == -2147471302) {
            return oldValue;
        }
        return toMax != oldValue > newValue ? newValue : oldValue;
    }

    private static int constrainSize(int s10) {
        return s10 > 0 ? (s10 < 2097051 ? s10 : 2097051) : 0;
    }

    private static void correctMinMax(int[] s10) {
        if (s10[0] > s10[2]) {
            s10[0] = s10[2];
        }
        if (s10[1] < s10[0]) {
            s10[1] = s10[0];
        }
        if (s10[1] > s10[2]) {
            s10[1] = s10[2];
        }
    }

    private static Float[] extractSubArray(DimConstraint[] specs, Float[] arr, int ix2, int len) {
        if (arr == null || arr.length < ix2 + len) {
            Float[] growLastArr = new Float[len];
            for (int i10 = ix2 + len - 1; i10 >= 0; i10 -= 2) {
                int specIx = i10 >> 1;
                if (specs[specIx] == DOCK_DIM_CONSTRAINT) continue;
                growLastArr[i10 - ix2] = ResizeConstraint.WEIGHT_100;
                return growLastArr;
            }
            return growLastArr;
        }
        Float[] newArr = new Float[len];
        System.arraycopy(arr, ix2, newArr, 0, len);
        return newArr;
    }

    private static synchronized void putSizesAndIndexes(Object parComp, int[] sizes, int[] ixArr, boolean isRows) {
        if (PARENT_ROWCOL_SIZES_MAP == null) {
            PARENT_ROWCOL_SIZES_MAP = new WeakHashMap[]{new WeakHashMap(4), new WeakHashMap(4)};
        }
        PARENT_ROWCOL_SIZES_MAP[isRows ? 0 : 1].put(parComp, new int[][]{ixArr, sizes});
    }

    static synchronized int[][] getSizesAndIndexes(Object parComp, boolean isRows) {
        if (PARENT_ROWCOL_SIZES_MAP == null) {
            return null;
        }
        return PARENT_ROWCOL_SIZES_MAP[isRows ? 0 : 1].get(parComp);
    }

    private static synchronized void saveGrid(ComponentWrapper parComp, LinkedHashMap<Integer, Cell> grid) {
        if (PARENT_GRIDPOS_MAP == null) {
            PARENT_GRIDPOS_MAP = new WeakHashMap(4);
        }
        ArrayList<WeakCell> weakCells = new ArrayList<WeakCell>(grid.size());
        for (Map.Entry<Integer, Cell> e10 : grid.entrySet()) {
            Cell cell = e10.getValue();
            Integer xyInt = e10.getKey();
            if (xyInt == null) continue;
            int x10 = xyInt << 16 >> 16;
            int y10 = xyInt >> 16;
            for (CompWrap cw2 : cell.compWraps) {
                weakCells.add(new WeakCell(cw2.comp.getComponent(), x10, y10, cell.spanx, cell.spany));
            }
        }
        PARENT_GRIDPOS_MAP.put(parComp.getComponent(), weakCells);
    }

    static synchronized HashMap<Object, int[]> getGridPositions(Object parComp) {
        ArrayList<WeakCell> weakCells;
        ArrayList<WeakCell> arrayList = weakCells = PARENT_GRIDPOS_MAP != null ? PARENT_GRIDPOS_MAP.get(parComp) : null;
        if (weakCells == null) {
            return null;
        }
        HashMap<Object, int[]> retMap = new HashMap<Object, int[]>();
        for (WeakCell wc2 : weakCells) {
            Object component = wc2.componentRef.get();
            if (component == null) continue;
            retMap.put(component, new int[]{wc2.x, wc2.y, wc2.spanX, wc2.spanY});
        }
        return retMap;
    }

    static {
        DOCK_DIM_CONSTRAINT.setGrowPriority(0);
        GAP_RC_CONST = new ResizeConstraint(200, ResizeConstraint.WEIGHT_100, 50, null);
        GAP_RC_CONST_PUSH = new ResizeConstraint(200, ResizeConstraint.WEIGHT_100, 50, ResizeConstraint.WEIGHT_100);
        DEF_CC = new CC();
        PARENT_ROWCOL_SIZES_MAP = null;
        PARENT_GRIDPOS_MAP = null;
    }

    private static class AboveBelow {
        int maxAbove;
        int maxBelow;

        AboveBelow(int maxAbove, int maxBelow) {
            this.maxAbove = maxAbove;
            this.maxBelow = maxBelow;
        }

        int sum() {
            return this.maxAbove + this.maxBelow;
        }
    }

    private static class Cell {
        private final int spanx;
        private final int spany;
        private final boolean flowx;
        private final ArrayList<CompWrap> compWraps = new ArrayList(2);
        private boolean hasTagged = false;

        private Cell(CompWrap cw2) {
            this(cw2, 1, 1, true);
        }

        private Cell(int spanx, int spany, boolean flowx) {
            this(null, spanx, spany, flowx);
        }

        private Cell(CompWrap cw2, int spanx, int spany, boolean flowx) {
            if (cw2 != null) {
                this.compWraps.add(cw2);
            }
            this.spanx = spanx;
            this.spany = spany;
            this.flowx = flowx;
        }
    }

    private final class CompWrap {
        private final ComponentWrapper comp;
        private final CC cc;
        private final int eHideMode;
        private final boolean useVisualPadding;
        private boolean sizesOk = false;
        private boolean isAbsolute;
        private int[][] gaps;
        private final int[] horSizes = new int[3];
        private final int[] verSizes = new int[3];
        private int x = -2147471302;
        private int y = -2147471302;
        private int w = -2147471302;
        private int h = -2147471302;
        private int forcedPushGaps = 0;

        private CompWrap(ComponentWrapper c10, CC cc2, int eHideMode, boolean useVisualPadding) {
            this.comp = c10;
            this.cc = cc2;
            this.eHideMode = eHideMode;
            this.useVisualPadding = useVisualPadding;
            boolean bl2 = this.isAbsolute = cc2.getHorizontal().getSize().isAbsolute() && cc2.getVertical().getSize().isAbsolute();
            if (eHideMode > 1) {
                this.gaps = new int[4][];
                for (int i10 = 0; i10 < this.gaps.length; ++i10) {
                    this.gaps[i10] = new int[3];
                }
            }
        }

        private int[] getSizes(boolean isHor) {
            this.validateSize();
            return isHor ? this.horSizes : this.verSizes;
        }

        private void validateSize() {
            BoundSize[] callbackSz = Grid.this.getCallbackSize(this.comp);
            if (this.isAbsolute && this.sizesOk && callbackSz == null) {
                return;
            }
            if (this.eHideMode <= 0) {
                int contentBias = this.comp.getContentBias();
                int sizeHint = contentBias == -1 ? -1 : (contentBias == 0 ? (this.w != -2147471302 ? this.w : this.comp.getWidth()) : (this.h != -2147471302 ? this.h : this.comp.getHeight()));
                BoundSize hBS = callbackSz != null && callbackSz[0] != null ? callbackSz[0] : this.cc.getHorizontal().getSize();
                BoundSize vBS = callbackSz != null && callbackSz[1] != null ? callbackSz[1] : this.cc.getVertical().getSize();
                block4: for (int i10 = 0; i10 <= 2; ++i10) {
                    switch (contentBias) {
                        default: {
                            this.horSizes[i10] = this.getSize(hBS, i10, true, this.useVisualPadding, -1);
                            this.verSizes[i10] = this.getSize(vBS, i10, false, this.useVisualPadding, -1);
                            continue block4;
                        }
                        case 0: {
                            this.horSizes[i10] = this.getSize(hBS, i10, true, this.useVisualPadding, -1);
                            this.verSizes[i10] = this.getSize(vBS, i10, false, this.useVisualPadding, sizeHint > 0 ? sizeHint : this.horSizes[i10]);
                            continue block4;
                        }
                        case 1: {
                            this.verSizes[i10] = this.getSize(vBS, i10, false, this.useVisualPadding, -1);
                            this.horSizes[i10] = this.getSize(hBS, i10, true, this.useVisualPadding, sizeHint > 0 ? sizeHint : this.verSizes[i10]);
                        }
                    }
                }
                Grid.correctMinMax(this.horSizes);
                Grid.correctMinMax(this.verSizes);
            } else {
                Arrays.fill(this.horSizes, 0);
                Arrays.fill(this.verSizes, 0);
            }
            this.sizesOk = true;
        }

        private int getSize(BoundSize uvs, int sizeType, boolean isHor, boolean useVP, int sizeHint) {
            int size;
            if (uvs == null || uvs.getSize(sizeType) == null) {
                int[] visualPadding;
                switch (sizeType) {
                    case 0: {
                        size = isHor ? this.comp.getMinimumWidth(sizeHint) : this.comp.getMinimumHeight(sizeHint);
                        break;
                    }
                    case 1: {
                        size = isHor ? this.comp.getPreferredWidth(sizeHint) : this.comp.getPreferredHeight(sizeHint);
                        break;
                    }
                    default: {
                        int n10 = size = isHor ? this.comp.getMaximumWidth(sizeHint) : this.comp.getMaximumHeight(sizeHint);
                    }
                }
                if (useVP && (visualPadding = this.comp.getVisualPadding()) != null && visualPadding.length > 0) {
                    size -= isHor ? visualPadding[1] + visualPadding[3] : visualPadding[0] + visualPadding[2];
                }
            } else {
                ContainerWrapper par = this.comp.getParent();
                float refValue = isHor ? (float)par.getWidth() : (float)par.getHeight();
                size = uvs.getSize(sizeType).getPixels(refValue, par, this.comp);
            }
            return size;
        }

        private void calcGaps(ComponentWrapper before, CC befCC, ComponentWrapper after, CC aftCC, String tag, boolean flowX, boolean isLTR) {
            BoundSize befGap;
            ContainerWrapper par = this.comp.getParent();
            int parW = par.getWidth();
            int parH = par.getHeight();
            BoundSize boundSize = before != null ? (flowX ? befCC.getHorizontal() : befCC.getVertical()).getGapAfter() : (befGap = null);
            BoundSize aftGap = after != null ? (flowX ? aftCC.getHorizontal() : aftCC.getVertical()).getGapBefore() : null;
            this.mergeGapSizes(this.cc.getVertical().getComponentGaps(par, this.comp, befGap, flowX ? null : before, tag, parH, 0, isLTR), false, true);
            this.mergeGapSizes(this.cc.getHorizontal().getComponentGaps(par, this.comp, befGap, flowX ? before : null, tag, parW, 1, isLTR), true, true);
            this.mergeGapSizes(this.cc.getVertical().getComponentGaps(par, this.comp, aftGap, flowX ? null : after, tag, parH, 2, isLTR), false, false);
            this.mergeGapSizes(this.cc.getHorizontal().getComponentGaps(par, this.comp, aftGap, flowX ? after : null, tag, parW, 3, isLTR), true, false);
        }

        private void setDimBounds(int start, int size, boolean isHor) {
            if (isHor) {
                if (start != this.x || this.w != size) {
                    this.x = start;
                    this.w = size;
                    if (this.comp.getContentBias() == 0) {
                        this.invalidateSizes();
                    }
                }
            } else if (start != this.y || this.h != size) {
                this.y = start;
                this.h = size;
                if (this.comp.getContentBias() == 1) {
                    this.invalidateSizes();
                }
            }
        }

        void invalidateSizes() {
            this.sizesOk = false;
        }

        private boolean isPushGap(boolean isHor, boolean isBefore) {
            if (isHor && ((isBefore ? 1 : 2) & this.forcedPushGaps) != 0) {
                return true;
            }
            DimConstraint dc2 = this.cc.getDimConstraint(isHor);
            BoundSize s10 = isBefore ? dc2.getGapBefore() : dc2.getGapAfter();
            return s10 != null && s10.getGapPush();
        }

        private void transferBounds(boolean addVisualPadding) {
            int[] visualPadding;
            if (this.cc.isExternal()) {
                return;
            }
            int compX = this.x;
            int compY = this.y;
            int compW = this.w;
            int compH = this.h;
            if (addVisualPadding && (visualPadding = this.comp.getVisualPadding()) != null) {
                compX -= visualPadding[1];
                compY -= visualPadding[0];
                compW += visualPadding[1] + visualPadding[3];
                compH += visualPadding[0] + visualPadding[2];
            }
            this.comp.setBounds(compX, compY, compW, compH);
        }

        private void setForcedSizes(int[] sizes, boolean isHor) {
            if (sizes == null) {
                return;
            }
            System.arraycopy(sizes, 0, this.getSizes(isHor), 0, 3);
            this.sizesOk = true;
        }

        private void setGaps(int[] minPrefMax, int ix2) {
            if (this.gaps == null) {
                this.gaps = new int[][]{null, null, null, null};
            }
            this.gaps[ix2] = minPrefMax;
        }

        private void mergeGapSizes(int[] sizes, boolean isHor, boolean isTL) {
            if (this.gaps == null) {
                this.gaps = new int[][]{null, null, null, null};
            }
            if (sizes == null) {
                return;
            }
            int gapIX = this.getGapIx(isHor, isTL);
            int[] oldGaps = this.gaps[gapIX];
            if (oldGaps == null) {
                oldGaps = new int[]{0, 0, 2097051};
                this.gaps[gapIX] = oldGaps;
            }
            oldGaps[0] = Math.max(sizes[0], oldGaps[0]);
            oldGaps[1] = Math.max(sizes[1], oldGaps[1]);
            oldGaps[2] = Math.min(sizes[2], oldGaps[2]);
        }

        private int getGapIx(boolean isHor, boolean isTL) {
            return isHor ? (isTL ? 1 : 3) : (isTL ? 0 : 2);
        }

        private int getSizeInclGaps(int sizeType, boolean isHor) {
            return this.filter(sizeType, this.getGapBefore(sizeType, isHor) + this.getSize(sizeType, isHor) + this.getGapAfter(sizeType, isHor));
        }

        private int getSize(int sizeType, boolean isHor) {
            return this.filter(sizeType, this.getSizes(isHor)[sizeType]);
        }

        private int getGapBefore(int sizeType, boolean isHor) {
            int[] gaps = this.getGaps(isHor, true);
            return gaps != null ? this.filter(sizeType, gaps[sizeType]) : 0;
        }

        private int getGapAfter(int sizeType, boolean isHor) {
            int[] gaps = this.getGaps(isHor, false);
            return gaps != null ? this.filter(sizeType, gaps[sizeType]) : 0;
        }

        private int[] getGaps(boolean isHor, boolean isTL) {
            return this.gaps[this.getGapIx(isHor, isTL)];
        }

        private int filter(int sizeType, int size) {
            if (size == -2147471302) {
                return sizeType != 2 ? 0 : 2097051;
            }
            return Grid.constrainSize(size);
        }

        private boolean isBaselineAlign(boolean defValue) {
            Float g10 = this.cc.getVertical().getGrow();
            if (g10 != null && g10.intValue() != 0) {
                return false;
            }
            UnitValue al10 = this.cc.getVertical().getAlign();
            return (al10 != null ? al10 == UnitValue.BASELINE_IDENTITY : defValue) && this.comp.hasBaseline();
        }

        private int getBaseline(int sizeType) {
            return this.comp.getBaseline(this.getSize(sizeType, true), this.getSize(sizeType, false));
        }

        void adjustMinHorSizeUp(int minSize) {
            int[] sz2 = this.getSizes(true);
            if (sz2[0] < minSize) {
                sz2[0] = minSize;
            }
            Grid.correctMinMax(sz2);
        }
    }

    private static final class FlowSizeSpec {
        private final int[][] sizes;
        private final ResizeConstraint[] resConstsInclGaps;

        private FlowSizeSpec(int[][] sizes, ResizeConstraint[] resConstsInclGaps) {
            this.sizes = sizes;
            this.resConstsInclGaps = resConstsInclGaps;
        }

        private int expandSizes(DimConstraint[] specs, Float[] defGrow, int targetSize, int fromIx, int len, int sizeType, int eagerness) {
            ResizeConstraint[] resConstr = new ResizeConstraint[len];
            int[][] sizesToExpand = new int[len][];
            for (int i10 = 0; i10 < len; ++i10) {
                int[] minPrefMax = this.sizes[i10 + fromIx];
                sizesToExpand[i10] = new int[]{minPrefMax[sizeType], minPrefMax[1], minPrefMax[2]};
                if (eagerness <= 1 && i10 % 2 == 0) {
                    int cIx = i10 + fromIx - 1 >> 1;
                    DimConstraint spec = (DimConstraint)LayoutUtil.getIndexSafe(specs, cIx);
                    BoundSize sz2 = spec.getSize();
                    if (sizeType == 0 && sz2.getMin() != null && sz2.getMin().getUnit() != 13 || sizeType == 1 && sz2.getPreferred() != null && sz2.getPreferred().getUnit() != 14) continue;
                }
                resConstr[i10] = (ResizeConstraint)LayoutUtil.getIndexSafe(this.resConstsInclGaps, i10 + fromIx);
            }
            Float[] growW = eagerness == 1 || eagerness == 3 ? Grid.extractSubArray(specs, defGrow, fromIx, len) : null;
            int[] newSizes = LayoutUtil.calculateSerial(sizesToExpand, resConstr, growW, 1, targetSize);
            int newSize = 0;
            for (int i11 = 0; i11 < len; ++i11) {
                int s10;
                this.sizes[i11 + fromIx][sizeType] = s10 = newSizes[i11];
                newSize += s10;
            }
            return newSize;
        }
    }

    private static class LinkedDimGroup {
        private static final int TYPE_SERIAL = 0;
        private static final int TYPE_PARALLEL = 1;
        private static final int TYPE_BASELINE = 2;
        private final String linkCtx;
        private final int span;
        private final int linkType;
        private final boolean isHor;
        private final boolean fromEnd;
        private final ArrayList<CompWrap> _compWraps = new ArrayList(4);
        private int lStart = 0;
        private int lSize = 0;

        private LinkedDimGroup(String linkCtx, int span, int linkType, boolean isHor, boolean fromEnd) {
            this.linkCtx = linkCtx;
            this.span = span;
            this.linkType = linkType;
            this.isHor = isHor;
            this.fromEnd = fromEnd;
        }

        private void addCompWrap(CompWrap cw2) {
            this._compWraps.add(cw2);
        }

        private void setCompWraps(ArrayList<CompWrap> cws) {
            if (this._compWraps != cws) {
                this._compWraps.clear();
                this._compWraps.addAll(cws);
            }
        }

        private void layout(DimConstraint dc2, int start, int size, int spanCount) {
            this.lStart = start;
            this.lSize = size;
            if (this._compWraps.isEmpty()) {
                return;
            }
            ContainerWrapper parent = this._compWraps.get(0).comp.getParent();
            if (this.linkType == 1) {
                Grid.layoutParallel(parent, this._compWraps, dc2, start, size, this.isHor, this.fromEnd);
            } else if (this.linkType == 2) {
                Grid.layoutBaseline(parent, this._compWraps, dc2, start, size, 1, spanCount);
            } else {
                Grid.layoutSerial(parent, this._compWraps, dc2, start, size, this.isHor, spanCount, this.fromEnd);
            }
        }

        private int[] getMinPrefMax() {
            int[] sizes = new int[3];
            if (!this._compWraps.isEmpty()) {
                for (int sType = 0; sType <= 1; ++sType) {
                    if (this.linkType == 1) {
                        sizes[sType] = Grid.getTotalSizeParallel(this._compWraps, sType, this.isHor);
                        continue;
                    }
                    if (this.linkType == 2) {
                        AboveBelow aboveBelow = Grid.getBaselineAboveBelow(this._compWraps, sType, false);
                        sizes[sType] = aboveBelow.sum();
                        continue;
                    }
                    sizes[sType] = Grid.getTotalSizeSerial(this._compWraps, sType, this.isHor);
                }
                sizes[2] = 2097051;
            }
            return sizes;
        }
    }

    private static class WeakCell {
        private final WeakReference<Object> componentRef;
        private final int x;
        private final int y;
        private final int spanX;
        private final int spanY;

        private WeakCell(Object component, int x10, int y10, int spanX, int spanY) {
            this.componentRef = new WeakReference<Object>(component);
            this.x = x10;
            this.y = y10;
            this.spanX = spanX;
            this.spanY = spanY;
        }
    }
}

